---
myst:
  html_meta:
    keywords: LaTeX, composition, langues, séparateur décimal
---

# Comment faire de la virgule le séparateur décimal ?

En mode mathématique, TeX utilise par défaut la convention anglophone : 
le point sert de séparateur décimal. Quand TeX sert à mettre en forme 
un document en français, il ne réagit pas à la présence de la virgule 
comme séparateur décimal. Une espace est placée après la virgule. 
Ce qui ne produit pas une présentation conforme aux règles 
typographiques françaises.


## Sans extension

Une solution simple à ce problème, en mode mathématique, consiste à taper
`3{,}14` au lieu de `3,14`. Bien qu'une telle technique puisse produire 
ponctuellement le résultat souhaité, elle ne se généralise que très mal 
à un document entier. Les solutions qui suivent lui sont donc préférables.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\Large Avant :
\[ 123,45 \]

Après :
\[ 123{,}45 \]
\end{document}
```


## Avec l'extension <ctanpkg:decimalcomma>

Dans le mode mathématique de LaTeX, la virgule est, par défaut, 
traitée comme un symbole de ponctuation et est donc suivie d’une espace. 
Ceci est approprié pour les intervalles : \$[a,b]\$ donne [a, b], 
mais n'est pas approprié pour les nombres où la virgule représente 
le séparateur décimal. Par exemple, \$12,5\$ est affiché comme 12, 5 
au lieu de 12,5.

L'extension <ctanpkg:decimalcomma> propose un fonctionnement identique 
à <ctanpkg:ncccomma> mais avec un code plus léger
et sans les incompatibilités. Ceci est détaillé 
dans la [documentation](texdoc:decimalcomma) de l'extension.

Si <ctanpkg:unicode-math> ou <ctanpkg:icomma> sont utilisés, 
ils doivent être chargés avant <ctanpkg:decimalcomma>.


## Avec l'extension <ctanpkg:icomma>

L'extension <ctanpkg:icomma> garantit qu'il n'y aura plus cette espace 
supplémentaire après une virgule. Toutefois, si *vous* placez 
une espace après la virgule (comme dans `f(x, y)` où, en l'absence 
de l'extension, vous n'avez pas besoin de cette espace) alors 
le petit espace habituel après la virgule apparaît.

:::{todo} Ajouter un exemple
:::


## Avec l'extension <ctanpkg:ziffer>

L'extension <ctanpkg:ziffer> est spécifiquement pensée 
pour de la composition en allemand. Elle couvre toutefois le besoin 
soulevé ici, tout en fournissant le signe double moins utilisé 
en allemand (et dans d'autres langues) pour représenter les centimes nuls 
dans un montant en devise.

:::{todo} Ajouter un exemple
:::


## Avec l'extension <ctanpkg:numprint>

L'extension <ctanpkg:numprint> fournit une commande 
`\numprint{`*nombre*`}` qui met en forme son argument *nombre* 
selon les paramètres que vous lui donnez, ou selon les paramètres choisis 
en accord avec la langue que vous avez sélectionnée dans <ctanpkg:babel>. 
Cette commande fonctionne aussi bien dans du texte que 
dans des mathématiques. La commande est également très flexible : 
elle peut regrouper les chiffres de nombres "longs". Cependant, 
l'extension reste moins pratique que <ctanpkg:icomma> ou <ctanpkg:ziffer> 
si vous tapez beaucoup de chiffres.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{numprint}

\begin{document}
\Large \numprint{123456.78}
\end{document}
```


## Avec l'extension <ctanpkg:siunitx>

L'extension <ctanpkg:siunitx> reprend quelques idées de <ctanpkg:numprint>
mais répond à une question plus large : celle de la présentation 
de quantité dans les unités du 
[système international (SI)](wpfr:Syst%C3%A8me_international_d%27unit%C3%A9s). 
Pour le cas présent, elle propose une option permettant de gérer le choix 
du séparateur décimal : `output-decimal-marker`. 
En voici un exemple où l'option est passée dans l'ensmeble du document
avec la commande `\sisetup`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{siunitx}
  \sisetup{output-decimal-marker={,}}

\begin{document}
\Large \num{123456.78}
\end{document}
```


:::{sources}
[The comma as a decimal separator](faquk:FAQ-dec-comma)
:::