# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "CascadeManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.cascading

import raritan.rpc.event

import raritan.rpc.idl


# interface
class CascadeManager(Interface):
    idlType = "cascading.CascadeManager:2.0.2"

    NO_ERROR = 0

    ERR_INVALID_PARAM = 1

    ERR_UNSUPPORTED_ON_PRIMARY_UNIT = 2

    ERR_UNSUPPORTED_ON_LINK_UNIT = 3

    ERR_LINK_ID_IN_USE = 4

    ERR_HOST_IN_USE = 5

    ERR_LINK_UNIT_UNREACHABLE = 6

    ERR_LINK_UNIT_ACCESS_DENIED = 7

    ERR_LINK_UNIT_REFUSED = 8

    ERR_UNIT_BUSY = 9

    ERR_NOT_SUPPORTED = 10

    ERR_PASSWORD_CHANGE_REQUIRED = 11

    ERR_PASSWORD_POLICY = 12

    ERR_LINK_UNIT_COMM_FAILED = 13

    ERR_LINK_UNIT_NOT_SUPPORTED = 14

    ERR_FIRMWARE_VERSION_MISMATCH = 15

    # structure
    class PrimaryUnitSettings(Structure):
        idlType = "cascading.CascadeManager_2_0_2.PrimaryUnitSettings:1.0.0"
        elements = ["caCertChain", "allowOffTimeRangeCerts"]

        def __init__(self, caCertChain="", allowOffTimeRangeCerts=False):
            if not typecheck._is_int(caCertChain):
                typecheck.is_string(caCertChain, AssertionError)
            typecheck.is_bool(allowOffTimeRangeCerts, AssertionError)

            self.caCertChain = caCertChain
            self.allowOffTimeRangeCerts = allowOffTimeRangeCerts

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                caCertChain = json['caCertChain'] if 'caCertChain' in json or not useDefaults else "",
                allowOffTimeRangeCerts = json['allowOffTimeRangeCerts'] if 'allowOffTimeRangeCerts' in json or not useDefaults else False,
            )
            return obj

        def encode(self):
            json = {}
            json['caCertChain'] = str(self.caCertChain)
            json['allowOffTimeRangeCerts'] = self.allowOffTimeRangeCerts
            return json

    # enumeration
    class Role(Enumeration):
        idlType = "cascading.CascadeManager_2_0_2.Role:1.0.0"
        values = ["STANDALONE", "PRIMARY_UNIT", "LINK_UNIT"]

    Role.STANDALONE = Role(0)
    Role.PRIMARY_UNIT = Role(1)
    Role.LINK_UNIT = Role(2)

    # enumeration
    class LinkUnitType(Enumeration):
        idlType = "cascading.CascadeManager_2_0_2.LinkUnitType:1.0.0"
        values = ["NETWORK", "SECURE_SERIAL"]

    LinkUnitType.NETWORK = LinkUnitType(0)
    LinkUnitType.SECURE_SERIAL = LinkUnitType(1)

    # enumeration
    class LinkUnitStatus(Enumeration):
        idlType = "cascading.CascadeManager_2_0_2.LinkUnitStatus:1.0.0"
        values = ["UNKNOWN", "OK", "UNREACHABLE", "ACCESS_DENIED", "FIRMWARE_UPDATE", "FIRMWARE_MISMATCH", "PENDING"]

    LinkUnitStatus.UNKNOWN = LinkUnitStatus(0)
    LinkUnitStatus.OK = LinkUnitStatus(1)
    LinkUnitStatus.UNREACHABLE = LinkUnitStatus(2)
    LinkUnitStatus.ACCESS_DENIED = LinkUnitStatus(3)
    LinkUnitStatus.FIRMWARE_UPDATE = LinkUnitStatus(4)
    LinkUnitStatus.FIRMWARE_MISMATCH = LinkUnitStatus(5)
    LinkUnitStatus.PENDING = LinkUnitStatus(6)
    LinkUnitStatus._fallback = LinkUnitStatus.UNKNOWN

    # structure
    class LinkUnit(Structure):
        idlType = "cascading.CascadeManager_2_0_2.LinkUnit:1.0.0"
        elements = ["type", "host", "status", "fwVersion"]

        def __init__(self, type=None, host="", status=None, fwVersion=""):
            if type is None:
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK
            if status is None:
                status = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.UNKNOWN
            typecheck.is_enum(type, raritan.rpc.cascading.CascadeManager.LinkUnitType, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_enum(status, raritan.rpc.cascading.CascadeManager.LinkUnitStatus, AssertionError)
            if not typecheck._is_int(fwVersion):
                typecheck.is_string(fwVersion, AssertionError)

            self.type = type
            self.host = host
            self.status = status
            self.fwVersion = fwVersion

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK,
                host = json['host'] if 'host' in json or not useDefaults else "",
                status = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.decode(json['status']) if 'status' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkUnitStatus.UNKNOWN,
                fwVersion = json['fwVersion'] if 'fwVersion' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.cascading.CascadeManager.LinkUnitType.encode(self.type)
            json['host'] = str(self.host)
            json['status'] = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.encode(self.status)
            json['fwVersion'] = str(self.fwVersion)
            return json

    # structure
    class Status(Structure):
        idlType = "cascading.CascadeManager_2_0_2.Status:1.0.0"
        elements = ["role", "primaryUnit", "linkUnits"]

        def __init__(self, role=None, primaryUnit="", linkUnits={}):
            if role is None:
                role = raritan.rpc.cascading.CascadeManager.Role.STANDALONE
            typecheck.is_enum(role, raritan.rpc.cascading.CascadeManager.Role, AssertionError)
            if not typecheck._is_int(primaryUnit):
                typecheck.is_string(primaryUnit, AssertionError)

            self.role = role
            self.primaryUnit = primaryUnit
            self.linkUnits = linkUnits

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                role = raritan.rpc.cascading.CascadeManager.Role.decode(json['role']) if 'role' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.Role.STANDALONE,
                primaryUnit = json['primaryUnit'] if 'primaryUnit' in json or not useDefaults else "",
                linkUnits = dict([(
                    elem['key'],
                    raritan.rpc.cascading.CascadeManager.LinkUnit.decode(elem['value'], agent, useDefaults=useDefaults))
                    for elem in json['linkUnits']]) if 'linkUnits' in json or not useDefaults else {},
            )
            return obj

        def encode(self):
            json = {}
            json['role'] = raritan.rpc.cascading.CascadeManager.Role.encode(self.role)
            json['primaryUnit'] = str(self.primaryUnit)
            json['linkUnits'] = [dict(
                key = k,
                value = raritan.rpc.cascading.CascadeManager.LinkUnit.encode(v))
                for k, v in self.linkUnits.items()]
            return json

    # structure
    class LinkPortStatus(Structure):
        idlType = "cascading.CascadeManager_2_0_2.LinkPortStatus:1.0.0"
        elements = ["isSupported", "isLinkDetected", "isLinkingConfirmationNeeded", "connectedNeighborAddr"]

        def __init__(self, isSupported=False, isLinkDetected=False, isLinkingConfirmationNeeded=False, connectedNeighborAddr=""):
            typecheck.is_bool(isSupported, AssertionError)
            typecheck.is_bool(isLinkDetected, AssertionError)
            typecheck.is_bool(isLinkingConfirmationNeeded, AssertionError)
            if not typecheck._is_int(connectedNeighborAddr):
                typecheck.is_string(connectedNeighborAddr, AssertionError)

            self.isSupported = isSupported
            self.isLinkDetected = isLinkDetected
            self.isLinkingConfirmationNeeded = isLinkingConfirmationNeeded
            self.connectedNeighborAddr = connectedNeighborAddr

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                isSupported = json['isSupported'] if 'isSupported' in json or not useDefaults else False,
                isLinkDetected = json['isLinkDetected'] if 'isLinkDetected' in json or not useDefaults else False,
                isLinkingConfirmationNeeded = json['isLinkingConfirmationNeeded'] if 'isLinkingConfirmationNeeded' in json or not useDefaults else False,
                connectedNeighborAddr = json['connectedNeighborAddr'] if 'connectedNeighborAddr' in json or not useDefaults else "",
            )
            return obj

        def encode(self):
            json = {}
            json['isSupported'] = self.isSupported
            json['isLinkDetected'] = self.isLinkDetected
            json['isLinkingConfirmationNeeded'] = self.isLinkingConfirmationNeeded
            json['connectedNeighborAddr'] = str(self.connectedNeighborAddr)
            return json

    # value object
    class RoleChangedEvent(raritan.rpc.idl.Event):
        idlType = "cascading.CascadeManager_2_0_2.RoleChangedEvent:1.0.0"

        def __init__(self, oldRole=None, newRole=None, primaryUnit="", source=None):
            super(raritan.rpc.cascading.CascadeManager.RoleChangedEvent, self).__init__(source)
            if oldRole is None:
                oldRole = raritan.rpc.cascading.CascadeManager.Role.STANDALONE
            if newRole is None:
                newRole = raritan.rpc.cascading.CascadeManager.Role.STANDALONE
            typecheck.is_enum(oldRole, raritan.rpc.cascading.CascadeManager.Role, AssertionError)
            typecheck.is_enum(newRole, raritan.rpc.cascading.CascadeManager.Role, AssertionError)
            if not typecheck._is_int(primaryUnit):
                typecheck.is_string(primaryUnit, AssertionError)

            self.oldRole = oldRole
            self.newRole = newRole
            self.primaryUnit = primaryUnit

        def encode(self):
            json = super(raritan.rpc.cascading.CascadeManager.RoleChangedEvent, self).encode()
            json['oldRole'] = raritan.rpc.cascading.CascadeManager.Role.encode(self.oldRole)
            json['newRole'] = raritan.rpc.cascading.CascadeManager.Role.encode(self.newRole)
            json['primaryUnit'] = str(self.primaryUnit)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldRole = raritan.rpc.cascading.CascadeManager.Role.decode(json['oldRole']) if 'oldRole' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.Role.STANDALONE,
                newRole = raritan.rpc.cascading.CascadeManager.Role.decode(json['newRole']) if 'newRole' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.Role.STANDALONE,
                primaryUnit = json['primaryUnit'] if 'primaryUnit' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldRole", "newRole", "primaryUnit"]
            elements = elements + super(raritan.rpc.cascading.CascadeManager.RoleChangedEvent, self).listElements()
            return elements

    # value object
    class LinkUnitAddedEvent(raritan.rpc.event.UserEvent):
        idlType = "cascading.CascadeManager_2_0_2.LinkUnitAddedEvent:1.0.0"

        def __init__(self, linkId=0, type=None, host="", actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.cascading.CascadeManager.LinkUnitAddedEvent, self).__init__(actUserName, actIpAddr, source)
            if type is None:
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK
            typecheck.is_int(linkId, AssertionError)
            typecheck.is_enum(type, raritan.rpc.cascading.CascadeManager.LinkUnitType, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)

            self.linkId = linkId
            self.type = type
            self.host = host

        def encode(self):
            json = super(raritan.rpc.cascading.CascadeManager.LinkUnitAddedEvent, self).encode()
            json['linkId'] = self.linkId
            json['type'] = raritan.rpc.cascading.CascadeManager.LinkUnitType.encode(self.type)
            json['host'] = str(self.host)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                linkId = json['linkId'] if 'linkId' in json or not useDefaults else 0,
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK,
                host = json['host'] if 'host' in json or not useDefaults else "",
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["linkId", "type", "host"]
            elements = elements + super(raritan.rpc.cascading.CascadeManager.LinkUnitAddedEvent, self).listElements()
            return elements

    # value object
    class LinkUnitReleasedEvent(raritan.rpc.event.UserEvent):
        idlType = "cascading.CascadeManager_2_0_2.LinkUnitReleasedEvent:1.0.0"

        def __init__(self, linkId=0, type=None, host="", actUserName="", actIpAddr="", source=None):
            super(raritan.rpc.cascading.CascadeManager.LinkUnitReleasedEvent, self).__init__(actUserName, actIpAddr, source)
            if type is None:
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK
            typecheck.is_int(linkId, AssertionError)
            typecheck.is_enum(type, raritan.rpc.cascading.CascadeManager.LinkUnitType, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)

            self.linkId = linkId
            self.type = type
            self.host = host

        def encode(self):
            json = super(raritan.rpc.cascading.CascadeManager.LinkUnitReleasedEvent, self).encode()
            json['linkId'] = self.linkId
            json['type'] = raritan.rpc.cascading.CascadeManager.LinkUnitType.encode(self.type)
            json['host'] = str(self.host)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                linkId = json['linkId'] if 'linkId' in json or not useDefaults else 0,
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK,
                host = json['host'] if 'host' in json or not useDefaults else "",
                # for event.UserEvent
                actUserName = json['actUserName'] if 'actUserName' in json or not useDefaults else "",
                actIpAddr = json['actIpAddr'] if 'actIpAddr' in json or not useDefaults else "",
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["linkId", "type", "host"]
            elements = elements + super(raritan.rpc.cascading.CascadeManager.LinkUnitReleasedEvent, self).listElements()
            return elements

    # value object
    class LinkUnitStatusChangedEvent(raritan.rpc.idl.Event):
        idlType = "cascading.CascadeManager_2_0_2.LinkUnitStatusChangedEvent:1.0.0"

        def __init__(self, linkId=0, type=None, host="", oldStatus=None, newStatus=None, source=None):
            super(raritan.rpc.cascading.CascadeManager.LinkUnitStatusChangedEvent, self).__init__(source)
            if type is None:
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK
            if oldStatus is None:
                oldStatus = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.UNKNOWN
            if newStatus is None:
                newStatus = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.UNKNOWN
            typecheck.is_int(linkId, AssertionError)
            typecheck.is_enum(type, raritan.rpc.cascading.CascadeManager.LinkUnitType, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            typecheck.is_enum(oldStatus, raritan.rpc.cascading.CascadeManager.LinkUnitStatus, AssertionError)
            typecheck.is_enum(newStatus, raritan.rpc.cascading.CascadeManager.LinkUnitStatus, AssertionError)

            self.linkId = linkId
            self.type = type
            self.host = host
            self.oldStatus = oldStatus
            self.newStatus = newStatus

        def encode(self):
            json = super(raritan.rpc.cascading.CascadeManager.LinkUnitStatusChangedEvent, self).encode()
            json['linkId'] = self.linkId
            json['type'] = raritan.rpc.cascading.CascadeManager.LinkUnitType.encode(self.type)
            json['host'] = str(self.host)
            json['oldStatus'] = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.encode(self.oldStatus)
            json['newStatus'] = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.encode(self.newStatus)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                linkId = json['linkId'] if 'linkId' in json or not useDefaults else 0,
                type = raritan.rpc.cascading.CascadeManager.LinkUnitType.decode(json['type']) if 'type' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkUnitType.NETWORK,
                host = json['host'] if 'host' in json or not useDefaults else "",
                oldStatus = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.decode(json['oldStatus']) if 'oldStatus' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkUnitStatus.UNKNOWN,
                newStatus = raritan.rpc.cascading.CascadeManager.LinkUnitStatus.decode(json['newStatus']) if 'newStatus' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkUnitStatus.UNKNOWN,
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["linkId", "type", "host", "oldStatus", "newStatus"]
            elements = elements + super(raritan.rpc.cascading.CascadeManager.LinkUnitStatusChangedEvent, self).listElements()
            return elements

    # value object
    class LinkPortStatusChangedEvent(raritan.rpc.idl.Event):
        idlType = "cascading.CascadeManager_2_0_2.LinkPortStatusChangedEvent:1.0.0"

        def __init__(self, oldStatus=None, newStatus=None, source=None):
            super(raritan.rpc.cascading.CascadeManager.LinkPortStatusChangedEvent, self).__init__(source)
            if oldStatus is None:
                oldStatus = raritan.rpc.cascading.CascadeManager.LinkPortStatus()
            if newStatus is None:
                newStatus = raritan.rpc.cascading.CascadeManager.LinkPortStatus()
            typecheck.is_struct(oldStatus, raritan.rpc.cascading.CascadeManager.LinkPortStatus, AssertionError)
            typecheck.is_struct(newStatus, raritan.rpc.cascading.CascadeManager.LinkPortStatus, AssertionError)

            self.oldStatus = oldStatus
            self.newStatus = newStatus

        def encode(self):
            json = super(raritan.rpc.cascading.CascadeManager.LinkPortStatusChangedEvent, self).encode()
            json['oldStatus'] = raritan.rpc.cascading.CascadeManager.LinkPortStatus.encode(self.oldStatus)
            json['newStatus'] = raritan.rpc.cascading.CascadeManager.LinkPortStatus.encode(self.newStatus)
            return json

        @classmethod
        def decode(cls, json, agent, useDefaults=False):
            obj = cls(
                oldStatus = raritan.rpc.cascading.CascadeManager.LinkPortStatus.decode(json['oldStatus'], agent, useDefaults=useDefaults) if 'oldStatus' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkPortStatus(),
                newStatus = raritan.rpc.cascading.CascadeManager.LinkPortStatus.decode(json['newStatus'], agent, useDefaults=useDefaults) if 'newStatus' in json or not useDefaults else raritan.rpc.cascading.CascadeManager.LinkPortStatus(),
                # for idl.Event
                source = Interface.decode(json['source'], agent) if 'source' in json or not useDefaults else None,
            )
            return obj

        def listElements(self):
            elements = ["oldStatus", "newStatus"]
            elements = elements + super(raritan.rpc.cascading.CascadeManager.LinkPortStatusChangedEvent, self).listElements()
            return elements

    class _getPrimaryUnitSettings(Interface.Method):
        name = 'getPrimaryUnitSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.cascading.CascadeManager.PrimaryUnitSettings.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.cascading.CascadeManager.PrimaryUnitSettings, DecodeException)
            return _ret_

    class _setPrimaryUnitSettings(Interface.Method):
        name = 'setPrimaryUnitSettings'

        @staticmethod
        def encode(primaryUnitSettings):
            typecheck.is_struct(primaryUnitSettings, raritan.rpc.cascading.CascadeManager.PrimaryUnitSettings, AssertionError)
            args = {}
            args['primaryUnitSettings'] = raritan.rpc.cascading.CascadeManager.PrimaryUnitSettings.encode(primaryUnitSettings)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getStatus(Interface.Method):
        name = 'getStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.cascading.CascadeManager.Status.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.cascading.CascadeManager.Status, DecodeException)
            return _ret_

    class _getLinkPortStatus(Interface.Method):
        name = 'getLinkPortStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = raritan.rpc.cascading.CascadeManager.LinkPortStatus.decode(rsp['_ret_'], agent, useDefaults=useDefaults)
            typecheck.is_struct(_ret_, raritan.rpc.cascading.CascadeManager.LinkPortStatus, DecodeException)
            return _ret_

    class _addLinkUnit(Interface.Method):
        name = 'addLinkUnit'

        @staticmethod
        def encode(linkId, host, login, password, newPassword):
            typecheck.is_int(linkId, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            if not typecheck._is_int(login):
                typecheck.is_string(login, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            if not typecheck._is_int(newPassword):
                typecheck.is_string(newPassword, AssertionError)
            args = {}
            args['linkId'] = linkId
            args['host'] = str(host)
            args['login'] = str(login)
            args['password'] = str(password)
            args['newPassword'] = str(newPassword)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _addLinkUnit2(Interface.Method):
        name = 'addLinkUnit2'

        @staticmethod
        def encode(linkId, host, login, password, newPassword, disableStrongPasswordReq):
            typecheck.is_int(linkId, AssertionError)
            if not typecheck._is_int(host):
                typecheck.is_string(host, AssertionError)
            if not typecheck._is_int(login):
                typecheck.is_string(login, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            if not typecheck._is_int(newPassword):
                typecheck.is_string(newPassword, AssertionError)
            typecheck.is_bool(disableStrongPasswordReq, AssertionError)
            args = {}
            args['linkId'] = linkId
            args['host'] = str(host)
            args['login'] = str(login)
            args['password'] = str(password)
            args['newPassword'] = str(newPassword)
            args['disableStrongPasswordReq'] = disableStrongPasswordReq
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _releaseLinkUnit(Interface.Method):
        name = 'releaseLinkUnit'

        @staticmethod
        def encode(linkId):
            typecheck.is_int(linkId, AssertionError)
            args = {}
            args['linkId'] = linkId
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _requestLink(Interface.Method):
        name = 'requestLink'

        @staticmethod
        def encode(token):
            if not typecheck._is_int(token):
                typecheck.is_string(token, AssertionError)
            args = {}
            args['token'] = str(token)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _finalizeLink(Interface.Method):
        name = 'finalizeLink'

        @staticmethod
        def encode(token):
            if not typecheck._is_int(token):
                typecheck.is_string(token, AssertionError)
            args = {}
            args['token'] = str(token)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _unlink(Interface.Method):
        name = 'unlink'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            return None

    class _getSupportedRoles(Interface.Method):
        name = 'getSupportedRoles'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.cascading.CascadeManager.Role.decode(x0) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_enum(x0, raritan.rpc.cascading.CascadeManager.Role, DecodeException)
            return _ret_

    class _getSupportedLinkUnitTypes(Interface.Method):
        name = 'getSupportedLinkUnitTypes'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = [raritan.rpc.cascading.CascadeManager.LinkUnitType.decode(x0) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_enum(x0, raritan.rpc.cascading.CascadeManager.LinkUnitType, DecodeException)
            return _ret_

    class _addCascadeLinkUnit(Interface.Method):
        name = 'addCascadeLinkUnit'

        @staticmethod
        def encode(linkId, nodeIndex, login, password, positionDependent):
            typecheck.is_int(linkId, AssertionError)
            typecheck.is_int(nodeIndex, AssertionError)
            if not typecheck._is_int(login):
                typecheck.is_string(login, AssertionError)
            if not typecheck._is_int(password):
                typecheck.is_string(password, AssertionError)
            typecheck.is_bool(positionDependent, AssertionError)
            args = {}
            args['linkId'] = linkId
            args['nodeIndex'] = nodeIndex
            args['login'] = str(login)
            args['password'] = str(password)
            args['positionDependent'] = positionDependent
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _addLinkPortLinkUnit(Interface.Method):
        name = 'addLinkPortLinkUnit'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _addSecureSerialLinkUnit(Interface.Method):
        name = 'addSecureSerialLinkUnit'

        @staticmethod
        def encode(linkId, installKey):
            typecheck.is_int(linkId, AssertionError)
            if not typecheck._is_int(installKey):
                typecheck.is_string(installKey, AssertionError)
            args = {}
            args['linkId'] = linkId
            args['installKey'] = str(installKey)
            return args

        @staticmethod
        def decode(rsp, agent, useDefaults=False):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(CascadeManager, self).__init__(target, agent)
        self.getPrimaryUnitSettings = CascadeManager._getPrimaryUnitSettings(self)
        self.setPrimaryUnitSettings = CascadeManager._setPrimaryUnitSettings(self)
        self.getStatus = CascadeManager._getStatus(self)
        self.getLinkPortStatus = CascadeManager._getLinkPortStatus(self)
        self.addLinkUnit = CascadeManager._addLinkUnit(self)
        self.addLinkUnit2 = CascadeManager._addLinkUnit2(self)
        self.releaseLinkUnit = CascadeManager._releaseLinkUnit(self)
        self.requestLink = CascadeManager._requestLink(self)
        self.finalizeLink = CascadeManager._finalizeLink(self)
        self.unlink = CascadeManager._unlink(self)
        self.getSupportedRoles = CascadeManager._getSupportedRoles(self)
        self.getSupportedLinkUnitTypes = CascadeManager._getSupportedLinkUnitTypes(self)
        self.addCascadeLinkUnit = CascadeManager._addCascadeLinkUnit(self)
        self.addLinkPortLinkUnit = CascadeManager._addLinkPortLinkUnit(self)
        self.addSecureSerialLinkUnit = CascadeManager._addSecureSerialLinkUnit(self)
