/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import oracle.jdbc.driver.BuildInfo;
import oracle.net.ns.NetException;

public abstract class AnoComm {
    static final int STRING_TYPE = 0;
    static final int RAW_TYPE = 1;
    static final int UB1_TYPE = 2;
    static final int UB2_TYPE = 3;
    static final int UB4_TYPE = 4;
    static final int VERSION_TYPE = 5;
    static final int STATUS_TYPE = 6;
    static final int ARRAY_TYPE = 7;
    static final int MIN_TYPE = 0;
    static final int MAX_TYPE = 7;
    static final int UB1_LENGTH = 1;
    static final int UB2_LENGTH = 2;
    static final int UB4_LENGTH = 4;
    static final int VERSION_LENGTH = 4;
    static final int STATUS_LENGTH = 2;
    static final int NA_MAGIC_SIZE = 4;
    static final long DEADBEEF = -559038737L;
    static final int NA_HEADER_SIZE = 13;
    static final int ARRAY_PACKET_HEADER_LENGTH = 10;
    static final int SERVICE_HEADER_LENGTH = 8;
    static final int SUBPACKET_LENGTH = 4;
    static final long NA_MAGIC = -559038737L;
    static final short NO_ERROR = 0;
    private static final boolean DEBUG = false;
    private static long version;

    protected long getVersion() {
        return version;
    }

    protected abstract void flush() throws IOException;

    protected abstract void sendUB1(short var1) throws IOException;

    protected void sendUB2(int value) throws IOException {
        this.sendPktHeader(2, 3);
        this.writeUB2(value);
    }

    protected void sendUB4(long value) throws IOException {
        this.sendPktHeader(4, 4);
        this.writeUB4(value);
    }

    protected void sendUB2Array(int[] nArray) throws IOException {
        this.sendPktHeader(10 + nArray.length * 2, 1);
        this.writeUB4(-559038737L);
        this.writeUB2(3);
        this.writeUB4(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.writeUB2(nArray[i] & 0xFFFF);
        }
    }

    protected void sendStatus(int status) throws IOException {
        this.sendPktHeader(2, 6);
        this.writeUB2(status);
    }

    protected void sendVersion() throws IOException {
        this.sendPktHeader(4, 5);
        this.writeUB4(this.getVersion());
    }

    protected abstract void sendString(String var1) throws IOException;

    protected abstract void sendRaw(byte[] var1) throws IOException;

    protected void sendPktHeader(int length, int type) throws NetException, IOException {
        this.validateType(length, type);
        this.writeUB2(length);
        this.writeUB2(type);
    }

    protected void writeVersion() throws IOException {
        this.writeUB4(this.getVersion());
    }

    protected abstract void writeUB1(short var1) throws IOException;

    protected abstract void writeUB2(int var1) throws IOException;

    protected abstract void writeUB4(long var1) throws IOException;

    protected short receiveUB1() throws NetException, IOException {
        this.receivePktHeader(2);
        short value = this.readUB1();
        return value;
    }

    protected int receiveUB2() throws NetException, IOException {
        this.receivePktHeader(3);
        int value = this.readUB2();
        return value & 0xFFFF;
    }

    protected long receiveUB4() throws NetException, IOException {
        this.receivePktHeader(4);
        long value = this.readUB4();
        return value;
    }

    protected int[] receiveUB2Array() throws NetException, IOException {
        int pktLength = this.receivePktHeader(1);
        long deadbeef = this.readUB4();
        int type = this.readUB2();
        long aLength = this.readUB4();
        int[] intArray = new int[(int)aLength];
        if (deadbeef != -559038737L || type != 3) {
            throw new NetException(18910);
        }
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = this.readUB2();
        }
        return intArray;
    }

    protected int receiveStatus() throws NetException, IOException {
        this.receivePktHeader(6);
        return this.readUB2();
    }

    protected long receiveVersion() throws NetException, IOException {
        this.receivePktHeader(5);
        return this.readUB4();
    }

    protected String receiveString() throws NetException, IOException {
        int receivedLength = this.receivePktHeader(0);
        return new String(this.receiveByteArray(receivedLength));
    }

    protected byte[] receiveRaw() throws NetException, IOException {
        int receivedLength = this.receivePktHeader(1);
        return this.receiveByteArray(receivedLength);
    }

    protected abstract short readUB1() throws NetException, IOException;

    protected int readUB2() throws NetException, IOException {
        byte[] tmpBuffer = new byte[2];
        int value = (int)this.buffer2Value(tmpBuffer);
        return value & 0xFFFF;
    }

    protected long readUB4() throws NetException, IOException {
        byte[] tmpBuffer = new byte[4];
        long value = this.buffer2Value(tmpBuffer);
        return value;
    }

    private int receivePktHeader(int type) throws NetException, IOException {
        int length = this.readUB2();
        int receivedType = this.readUB2();
        this.validateReceivedType(length, receivedType, type);
        return length;
    }

    private void validateReceivedType(int length, int receivedType, int type) throws NetException {
        if (receivedType < 0 || receivedType > 7) {
            throw new NetException(18913);
        }
        if (receivedType != type) {
            throw new NetException(18914);
        }
        switch (type) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (length <= 1) break;
                throw new NetException(18912);
            }
            case 3: 
            case 6: {
                if (length <= 2) break;
                throw new NetException(18912);
            }
            case 4: 
            case 5: {
                if (length <= 4) break;
                throw new NetException(18912);
            }
            case 7: {
                if (length >= 10) break;
                throw new NetException(18912);
            }
            default: {
                throw new NetException(18913);
            }
        }
    }

    protected abstract byte[] receiveByteArray(int var1) throws NetException, IOException;

    protected abstract long buffer2Value(byte[] var1) throws NetException, IOException;

    private void validateType(int length, int type) throws NetException {
        if (type < 0 || type > 7) {
            throw new NetException(18913);
        }
        switch (type) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (length <= 1) break;
                throw new NetException(18912);
            }
            case 3: 
            case 6: {
                if (length <= 2) break;
                throw new NetException(18912);
            }
            case 4: 
            case 5: {
                if (length <= 4) break;
                throw new NetException(18912);
            }
            case 7: {
                if (length >= 10) break;
                throw new NetException(18912);
            }
            default: {
                throw new NetException(18913);
            }
        }
    }

    byte value2Buffer(int value, byte[] tmpBuffer) {
        byte bytes = 0;
        for (int i = tmpBuffer.length - 1; i >= 0; --i) {
            byte by = bytes;
            bytes = (byte)(bytes + 1);
            tmpBuffer[by] = (byte)(value >>> 8 * i & 0xFF);
        }
        return bytes;
    }

    static {
        String[] versionParts = BuildInfo.getDriverVersion().split("\\.");
        version = Integer.parseInt(versionParts[0]) << 24 | Integer.parseInt(versionParts[1]) << 20 | Integer.parseInt(versionParts[2]) << 12 | Integer.parseInt(versionParts[3]) << 8 | Integer.parseInt(versionParts[4]) << 0;
    }
}

