/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.ffmpeg.FrameProducer;
import com.github.kokorin.jaffree.ffmpeg.ImageFormat;
import com.github.kokorin.jaffree.ffmpeg.ImageFormats;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.NutFrameWriter;
import com.github.kokorin.jaffree.ffmpeg.TcpInput;
import com.github.kokorin.jaffree.net.TcpNegotiator;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameInput
extends TcpInput<FrameInput>
implements Input {
    private final FrameInputNegotiator negotiator;
    private static final int DEFAULT_FRAME_ORDERING_BUFFER_MILLIS = 200;
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameInput.class);

    protected FrameInput(FrameWriter frameWriter, String format) {
        this(new FrameInputNegotiator(frameWriter), format);
    }

    private FrameInput(FrameInputNegotiator negotiator, String format) {
        super(negotiator);
        this.negotiator = negotiator;
        super.setFormat(format);
    }

    @Override
    public FrameInput setFrameRate(Number frameRate) {
        return (FrameInput)super.setFrameRate(frameRate);
    }

    @Override
    public FrameInput setFrameRate(String streamSpecifier, Number frameRate) {
        this.negotiator.setFrameRateSet(true);
        return (FrameInput)super.setFrameRate(streamSpecifier, frameRate);
    }

    @Override
    public final FrameInput setFormat(String format) {
        throw new JaffreeException("Format can't be changed");
    }

    public static FrameInput withProducer(FrameProducer producer) {
        return FrameInput.withProducer(producer, ImageFormats.BGR24);
    }

    public static FrameInput withProducerAlpha(FrameProducer producer) {
        return FrameInput.withProducer(producer, ImageFormats.ABGR);
    }

    public static FrameInput withProducer(FrameProducer producer, ImageFormat imageFormat) {
        return FrameInput.withProducer(producer, imageFormat, 200L);
    }

    public static FrameInput withProducer(FrameProducer producer, ImageFormat imageFormat, long frameOrderingBufferMillis) {
        return new FrameInput(new NutFrameWriter(producer, imageFormat, frameOrderingBufferMillis), "nut");
    }

    protected static class FrameInputNegotiator
    implements TcpNegotiator {
        private final FrameWriter frameWriter;
        private boolean frameRateSet;

        public FrameInputNegotiator(FrameWriter frameWriter) {
            this.frameWriter = frameWriter;
        }

        private synchronized void setFrameRateSet(boolean frameRateSet) {
            this.frameRateSet = frameRateSet;
        }

        @Override
        public synchronized void negotiate(Socket socket) throws IOException {
            if (!this.frameRateSet) {
                LOGGER.warn("It's strongly recommended to specify video frame rate, otherwise video encoding may be slower (by 20-50 times) and may produce corrupted video");
            }
            try (OutputStream output = socket.getOutputStream();){
                this.frameWriter.write(output);
            }
        }
    }

    protected static interface FrameWriter {
        public void write(OutputStream var1) throws IOException;
    }
}

