# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Location
      # The request message for {::Google::Cloud::Location::Locations::Client#list_locations Locations.ListLocations}.
      # @!attribute [rw] name
      #   @return [::String]
      #     The resource that owns the locations collection, if applicable.
      # @!attribute [rw] filter
      #   @return [::String]
      #     The standard list filter.
      # @!attribute [rw] page_size
      #   @return [::Integer]
      #     The standard list page size.
      # @!attribute [rw] page_token
      #   @return [::String]
      #     The standard list page token.
      class ListLocationsRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # The response message for {::Google::Cloud::Location::Locations::Client#list_locations Locations.ListLocations}.
      # @!attribute [rw] locations
      #   @return [::Array<::Google::Cloud::Location::Location>]
      #     A list of locations that matches the specified filter in the request.
      # @!attribute [rw] next_page_token
      #   @return [::String]
      #     The standard List next-page token.
      class ListLocationsResponse
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # The request message for {::Google::Cloud::Location::Locations::Client#get_location Locations.GetLocation}.
      # @!attribute [rw] name
      #   @return [::String]
      #     Resource name for the location.
      class GetLocationRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # A resource that represents Google Cloud Platform location.
      # @!attribute [rw] name
      #   @return [::String]
      #     Resource name for the location, which may vary between implementations.
      #     For example: `"projects/example-project/locations/us-east1"`
      # @!attribute [rw] location_id
      #   @return [::String]
      #     The canonical id for this location. For example: `"us-east1"`.
      # @!attribute [rw] display_name
      #   @return [::String]
      #     The friendly name for this location, typically a nearby city name.
      #     For example, "Tokyo".
      # @!attribute [rw] labels
      #   @return [::Google::Protobuf::Map{::String => ::String}]
      #     Cross-service attributes for the location. For example
      #
      #         {"cloud.googleapis.com/region": "us-east1"}
      # @!attribute [rw] metadata
      #   @return [::Google::Protobuf::Any]
      #     Service-specific metadata. For example the available capacity at the given
      #     location.
      class Location
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::String]
        class LabelsEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
