/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.Color;
import java.util.HashMap;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;

public class RenderingOptions {
    private HashMap<String, CustomShapeDefinition> customShapes;
    private boolean dropShadows = true;
    private boolean renderDebugLines = false;
    private boolean antialias = true;
    private boolean fixedSlope = false;
    private int cellWidth = 10;
    private int cellHeight = 14;
    private float scale = 1.0f;
    private Color backgroundColor = Color.white;
    private ImageType imageType = ImageType.PNG;
    private String fontFamily = "Courier";
    private String fontURL = null;

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType type) {
        this.imageType = type;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontURL() {
        return this.fontURL;
    }

    public void setFontURL(String url) {
        this.fontFamily = "Custom";
        this.fontURL = url;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public boolean dropShadows() {
        return this.dropShadows;
    }

    public boolean renderDebugLines() {
        return this.renderDebugLines;
    }

    public float getScale() {
        return this.scale;
    }

    public void setDropShadows(boolean b) {
        this.dropShadows = b;
    }

    public void setRenderDebugLines(boolean b) {
        this.renderDebugLines = b;
    }

    public void setScale(float f) {
        this.scale = f;
        this.cellWidth = (int)((float)this.cellWidth * this.scale);
        this.cellHeight = (int)((float)this.cellHeight * this.scale);
    }

    public boolean performAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean b) {
        this.antialias = b;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean needsTransparency() {
        return this.backgroundColor.getAlpha() < 255;
    }

    public boolean isFixedSlope() {
        return this.fixedSlope;
    }

    public void setFixedSlope(boolean b) {
        this.fixedSlope = b;
    }

    public static enum ImageType {
        PNG,
        SVG;

    }
}

