import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListDistributionsByOwnedResourceCommand, se_ListDistributionsByOwnedResourceCommand, } from "../protocols/Aws_restXml";
export { $Command };
export class ListDistributionsByOwnedResourceCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "ListDistributionsByOwnedResource", {})
    .n("CloudFrontClient", "ListDistributionsByOwnedResourceCommand")
    .f(void 0, void 0)
    .ser(se_ListDistributionsByOwnedResourceCommand)
    .de(de_ListDistributionsByOwnedResourceCommand)
    .build() {
}
