/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.function.Supplier;
import org.opensearch.cluster.DiskUsage;
import org.opensearch.cluster.routing.allocation.DiskThresholdEvaluator;
import org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.opensearch.cluster.routing.allocation.HotNodeDiskThresholdEvaluator;
import org.opensearch.cluster.routing.allocation.WarmNodeDiskThresholdEvaluator;

public class NodeDiskEvaluator
implements DiskThresholdEvaluator {
    private final DiskThresholdEvaluator hotNodeEvaluator;
    private final DiskThresholdEvaluator warmNodeEvaluator;
    private NodeType nodeType;

    public NodeDiskEvaluator(DiskThresholdSettings diskThresholdSettings, Supplier<Double> dataToFileCacheSizeRatioSupplier) {
        this.hotNodeEvaluator = new HotNodeDiskThresholdEvaluator(diskThresholdSettings);
        this.warmNodeEvaluator = new WarmNodeDiskThresholdEvaluator(diskThresholdSettings, dataToFileCacheSizeRatioSupplier);
    }

    public void setNodeType(boolean isWarmNode) {
        this.nodeType = isWarmNode ? NodeType.WARM : NodeType.HOT;
    }

    @Override
    public boolean isNodeExceedingLowWatermark(DiskUsage diskUsage) {
        if (this.nodeType == NodeType.HOT) {
            return this.hotNodeEvaluator.isNodeExceedingLowWatermark(diskUsage);
        }
        return this.warmNodeEvaluator.isNodeExceedingLowWatermark(diskUsage);
    }

    @Override
    public boolean isNodeExceedingHighWatermark(DiskUsage diskUsage) {
        if (this.nodeType == NodeType.HOT) {
            return this.hotNodeEvaluator.isNodeExceedingHighWatermark(diskUsage);
        }
        return this.warmNodeEvaluator.isNodeExceedingHighWatermark(diskUsage);
    }

    @Override
    public boolean isNodeExceedingFloodStageWatermark(DiskUsage diskUsage) {
        if (this.nodeType == NodeType.HOT) {
            return this.hotNodeEvaluator.isNodeExceedingFloodStageWatermark(diskUsage);
        }
        return this.warmNodeEvaluator.isNodeExceedingFloodStageWatermark(diskUsage);
    }

    @Override
    public long getFreeSpaceLowThreshold(long totalSpace) {
        if (this.nodeType == NodeType.HOT) {
            return this.hotNodeEvaluator.getFreeSpaceLowThreshold(totalSpace);
        }
        return this.warmNodeEvaluator.getFreeSpaceLowThreshold(totalSpace);
    }

    @Override
    public long getFreeSpaceHighThreshold(long totalSpace) {
        if (this.nodeType == NodeType.HOT) {
            return this.hotNodeEvaluator.getFreeSpaceHighThreshold(totalSpace);
        }
        return this.warmNodeEvaluator.getFreeSpaceHighThreshold(totalSpace);
    }

    @Override
    public long getFreeSpaceFloodStageThreshold(long totalSpace) {
        if (this.nodeType == NodeType.HOT) {
            return this.hotNodeEvaluator.getFreeSpaceFloodStageThreshold(totalSpace);
        }
        return this.warmNodeEvaluator.getFreeSpaceFloodStageThreshold(totalSpace);
    }

    static enum NodeType {
        HOT,
        WARM;

    }
}

