/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1SetInputStream;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.util.Utils;

public class Attribute
implements Externalizable,
ASN1Object {
    private ASN1ObjectID a;
    private ArrayList<ASN1Object> b;
    private ASN1Sequence c = null;

    public Attribute() {
    }

    public Attribute(ASN1ObjectID aSN1ObjectID) {
        this.a = aSN1ObjectID;
        this.b = new ArrayList();
    }

    public Attribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(aSN1ObjectID);
        this.a(aSN1Object);
    }

    public Attribute(ASN1ObjectID aSN1ObjectID, List<? extends ASN1Object> list) {
        this(aSN1ObjectID);
        this.a(list);
    }

    public Attribute(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1ObjectID a() {
        return this.a;
    }

    public void a(ASN1Object aSN1Object) {
        this.b.add(aSN1Object);
        this.d();
    }

    public void a(List<? extends ASN1Object> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Attribute value set may not be empty");
        }
        this.b.clear();
        this.d();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.b.add(list.get(i));
        }
    }

    public ArrayList<ASN1Object> b() {
        return this.b;
    }

    public int c() {
        return this.b.size();
    }

    public String toString() {
        String string = this.a + " : {";
        Iterator<ASN1Object> iterator = this.b.iterator();
        while (iterator.hasNext()) {
            string = string + " " + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.a = new ASN1ObjectID(aSN1SequenceInputStream);
        this.b = new ArrayList();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(aSN1SequenceInputStream);
        do {
            this.b.add(ASN1Utils.a(aSN1SetInputStream));
        } while (aSN1SequenceInputStream.a());
        aSN1SetInputStream.b();
        aSN1SequenceInputStream.b();
        this.d();
    }

    private void d() {
        this.c = null;
    }

    private ASN1Sequence e() {
        if (this.c == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.a);
            aSN1Sequence.a(new ASN1Set(this.b));
            this.c = aSN1Sequence;
        }
        return this.c;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.e().output(outputStream);
    }

    @Override
    public int length() {
        return this.e().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

