/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.util.KeyWrapper;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class PKCS12ShroudedKeyBag
extends PKCS12Bag {
    private PKCS12Safe c;
    private char[] d;
    private KeyWrapper e;
    private ASN1Sequence f;
    private static final ASN1ObjectID g = new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 2);

    public PKCS12ShroudedKeyBag() {
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe) {
        this.c = pKCS12Safe;
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.a(aSN1Sequence);
    }

    @Override
    void a() {
        this.f = null;
        if (this.c != null) {
            this.c.a();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    public void a(ASN1Sequence aSN1Sequence) throws IOException {
        this.a();
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.a(1);
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.a(0);
        this.e = new KeyWrapper();
        try {
            this.e.initializePKCS8Key(2, Utils.toStream(aSN1Sequence2));
        }
        catch (Exception exception) {
            throw new IOException("Failed to initialize PKCS8 key");
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.h().output(outputStream);
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new IOException(streamableOutputException.toString());
        }
    }

    private ASN1Sequence h() {
        if (this.f != null) {
            return this.f;
        }
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = this.e.getPKCS8Contents();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.a(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 2));
        aSN1Sequence2.a(new ASN1GenericConstructed(aSN1Sequence, 0));
        ASN1Set aSN1Set = this.d();
        if (aSN1Set != null) {
            aSN1Sequence2.a(aSN1Set);
        }
        this.f = aSN1Sequence2;
        return aSN1Sequence2;
    }

    @Override
    public int length() {
        return this.h().length();
    }

    public void a(char[] cArray) {
        this.d = cArray;
        this.a();
    }

    public String e() {
        return this.d != null ? new String(this.d) : this.c.b();
    }

    public char[] f() {
        return this.d != null ? this.d : this.c.c();
    }

    public PrivateKey g() {
        if (this.e == null) {
            return null;
        }
        this.e.setPassword(this.e());
        return this.e.getDecryptedPKCS8Key();
    }

    public String toString() {
        String string = "";
        if (this.a != null) {
            string = string + "friendlyName = \"" + this.a + "\", ";
        }
        if (this.b != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.b) + ", ";
        }
        return string;
    }
}

