/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl.jmx;

import java.util.List;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.Health;
import org.infinispan.health.jmx.HealthJMXExposer;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.Units;

@MBean(objectName="CacheContainerHealth", description="Health Check API")
@Scope(value=Scopes.GLOBAL)
public class HealthJMXExposerImpl
implements HealthJMXExposer {
    private final Health health;

    public HealthJMXExposerImpl(Health health) {
        this.health = health;
    }

    @Override
    @ManagedAttribute(displayName="Number of CPUs in the host", description="Number of CPUs in the host")
    public int getNumberOfCpus() {
        return this.health.getHostInfo().getNumberOfCpus();
    }

    @Override
    @ManagedAttribute(displayName="The amount of total memory (KB) in the host", description="The amount of total memory (KB) in the host", units=Units.KILO_BYTES)
    public long getTotalMemoryKb() {
        return this.health.getHostInfo().getTotalMemoryKb();
    }

    @Override
    @ManagedAttribute(displayName="The amount of free memory (KB) in the host", description="The amount of free memory (KB) in the host", units=Units.KILO_BYTES)
    public long getFreeMemoryKb() {
        return this.health.getHostInfo().getFreeMemoryInKb();
    }

    @Override
    @ManagedAttribute(displayName="Cluster health status", description="Cluster health status")
    public String getClusterHealth() {
        return this.health.getClusterHealth().getHealthStatus().toString();
    }

    @Override
    @ManagedAttribute(displayName="Cluster name", description="Cluster name")
    public String getClusterName() {
        return this.health.getClusterHealth().getClusterName();
    }

    @Override
    @ManagedAttribute(displayName="Total nodes in the cluster", description="Total nodes in the cluster")
    public int getNumberOfNodes() {
        return this.health.getClusterHealth().getNumberOfNodes();
    }

    @Override
    @ManagedAttribute(displayName="Per Cache statuses", description="Per Cache statuses")
    public String[] getCacheHealth() {
        List<CacheHealth> cacheHealths = this.health.getCacheHealth();
        String[] returnValues = new String[cacheHealths.size() * 2];
        for (int i = 0; i < cacheHealths.size(); ++i) {
            returnValues[i * 2] = cacheHealths.get(i).getCacheName();
            returnValues[i * 2 + 1] = cacheHealths.get(i).getStatus().toString();
        }
        return returnValues;
    }
}

