/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.PartitionAssignment;

class PartitionReassignmentReplicas {
    private final List<Integer> removing;
    private final List<Integer> adding;
    private final List<Integer> replicas;

    public PartitionReassignmentReplicas(List<Integer> removing, List<Integer> adding, List<Integer> replicas) {
        this.removing = removing;
        this.adding = adding;
        this.replicas = replicas;
    }

    private static Set<Integer> calculateDifference(List<Integer> a, List<Integer> b) {
        TreeSet<Integer> result = new TreeSet<Integer>(a);
        result.removeAll(b);
        return result;
    }

    PartitionReassignmentReplicas(PartitionAssignment currentAssignment, PartitionAssignment targetAssignment) {
        Set<Integer> removing = PartitionReassignmentReplicas.calculateDifference(currentAssignment.replicas(), targetAssignment.replicas());
        this.removing = new ArrayList<Integer>(removing);
        Set<Integer> adding = PartitionReassignmentReplicas.calculateDifference(targetAssignment.replicas(), currentAssignment.replicas());
        this.adding = new ArrayList<Integer>(adding);
        this.replicas = new ArrayList<Integer>(targetAssignment.replicas());
        this.replicas.addAll(removing);
    }

    List<Integer> removing() {
        return this.removing;
    }

    List<Integer> adding() {
        return this.adding;
    }

    List<Integer> replicas() {
        return this.replicas;
    }

    boolean isReassignmentInProgress() {
        return PartitionReassignmentReplicas.isReassignmentInProgress(this.removing, this.adding);
    }

    static boolean isReassignmentInProgress(PartitionRegistration part) {
        return PartitionReassignmentReplicas.isReassignmentInProgress(Replicas.toList(part.removingReplicas), Replicas.toList(part.addingReplicas));
    }

    private static boolean isReassignmentInProgress(List<Integer> removingReplicas, List<Integer> addingReplicas) {
        return !removingReplicas.isEmpty() || !addingReplicas.isEmpty();
    }

    Optional<CompletedReassignment> maybeCompleteReassignment(List<Integer> targetIsr) {
        if (!this.isReassignmentInProgress()) {
            return Optional.empty();
        }
        ArrayList<Integer> newTargetIsr = new ArrayList<Integer>(targetIsr);
        List<Integer> newTargetReplicas = this.replicas;
        if (!this.removing.isEmpty()) {
            newTargetIsr = new ArrayList(targetIsr.size());
            for (int replica : targetIsr) {
                if (this.removing.contains(replica)) continue;
                newTargetIsr.add(replica);
            }
            if (newTargetIsr.isEmpty()) {
                return Optional.empty();
            }
            newTargetReplicas = new ArrayList<Integer>(this.replicas.size());
            for (int replica : this.replicas) {
                if (this.removing.contains(replica)) continue;
                newTargetReplicas.add(replica);
            }
            if (newTargetReplicas.isEmpty()) {
                return Optional.empty();
            }
        }
        if (!newTargetIsr.containsAll(newTargetReplicas)) {
            return Optional.empty();
        }
        return Optional.of(new CompletedReassignment(newTargetReplicas, newTargetIsr));
    }

    List<Integer> originalReplicas() {
        ArrayList<Integer> replicas = new ArrayList<Integer>(this.replicas);
        replicas.removeAll(this.adding);
        return replicas;
    }

    public int hashCode() {
        return Objects.hash(this.removing, this.adding, this.replicas);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionReassignmentReplicas)) {
            return false;
        }
        PartitionReassignmentReplicas other = (PartitionReassignmentReplicas)o;
        return this.removing.equals(other.removing) && this.adding.equals(other.adding) && this.replicas.equals(other.replicas);
    }

    public String toString() {
        return "PartitionReassignmentReplicas(removing=" + String.valueOf(this.removing) + ", adding=" + String.valueOf(this.adding) + ", replicas=" + String.valueOf(this.replicas) + ")";
    }

    static class CompletedReassignment {
        final List<Integer> replicas;
        final List<Integer> isr;

        public CompletedReassignment(List<Integer> replicas, List<Integer> isr) {
            this.replicas = replicas;
            this.isr = isr;
        }
    }
}

