/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

abstract class SavingAction
extends AbstractRelationEditorAction {
    private static final long serialVersionUID = 1L;
    protected final AutoCompletingTextField tfRole;

    protected SavingAction(IRelationEditorActionAccess editorAccess, IRelationEditorUpdateOn ... updateOn) {
        super(editorAccess, updateOn);
        this.tfRole = editorAccess.getTextFieldRole();
    }

    protected void applyNewRelation(TagEditorModel tagEditorModel) {
        Relation newRelation = new Relation();
        tagEditorModel.applyToPrimitive(newRelation);
        this.getMemberTableModel().applyToRelation(newRelation);
        if (!newRelation.isUseful()) {
            return;
        }
        UndoRedoHandler.getInstance().add(new AddCommand(this.getLayer().getDataSet(), newRelation));
        this.getEditor().setRelation(newRelation);
        if (this.getEditor() instanceof RelationEditor) {
            RelationDialogManager.getRelationDialogManager().updateContext(this.getLayer(), this.getEditor().getRelation(), (RelationEditor)this.getEditor());
        }
        SwingUtilities.invokeLater(() -> MainApplication.getMap().relationListDialog.selectRelation(newRelation));
    }

    protected void applyExistingConflictingRelation(TagEditorModel tagEditorModel) {
        Relation editedRelation = new Relation(this.editorAccess.getEditor().getRelation());
        tagEditorModel.applyToPrimitive(editedRelation);
        this.editorAccess.getMemberTableModel().applyToRelation(editedRelation);
        Conflict<Relation> conflict = new Conflict<Relation>(this.editorAccess.getEditor().getRelation(), editedRelation);
        UndoRedoHandler.getInstance().add(new ConflictAddCommand(this.getLayer().getDataSet(), conflict));
    }

    protected void applyExistingNonConflictingRelation(TagEditorModel tagEditorModel) {
        Command cmdProps;
        Relation originRelation = this.editorAccess.getEditor().getRelation();
        Relation editedRelation = new Relation(originRelation);
        tagEditorModel.applyToPrimitive(editedRelation);
        this.getMemberTableModel().applyToRelation(editedRelation);
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (!originRelation.getMembers().equals(editedRelation.getMembers())) {
            cmds.add(new ChangeMembersCommand(originRelation, editedRelation.getMembers()));
        }
        if ((cmdProps = ChangePropertyCommand.build(originRelation, editedRelation)) != null) {
            cmds.add(cmdProps);
        }
        if (cmds.size() >= 2) {
            UndoRedoHandler.getInstance().add(new ChangeCommand(originRelation, editedRelation));
        } else if (!cmds.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)cmds.get(0));
            editedRelation.setMembers((List<RelationMember>)null);
        }
    }

    protected boolean confirmClosingBecauseOfDirtyState() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, create a conflict and close", new Object[0]), new ImageProvider("ok"), I18n.tr("Click to create a conflict and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, continue editing", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("<html>This relation has been changed outside of the editor.<br>You cannot apply your changes and continue editing.<br><br>Do you want to create a conflict and close the editor?</html>", new Object[0]), I18n.tr("Conflict in data", new Object[0]), 2, null, options, options[0], "/Dialog/RelationEditor#RelationChangedOutsideOfEditor");
        if (ret == 0) {
            MainApplication.getMap().conflictDialog.unfurlDialog();
        }
        return ret == 0;
    }

    protected void warnDoubleConflict() {
        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>Layer ''{0}'' already has a conflict for object<br>''{1}''.<br>Please resolve this conflict first, then try again.</html>", Utils.escapeReservedCharactersHTML(this.getLayer().getName()), Utils.escapeReservedCharactersHTML(this.getEditor().getRelation().getDisplayName(DefaultNameFormatter.getInstance()))), I18n.tr("Double conflict", new Object[0]), 2);
    }

    @Override
    protected void updateEnabledState() {
    }

    protected boolean applyChanges() {
        IRelationEditor editor = this.editorAccess.getEditor();
        if (editor.getRelation() == null) {
            this.applyNewRelation(this.getTagModel());
        } else if (this.isEditorDirty()) {
            if (editor.isDirtyRelation()) {
                if (this.confirmClosingBecauseOfDirtyState()) {
                    if (this.getLayer().getConflicts().hasConflictForMy(editor.getRelation())) {
                        this.warnDoubleConflict();
                        return false;
                    }
                    this.getEditor().setIsSaving(true);
                    this.applyExistingConflictingRelation(this.getTagModel());
                    this.hideEditor();
                    return false;
                }
                return false;
            }
            this.getEditor().setIsSaving(true);
            this.applyExistingNonConflictingRelation(this.getTagModel());
        }
        editor.setRelation(editor.getRelation());
        return true;
    }

    protected void hideEditor() {
        if (this.editorAccess.getEditor() instanceof Component) {
            ((Component)((Object)this.editorAccess.getEditor())).setVisible(false);
            this.editorAccess.getEditor().setRelation(null);
        }
    }

    protected boolean isEditorDirty() {
        return this.editorAccess.getEditor().isDirtyEditor();
    }
}

