/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import java.util.Collection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeStream;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DeletedContentNode;
import org.freeplane.plugin.codeexplorer.map.SaveAction;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.CodeNodeUserContent;
import org.freeplane.plugin.codeexplorer.task.UserDefinedCodeExplorerConfiguration;

public class CodeMapPersistenceManager
extends UrlManager {
    public static CodeMapPersistenceManager getCodeMapPersistenceManager(ModeController modeController) {
        return (CodeMapPersistenceManager)modeController.getExtension(UrlManager.class);
    }

    public CodeMapPersistenceManager() {
        Controller.getCurrentModeController().addAction((AFreeplaneAction)new SaveAction());
    }

    public boolean save(MapModel map) {
        if (!(map instanceof CodeMap)) {
            return false;
        }
        map.setSaved(true);
        CodeMap codemap = (CodeMap)map;
        CodeExplorerConfiguration codeExplorerConfiguration = codemap.getConfiguration();
        if (!(codeExplorerConfiguration instanceof UserDefinedCodeExplorerConfiguration)) {
            return true;
        }
        UserDefinedCodeExplorerConfiguration userDefinedCodeExplorerConfiguration = (UserDefinedCodeExplorerConfiguration)codeExplorerConfiguration;
        userDefinedCodeExplorerConfiguration.removeUserContent();
        NodeStream.of((NodeModel)map.getRootNode()).map(CodeNode.class::cast).filter(CodeNodeUserContent.Factory.INSTANCE::hasCustomContent).forEach(node -> userDefinedCodeExplorerConfiguration.addUserContent(codemap.groupIdByIndex(node.groupIndex), CodeNodeUserContent.Factory.INSTANCE.contentOf((NodeModel)node)));
        userDefinedCodeExplorerConfiguration.getAttributeConfiguration().setAttributeViewType(((AttributeRegistry)map.getExtension(AttributeRegistry.class)).getAttributeViewType());
        return true;
    }

    public void restoreUserContent(CodeMap map) {
        CodeExplorerConfiguration codeExplorerConfiguration = map.getConfiguration();
        if (codeExplorerConfiguration instanceof UserDefinedCodeExplorerConfiguration) {
            UserDefinedCodeExplorerConfiguration configuration = (UserDefinedCodeExplorerConfiguration)codeExplorerConfiguration;
            configuration.getUserContent().entrySet().stream().forEach(content -> this.addToMap(map, (String)content.getKey(), (Collection)content.getValue()));
            String attributeViewType = configuration.getAttributeConfiguration().getAttributeViewType();
            AttributeRegistry.getRegistry((MapModel)map).setAttributeViewType(attributeViewType);
        } else {
            AttributeRegistry.getRegistry((MapModel)map).setAttributeViewType("hide");
        }
        map.setSaved(true);
    }

    private void addToMap(CodeMap map, String groupId, Collection<CodeNodeUserContent> contentCollection) {
        int groupIndex = map.groupIndexOf(groupId);
        contentCollection.forEach(content -> this.addToMap(map, groupIndex, (CodeNodeUserContent)content));
    }

    private void addToMap(CodeMap map, int groupIndex, CodeNodeUserContent content) {
        CodeNode node = this.deletedContentNode(map, groupIndex, content.getNodeIdWithoutGroupIndex());
        content.getDetails().map(CodeNodeUserContent.Factory.INSTANCE::fromCodeNodeDetails).ifPresent(arg_0 -> ((CodeNode)node).addExtension(arg_0));
        this.addAttributes(node, content);
    }

    private CodeNode deletedContentNode(CodeMap map, int groupIndex, String nodeIdWithoutGroupIndex) {
        String deletedNodeText;
        NodeModel parentNode;
        String nodeId = CodeNode.idWithGroupIndex(nodeIdWithoutGroupIndex, groupIndex);
        CodeNode node = (CodeNode)map.getNodeForID(nodeId);
        if (node != null) {
            return node;
        }
        int packageSeparatorPosition = nodeIdWithoutGroupIndex.lastIndexOf(46, nodeIdWithoutGroupIndex.length() - 1 - (nodeIdWithoutGroupIndex.endsWith(".[package]") ? ".[package]".length() : 0));
        if (packageSeparatorPosition == -1) {
            parentNode = map.getRootNode().getChildAt(groupIndex);
            deletedNodeText = nodeIdWithoutGroupIndex;
        } else {
            String parentIdWithoutGroupIndex = nodeIdWithoutGroupIndex.substring(0, packageSeparatorPosition);
            parentNode = this.deletedContentNode(map, groupIndex, parentIdWithoutGroupIndex);
            deletedNodeText = nodeIdWithoutGroupIndex.endsWith(".[package]") ? nodeIdWithoutGroupIndex.substring(packageSeparatorPosition + 1, nodeIdWithoutGroupIndex.length() - ".[package]".length()) + " package" : nodeIdWithoutGroupIndex.substring(packageSeparatorPosition + 1, nodeIdWithoutGroupIndex.length());
        }
        DeletedContentNode deletedContentNode = new DeletedContentNode(map, nodeIdWithoutGroupIndex, groupIndex, deletedNodeText);
        parentNode.insert((NodeModel)deletedContentNode);
        return deletedContentNode;
    }

    private void addAttributes(CodeNode node, CodeNodeUserContent content) {
        content.getAttributes().stream().map(CodeNodeUserContent.Factory.INSTANCE::fromCodeNodeAttribute).forEach(attribute -> {
            NodeAttributeTableModel attributeModel = node.getExtension(NodeAttributeTableModel.class);
            if (attributeModel == null) {
                attributeModel = new NodeAttributeTableModel();
                node.addExtension((IExtension)attributeModel);
            }
            attributeModel.silentlyAddRowNoUndo((NodeModel)node, attribute);
        });
    }
}

