/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileProcessor;
import com.tngtech.archunit.core.importer.ClassFileSource;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.core.importer.ImportOptions;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.core.importer.Locations;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ClassFileImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ClassFileImporter.class);
    private final ImportOptions importOptions;

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ClassFileImporter() {
        this(new ImportOptions());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ClassFileImporter(Collection<ImportOption> importOptions) {
        this(new ImportOptions().with(importOptions));
    }

    private ClassFileImporter(ImportOptions importOptions) {
        this.importOptions = importOptions;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ClassFileImporter withImportOption(ImportOption option) {
        return new ClassFileImporter(this.importOptions.with(option));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ClassFileImporter withImportOptions(Collection<ImportOption> options) {
        return new ClassFileImporter(this.importOptions.with(options));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPath(String path) {
        return this.importPaths(path);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPath(Path path) {
        return this.importPaths(path);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPaths(String ... paths) {
        return this.importPaths(Arrays.stream(paths).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet()));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPaths(Path ... paths) {
        return this.importPaths(ImmutableSet.copyOf(paths));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPaths(Collection<Path> paths) {
        return this.importLocations(paths.stream().map(Location::of).collect(Collectors.toSet()));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importJar(JarFile jar) {
        return this.importJars(jar);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importJars(JarFile ... jarFiles) {
        return this.importJars(ImmutableList.copyOf(jarFiles));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importJars(Iterable<JarFile> jarFiles) {
        HashSet<Location> locations = new HashSet<Location>();
        for (JarFile jarFile : jarFiles) {
            locations.add(Location.of(jarFile));
        }
        return this.importLocations(locations);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPackages(Collection<String> packages) {
        Set<Location> locations = packages.stream().flatMap(pkg -> Locations.ofPackage(pkg).stream()).collect(Collectors.toSet());
        return this.importLocations(locations);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPackages(String ... packages) {
        return this.importPackages(ImmutableSet.copyOf(packages));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPackagesOf(Class<?> ... classes) {
        return this.importPackagesOf(ImmutableSet.copyOf(classes));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importPackagesOf(Collection<Class<?>> classes) {
        return this.importPackages(classes.stream().map(clazz -> clazz.getPackage().getName()).collect(Collectors.toSet()));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importClasspath() {
        return this.importLocations(Locations.inClassPath());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass importClass(Class<?> clazz) {
        return Iterables.getOnlyElement(this.importClasses(clazz));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importClasses(Class<?> ... classes) {
        return this.importClasses(Arrays.asList(classes));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importClasses(Collection<Class<?>> classes) {
        Set<Location> locations = classes.stream().flatMap(clazz -> Locations.ofClass(clazz).stream()).collect(Collectors.toSet());
        return this.importLocations(locations);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importUrl(URL url) {
        return this.importUrls(Collections.singletonList(url));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importUrls(Collection<URL> urls) {
        return this.importLocations(Locations.of(urls));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClasses importLocations(Collection<Location> locations) {
        ArrayList<ClassFileSource> sources = new ArrayList<ClassFileSource>();
        for (Location location : locations) {
            this.tryAdd(sources, location);
        }
        return new ClassFileProcessor().process(this.unify(sources));
    }

    private void tryAdd(List<ClassFileSource> sources, Location location) {
        try {
            sources.add(location.asClassFileSource(this.importOptions));
        }
        catch (Exception e) {
            LOG.warn(String.format("Couldn't derive %s from %s", ClassFileSource.class.getSimpleName(), location), (Throwable)e);
        }
    }

    private ClassFileSource unify(List<ClassFileSource> sources) {
        return Iterables.concat(sources)::iterator;
    }
}

