/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.Alias;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleRevisionImpl;
import org.knopflerfish.framework.BundleWireImpl;
import org.knopflerfish.framework.DTOId;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.Util;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.dto.CapabilityDTO;
import org.osgi.resource.dto.CapabilityRefDTO;

public class BundleCapabilityImpl
extends DTOId
implements BundleCapability {
    private final BundleGeneration gen;
    private final BundleGeneration owner;
    private final String namespace;
    Map<String, Object> attributes;
    Map<String, String> directives;
    private Vector<BundleWireImpl> wires = new Vector(2);

    public BundleCapabilityImpl(BundleGeneration gen, Util.HeaderEntry he) {
        this.gen = gen;
        this.owner = gen;
        this.namespace = he.getKey();
        if (gen.bundle.id != 0L) {
            for (String ns : Arrays.asList("osgi.wiring.bundle", "osgi.wiring.host", "osgi.wiring.package", "osgi.ee", "osgi.identity", "osgi.native")) {
                if (!ns.equals(this.namespace)) continue;
                throw new IllegalArgumentException("Capability with name-space '" + ns + "' must not be provided in the " + "Provide-Capability" + " manifest header.");
            }
        }
        this.attributes = Collections.unmodifiableMap(he.getAttributes());
        this.directives = Collections.unmodifiableMap(he.getDirectives());
    }

    public BundleCapabilityImpl(BundleCapability bc, BundleGeneration bg) {
        this.gen = bg;
        this.owner = ((BundleCapabilityImpl)bc).owner;
        this.namespace = bc.getNamespace();
        this.attributes = bc.getAttributes();
        this.directives = bc.getDirectives();
    }

    public BundleCapabilityImpl(BundleGeneration bg) {
        this.owner = this.gen = bg;
        this.namespace = "osgi.identity";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("osgi.identity", this.gen.symbolicName);
        attrs.put("type", this.gen.fragment != null ? "osgi.fragment" : "osgi.bundle");
        attrs.put("version", this.gen.version);
        if (this.gen.archive != null) {
            String a = this.gen.archive.getAttribute("Bundle-Copyright");
            if (a != null) {
                attrs.put("copyright", a);
            }
            if ((a = this.gen.archive.getAttribute("Bundle-Description")) != null) {
                attrs.put("description", a);
            }
            if ((a = this.gen.archive.getAttribute("Bundle-DocURL")) != null) {
                attrs.put("documentation", a);
            }
            if ((a = this.gen.archive.getAttribute("Bundle-License")) != null) {
                StringBuffer sb = new StringBuffer();
                try {
                    List<Util.HeaderEntry> lic = Util.parseManifestHeader("Bundle-License", a, true, true, false);
                    for (Util.HeaderEntry he : lic) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(he.getKey());
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.gen.bundle.fwCtx.frameworkInfo(this.gen.bundle, iae, new FrameworkListener[0]);
                    sb.append(a);
                }
                attrs.put("license", sb.toString());
            }
        }
        this.attributes = Collections.unmodifiableMap(attrs);
        HashMap<String, String> dirs = new HashMap<String, String>();
        dirs.put("singleton", this.gen.singleton ? "true" : "false");
        this.directives = Collections.unmodifiableMap(dirs);
    }

    BundleCapabilityImpl(BundleGeneration gen, FWProps fwProps) {
        this.gen = gen;
        this.owner = gen;
        this.namespace = "osgi.native";
        this.attributes = fwProps.getFWProperties();
        Iterator<Map.Entry<String, Object>> i = this.attributes.entrySet().iterator();
        while (i.hasNext()) {
            if (!i.next().getKey().startsWith("osgi.native.")) continue;
            i.remove();
        }
        ArrayList<String> proc = new ArrayList<String>(3);
        String procP = fwProps.getProperty("org.osgi.framework.processor");
        proc.add(procP);
        String procS = System.getProperty("os.arch");
        if (!procP.equalsIgnoreCase(procS)) {
            proc.add(procS);
        }
        if (procP.startsWith("arm_")) {
            proc.add("arm");
        }
        for (int i2 = 0; i2 < Alias.processorAliases.length; ++i2) {
            if (!procP.equalsIgnoreCase(Alias.processorAliases[i2][0])) continue;
            for (int j = 1; j < Alias.processorAliases[i2].length; ++j) {
                if (procS.equalsIgnoreCase(Alias.processorAliases[i2][j])) continue;
                proc.add(Alias.processorAliases[i2][j]);
            }
            break;
        }
        this.attributes.put("osgi.native.processor", proc);
        ArrayList<String> os = new ArrayList<String>();
        String osP = fwProps.getProperty("org.osgi.framework.os.name");
        os.add(osP);
        String osS = System.getProperty("os.name");
        if (!osS.equalsIgnoreCase(osP)) {
            os.add(osS);
        }
        for (int i3 = 0; i3 < Alias.osNameAliases.length; ++i3) {
            if (!osP.equalsIgnoreCase(Alias.osNameAliases[i3][0])) continue;
            for (int j = 1; j < Alias.osNameAliases[i3].length; ++j) {
                if (osS.equalsIgnoreCase(Alias.osNameAliases[i3][j])) continue;
                os.add(Alias.osNameAliases[i3][j]);
            }
            break;
        }
        this.attributes.put("osgi.native.osname", os);
        this.attributes.put("osgi.native.osversion", new Version(fwProps.getProperty("org.osgi.framework.os.version")));
        this.attributes.put("osgi.native.language", fwProps.getProperty("org.osgi.framework.language"));
        this.attributes = Collections.unmodifiableMap(this.attributes);
        this.directives = Collections.EMPTY_MAP;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public BundleRevision getRevision() {
        return this.owner.bundleRevision;
    }

    @Override
    public BundleRevision getResource() {
        return this.owner.bundleRevision;
    }

    public String toString() {
        return "BundleCapability[namespace=" + this.namespace + ", attributes=" + this.attributes + ", directives=" + this.directives + ", revision=" + this.getRevision() + "]";
    }

    BundleGeneration getBundleGeneration() {
        return this.gen;
    }

    boolean isEffectiveResolve() {
        String effective = this.directives.get("effective");
        return effective == null || effective.equals("resolve");
    }

    boolean isZombie() {
        return !this.gen.isCurrent();
    }

    void addWire(BundleWireImpl bw) {
        this.wires.add(bw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getWires(List<BundleWireImpl> res) {
        Vector<BundleWireImpl> vector = this.wires;
        synchronized (vector) {
            res.addAll(this.wires);
        }
    }

    void removeWire(BundleWireImpl wire) {
        this.wires.remove(wire);
    }

    void removeWires() {
        this.wires.clear();
    }

    boolean isWired() {
        return !this.wires.isEmpty();
    }

    boolean checkPermission() {
        return this.gen.bundle.fwCtx.perm.hasProvidePermission(this);
    }

    Set<String> getUses() {
        try {
            return Util.parseEnumeration("uses", this.directives.get("uses"));
        }
        catch (IllegalArgumentException iae) {
            BundleImpl b = this.gen.bundle;
            b.fwCtx.frameworkError(b, (Throwable)iae, new FrameworkListener[0]);
            return null;
        }
    }

    static CapabilityDTO getDTO(BundleCapability bc, BundleRevisionImpl bri) {
        CapabilityDTO res = new CapabilityDTO();
        res.id = ((DTOId)((Object)bc)).dtoId;
        res.namespace = bc.getNamespace();
        res.directives = new HashMap<String, String>(bc.getDirectives());
        res.attributes = Util.safeDTOMap(bc.getAttributes());
        res.resource = bri.dtoId;
        return res;
    }

    static CapabilityRefDTO getRefDTO(BundleCapability bc, BundleRevisionImpl bri) {
        CapabilityRefDTO res = new CapabilityRefDTO();
        res.capability = ((DTOId)((Object)bc)).dtoId;
        res.resource = bri.dtoId;
        return res;
    }
}

