/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.JweHeader;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;

public class IdLocator<H extends Header, R extends Identifiable>
implements Locator<R>,
Function<H, R> {
    private final Parameter<String> param;
    private final String requiredMsg;
    private final boolean valueRequired;
    private final Registry<String, R> registry;

    public IdLocator(Parameter<String> param, Registry<String, R> registry, String requiredExceptionMessage) {
        this.param = (Parameter)Assert.notNull(param, (String)"Header param cannot be null.");
        this.requiredMsg = Strings.clean((String)requiredExceptionMessage);
        this.valueRequired = Strings.hasText((String)this.requiredMsg);
        Assert.notEmpty(registry, (String)"Registry cannot be null or empty.");
        this.registry = registry;
    }

    private static String type(Header header) {
        if (header instanceof JweHeader) {
            return "JWE";
        }
        if (header instanceof JwsHeader) {
            return "JWS";
        }
        return "JWT";
    }

    public R locate(Header header) {
        String id;
        Assert.notNull((Object)header, (String)"Header argument cannot be null.");
        Object val = header.get((Object)this.param.getId());
        String string = id = val != null ? val.toString() : null;
        if (!Strings.hasText((String)id)) {
            if (this.valueRequired) {
                throw new MalformedJwtException(this.requiredMsg);
            }
            return null;
        }
        try {
            return (R)((Identifiable)this.registry.forKey((Object)id));
        }
        catch (Exception e) {
            String msg = "Unrecognized " + IdLocator.type(header) + " " + this.param + " header value: " + id;
            throw new UnsupportedJwtException(msg, (Throwable)e);
        }
    }

    @Override
    public R apply(H header) {
        return this.locate((Header)header);
    }
}

