/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.msg;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.microsoft.msg.MAPITag;
import org.apache.tika.parser.microsoft.msg.TikaNameIdChunks;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedMetadataExtractor {
    static Logger LOGGER = LoggerFactory.getLogger(ExtendedMetadataExtractor.class);
    static Map<Integer, List<TikaMapiProperty>> TIKA_MAPI_PROPERTIES = new ConcurrentHashMap<Integer, List<TikaMapiProperty>>();
    static Map<Integer, List<TikaMapiProperty>> TIKA_MAPI_LONG_PROPERTIES = new ConcurrentHashMap<Integer, List<TikaMapiProperty>>();

    public static void extract(MAPIMessage msg, Metadata metadata) {
        if (msg.getNameIdChunks() == null) {
            return;
        }
        if (msg.getMainChunks() == null || msg.getMainChunks().getRawProperties() == null) {
            return;
        }
        TikaNameIdChunks tikaNameIdChunks = new TikaNameIdChunks();
        long len = 0L;
        for (Chunk chunk : msg.getNameIdChunks().getAll()) {
            byte[] value;
            if (chunk == null) continue;
            tikaNameIdChunks.record(chunk);
            if (!(chunk instanceof ByteChunk) || (value = ((ByteChunk)chunk).getValue()) == null) continue;
            len += (long)value.length;
        }
        if (len == 0L) {
            return;
        }
        try {
            tikaNameIdChunks.chunksComplete();
        }
        catch (IllegalStateException e) {
            LOGGER.warn("bad namechunks stream", (Throwable)e);
        }
        for (Map.Entry entry : msg.getMainChunks().getRawProperties().entrySet()) {
            PropertyValue v = (PropertyValue)entry.getValue();
            if (v == null) continue;
            List<MAPITag> mapiTags = tikaNameIdChunks.getTags(((MAPIProperty)entry.getKey()).id);
            MAPITagPair pair = null;
            for (MAPITag mapiTag : mapiTags) {
                List<TikaMapiProperty> tikaMapiProperties = TIKA_MAPI_LONG_PROPERTIES.get(mapiTag.tagId);
                if (tikaMapiProperties == null) {
                    tikaMapiProperties = TIKA_MAPI_PROPERTIES.get(mapiTag.tagId);
                }
                if ((pair = ExtendedMetadataExtractor.findMatch(mapiTag, tikaMapiProperties, v)) == null) continue;
                break;
            }
            ExtendedMetadataExtractor.updateMetadata(pair, v, metadata);
        }
    }

    private static MAPITagPair findMatch(MAPITag mapiTag, List<TikaMapiProperty> tikaMapiProperties, PropertyValue propertyValue) {
        if (mapiTag == null || tikaMapiProperties == null || propertyValue == null) {
            return null;
        }
        for (TikaMapiProperty tikaMapiProperty : tikaMapiProperties) {
            if (!mapiTag.classID.equals((Object)tikaMapiProperty.classID) || tikaMapiProperty.types == null || tikaMapiProperty.types.isEmpty()) continue;
            for (Types.MAPIType type : tikaMapiProperty.types) {
                if (!propertyValue.getActualType().equals(type)) continue;
                return new MAPITagPair(mapiTag, tikaMapiProperty);
            }
        }
        return null;
    }

    private static void updateMetadata(MAPITagPair pair, PropertyValue propertyValue, Metadata metadata) {
        if (pair == null || propertyValue == null) {
            return;
        }
        if (!ExtendedMetadataExtractor.includeType(propertyValue)) {
            return;
        }
        String key = "mapi:property:" + pair.tikaMapiProperty.name;
        Types.MAPIType type = propertyValue.getActualType();
        if (type == Types.TIME || type == Types.MV_TIME || type == Types.APP_TIME || type == Types.MV_APP_TIME) {
            Calendar calendar = (Calendar)propertyValue.getValue();
            String calendarString = calendar.toInstant().truncatedTo(ChronoUnit.SECONDS).toString();
            metadata.add(key, calendarString);
        } else if (type == Types.BOOLEAN) {
            Boolean val = (Boolean)propertyValue.getValue();
            if (val == null) {
                return;
            }
            metadata.add(key, Boolean.toString(val));
        } else if (!StringUtils.isBlank((String)propertyValue.toString())) {
            metadata.add(key, propertyValue.toString());
        }
    }

    private static boolean includeType(PropertyValue propertyValue) {
        Types.MAPIType mapiType = propertyValue.getActualType();
        return mapiType != Types.BINARY && mapiType != Types.UNKNOWN && mapiType != Types.UNSPECIFIED && mapiType != Types.DIRECTORY && !mapiType.isPointer();
    }

    private static void loadProperties() {
        HashMap<String, ClassID> knownClassIds = new HashMap<String, ClassID>();
        for (TikaNameIdChunks.PredefinedPropertySet predefinedPropertySet : TikaNameIdChunks.PredefinedPropertySet.values()) {
            knownClassIds.put(predefinedPropertySet.getClassID().toUUIDString(), predefinedPropertySet.getClassID());
        }
        for (Enum enum_ : TikaNameIdChunks.PropertySetType.values()) {
            knownClassIds.put(((TikaNameIdChunks.PropertySetType)enum_).getClassID().toUUIDString(), ((TikaNameIdChunks.PropertySetType)enum_).getClassID());
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(ExtendedMetadataExtractor.class.getResourceAsStream("/org/apache/tika/parser/microsoft/msg/props_table.txt"), StandardCharsets.UTF_8));){
            String line = r.readLine();
            while (line != null) {
                if (line.isBlank() || line.startsWith("#")) {
                    line = r.readLine();
                    continue;
                }
                String[] cols = line.split("\\|");
                if (cols.length != 11) {
                    throw new IllegalArgumentException("column count must == 11: " + line);
                }
                String string = cols[1].trim();
                ClassID classID = ExtendedMetadataExtractor.parseClassId(cols[3], knownClassIds);
                List<Types.MAPIType> types = ExtendedMetadataExtractor.parseDataTypes(cols[7].split(";"));
                String ref = cols[10];
                String shortId = cols[5];
                String longId = cols[6];
                if (!StringUtils.isBlank((String)shortId)) {
                    int id = Integer.parseInt(shortId.substring(2), 16);
                    List props = TIKA_MAPI_PROPERTIES.computeIfAbsent(id, k -> new ArrayList());
                    props.add(new TikaMapiProperty(string, classID, types, ref));
                } else if (!StringUtils.isBlank((String)longId)) {
                    long id = Long.parseLong(longId.substring(2), 16);
                    if (id > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("id must actually be within int range");
                    }
                    int intId = (int)id;
                    List props = TIKA_MAPI_LONG_PROPERTIES.computeIfAbsent(intId, k -> new ArrayList());
                    props.add(new TikaMapiProperty(string, classID, types, ref));
                }
                line = r.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("can't find props_table.txt?!");
        }
    }

    private static ClassID parseClassId(String s, Map<String, ClassID> knownClassIDs) {
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        int space = s.indexOf(" ");
        if (space < 0) {
            return null;
        }
        if (knownClassIDs.containsKey(s = s.substring(space).replaceAll("[\\{\\}]", "").trim())) {
            return knownClassIDs.get(s);
        }
        LOGGER.warn("Add '{}' to list of known property set IDs", (Object)s);
        ClassID classID = new ClassID(s);
        knownClassIDs.put(classID.toUUIDString(), classID);
        return classID;
    }

    private static List<Types.MAPIType> parseDataTypes(String[] arr) {
        if (arr.length == 1) {
            Types.MAPIType type = ExtendedMetadataExtractor.parseDataType(arr[0]);
            if (type != null) {
                return List.of(type);
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList<Types.MAPIType> types = new ArrayList<Types.MAPIType>();
        for (String s : arr) {
            Types.MAPIType type = ExtendedMetadataExtractor.parseDataType(s);
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    private static Types.MAPIType parseDataType(String s) {
        int id;
        Types.MAPIType type;
        if (StringUtils.isBlank((String)s)) {
            return null;
        }
        String[] parts = s.split(", ");
        if (parts.length != 2) {
            throw new IllegalArgumentException("expected two parts: " + s);
        }
        String num = parts[1];
        if (num.startsWith("0x")) {
            num = num.substring(2);
        }
        if ((type = Types.getById((int)(id = Integer.parseInt(num, 16)))) == null) {
            return Types.createCustom((int)id);
        }
        return type;
    }

    static {
        ExtendedMetadataExtractor.loadProperties();
    }

    private static class MAPITagPair {
        final MAPITag mapiTag;
        final TikaMapiProperty tikaMapiProperty;

        public MAPITagPair(MAPITag mapiTag, TikaMapiProperty tikaMapiProperty) {
            this.mapiTag = mapiTag;
            this.tikaMapiProperty = tikaMapiProperty;
        }
    }

    private static class TikaMapiProperty {
        String name;
        ClassID classID;
        List<Types.MAPIType> types;
        String refShort;

        TikaMapiProperty(String name, ClassID classID, List<Types.MAPIType> types, String refShort) {
            this.name = name;
            this.classID = classID;
            this.types = types;
            this.refShort = refShort;
        }
    }
}

