/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.vertica.VerticaConstants;
import org.jkiss.dbeaver.ext.vertica.VerticaUtils;
import org.jkiss.dbeaver.ext.vertica.model.QueryTransformerLimitVertica;
import org.jkiss.dbeaver.ext.vertica.model.VerticaConstraint;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaFlexTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSequence;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSystemTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTableColumn;
import org.jkiss.dbeaver.ext.vertica.model.VerticaView;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class VerticaMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    @NotNull
    public GenericDataSource createDataSourceImpl(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new VerticaDataSource(monitor, container, this);
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new VerticaSchema(dataSource, catalog, schemaName);
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, GenericTableBase table, String tableName) throws SQLException {
        JDBCPreparedStatement dbStat;
        if (owner instanceof VerticaSchema && ((VerticaSchema)owner).isSystem()) {
            String sql = "SELECT st.table_schema as table_schem, st.table_description as remarks, 'SYSTEM TABLE' as table_type, st.*\nfrom v_catalog.system_tables st where st.table_schema =?" + (table != null || CommonUtils.isNotEmpty((String)tableName) ? " and st.table_name=?" : "");
            dbStat = session.prepareStatement(sql);
            dbStat.setString(1, owner.getName());
            if (table != null || CommonUtils.isNotEmpty((String)tableName)) {
                dbStat.setString(2, table != null ? table.getName() : tableName);
            }
        } else {
            String sql = "SELECT t.table_schema as table_schem, t.table_name, t.create_time, t.is_temp_table, t.is_system_table, t.has_aggregate_projection, t.partition_expression, case when is_flextable = true THEN 'FLEX TABLE' else 'TABLE' end as table_type\nFROM v_catalog.tables t\n" + (String)(owner instanceof VerticaSchema ? "WHERE t.table_schema=?" + (table != null || CommonUtils.isNotEmpty((String)tableName) ? " and t.table_name = ?" : "") : "") + "\nUNION ALL\nSELECT v.table_schema as table_schem, v.table_name, v.create_time, v.is_local_temp_view as is_temp_table, v.is_system_view as is_system_table, false as has_aggregate_projection, null as partition_expression, 'VIEW' as table_type\nFROM v_catalog.views v\n" + (String)(owner instanceof VerticaSchema ? "WHERE v.table_schema=?" + (table != null || CommonUtils.isNotEmpty((String)tableName) ? " and v.table_name = ?" : "") : "");
            dbStat = session.prepareStatement(sql);
            if (owner instanceof VerticaSchema) {
                dbStat.setString(1, owner.getName());
                if (table != null || CommonUtils.isNotEmpty((String)tableName)) {
                    dbStat.setString(2, table != null ? table.getName() : tableName);
                    dbStat.setString(3, owner.getName());
                    dbStat.setString(4, table != null ? table.getName() : tableName);
                } else {
                    dbStat.setString(2, owner.getName());
                }
            }
        }
        return dbStat;
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        VerticaSchema schema = (VerticaSchema)container;
        if (CommonUtils.isNotEmpty((String)tableType)) {
            if (this.isView(tableType)) {
                return new VerticaView(schema, tableName, tableType, dbResult);
            }
            if (tableType.equals(VerticaConstants.TYPE_FLEX_TABLE)) {
                return new VerticaFlexTable(schema, tableName, tableType, dbResult);
            }
            if (tableType.equals(VerticaConstants.TYPE_SYSTEM_TABLE)) {
                return new VerticaSystemTable(schema, tableName, tableType, dbResult);
            }
            return new VerticaTable(schema, tableName, tableType, dbResult);
        }
        return new VerticaTable(schema, tableName, tableType, dbResult);
    }

    public JDBCStatement prepareTableColumnLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        StringBuilder ddl = new StringBuilder();
        ddl.append("SELECT col.*, col.sql_type_id AS SOURCE_DATA_TYPE, col.data_type_name AS TYPE_NAME, col.column_default AS COLUMN_DEF FROM v_catalog.odbc_columns col\n WHERE col.schema_name=?");
        if (forTable != null) {
            ddl.append("AND col.table_name=? ");
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(ddl.toString());
        if (forTable != null) {
            dbStat.setString(1, forTable.getSchema().getName());
            dbStat.setString(2, forTable.getName());
        } else {
            dbStat.setString(1, owner.getSchema().getName());
        }
        return dbStat;
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        if (dbResult != null) {
            autoIncrement = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_identity");
        }
        return new VerticaTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, defaultValue, autoIncrement);
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        return "IDENTITY";
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) throws DBException {
        GenericDataSource dataSource = (GenericDataSource)sourceObject.getDataSource();
        if (sourceObject.isPersisted()) {
            return VerticaUtils.getObjectDDL(monitor, dataSource, (DBSObject)sourceObject);
        }
        return super.getTableDDL(monitor, sourceObject, options);
    }

    public boolean supportsTableDDLSplit(@NotNull GenericTableBase sourceObject) {
        return false;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return this.getTableDDL(monitor, (GenericTableBase)sourceObject, options);
    }

    /*
     * Exception decompiling
     */
    public String getProcedureDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericProcedure sourceObject) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean supportsOverloadedProcedureNames() {
        return true;
    }

    public boolean showProcedureParamNames() {
        return true;
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        boolean avoidCommentsReading = ((VerticaDataSource)container.getDataSource()).avoidCommentsReading();
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT s.*" + (avoidCommentsReading ? "" : ", c.comment") + " FROM v_catalog.sequences s\n" + (avoidCommentsReading ? "" : "LEFT JOIN v_catalog.comments c\nON s.sequence_id = c.object_id\n") + "WHERE sequence_schema=? ORDER BY sequence_name");
        dbStat.setString(1, container.getSchema().getName());
        return dbStat;
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sequence_name");
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        name = name.trim();
        return new VerticaSequence(container, name, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"current_value"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"minimum"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"maximum"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"increment_by"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"identity_table_name"), JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"session_cache_count"), JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"allow_cycle"));
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimitVertica();
        }
        return null;
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException, DBException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT col.constraint_name as PK_NAME, col.table_name as TABLE_NAME, col.column_name as COLUMN_NAME, c.ordinal_position as KEY_SEQ, col.constraint_type, tc.predicate, col.is_enabled\nFROM v_catalog.constraint_columns col\nLEFT JOIN v_catalog.columns c ON\nc.table_id = col.table_id\nJOIN v_catalog.table_constraints tc ON\ntc.constraint_id = col.constraint_id \nAND col.column_name = c.column_name \nWHERE col.constraint_type IN ('u','p','c')\nAND col.table_schema = ?" + (forParent != null ? " AND col.table_name = ?" : "") + " ORDER BY col.table_id, KEY_SEQ, PK_NAME");
        if (forParent != null) {
            dbStat.setString(1, forParent.getSchema().getName());
            dbStat.setString(2, forParent.getName());
        } else {
            dbStat.setString(1, owner.getName());
        }
        return dbStat;
    }

    public DBSEntityConstraintType getUniqueConstraintType(@NotNull JDBCResultSet dbResult) throws DBException, SQLException {
        String type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"constraint_type");
        if (type != null) {
            if ("u".equals(type)) {
                return DBSEntityConstraintType.UNIQUE_KEY;
            }
            if ("c".equals(type)) {
                return DBSEntityConstraintType.CHECK;
            }
            return DBSEntityConstraintType.PRIMARY_KEY;
        }
        return super.getUniqueConstraintType(dbResult);
    }

    @NotNull
    public GenericUniqueKey createConstraintImpl(@NotNull GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        String checkExpression = "";
        boolean isEnabled = false;
        if (dbResult != null) {
            checkExpression = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"predicate");
            isEnabled = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_enabled");
        }
        return new VerticaConstraint(table, constraintName, null, constraintType, persisted, CommonUtils.notEmpty((String)checkExpression).trim(), isEnabled);
    }

    public boolean supportsCheckConstraints() {
        return true;
    }

    public boolean supportsUniqueKeys() {
        return true;
    }
}

