﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ecr-public/ECRPublicRequest.h>
#include <aws/ecr-public/ECRPublic_EXPORTS.h>

namespace Aws {
namespace ECRPublic {
namespace Model {

/**
 */
class GetRegistryCatalogDataRequest : public ECRPublicRequest {
 public:
  AWS_ECRPUBLIC_API GetRegistryCatalogDataRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetRegistryCatalogData"; }

  AWS_ECRPUBLIC_API Aws::String SerializePayload() const override;

  AWS_ECRPUBLIC_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;
};

}  // namespace Model
}  // namespace ECRPublic
}  // namespace Aws
