﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/chime-sdk-voice/model/SipMediaApplicationEndpoint.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class UpdateSipMediaApplicationRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API UpdateSipMediaApplicationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateSipMediaApplication"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The SIP media application ID.</p>
   */
  inline const Aws::String& GetSipMediaApplicationId() const { return m_sipMediaApplicationId; }
  inline bool SipMediaApplicationIdHasBeenSet() const { return m_sipMediaApplicationIdHasBeenSet; }
  template <typename SipMediaApplicationIdT = Aws::String>
  void SetSipMediaApplicationId(SipMediaApplicationIdT&& value) {
    m_sipMediaApplicationIdHasBeenSet = true;
    m_sipMediaApplicationId = std::forward<SipMediaApplicationIdT>(value);
  }
  template <typename SipMediaApplicationIdT = Aws::String>
  UpdateSipMediaApplicationRequest& WithSipMediaApplicationId(SipMediaApplicationIdT&& value) {
    SetSipMediaApplicationId(std::forward<SipMediaApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The new name for the specified SIP media application.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateSipMediaApplicationRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The new set of endpoints for the specified SIP media application.</p>
   */
  inline const Aws::Vector<SipMediaApplicationEndpoint>& GetEndpoints() const { return m_endpoints; }
  inline bool EndpointsHasBeenSet() const { return m_endpointsHasBeenSet; }
  template <typename EndpointsT = Aws::Vector<SipMediaApplicationEndpoint>>
  void SetEndpoints(EndpointsT&& value) {
    m_endpointsHasBeenSet = true;
    m_endpoints = std::forward<EndpointsT>(value);
  }
  template <typename EndpointsT = Aws::Vector<SipMediaApplicationEndpoint>>
  UpdateSipMediaApplicationRequest& WithEndpoints(EndpointsT&& value) {
    SetEndpoints(std::forward<EndpointsT>(value));
    return *this;
  }
  template <typename EndpointsT = SipMediaApplicationEndpoint>
  UpdateSipMediaApplicationRequest& AddEndpoints(EndpointsT&& value) {
    m_endpointsHasBeenSet = true;
    m_endpoints.emplace_back(std::forward<EndpointsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sipMediaApplicationId;

  Aws::String m_name;

  Aws::Vector<SipMediaApplicationEndpoint> m_endpoints;
  bool m_sipMediaApplicationIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_endpointsHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
