\name{FastMarchingBaseImageFilter}
\alias{FastMarchingBaseImageFilter}
\title{FastMarchingBaseImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Apply the Fast Marching method to solve an Eikonal equation on an
image.
FastMarchingBaseImageFilter}
\details{
The speed function can be specified as a speed image or a speed
constant. The speed image is set using the method SetInput(). If the
speed image is nullptr, a constant speed function is used and is
specified using method the SetSpeedConstant() .
If the speed function is constant and of value one, fast marching
results is an approximate distance function from the initial alive
points.
There are two ways to specify the output image information
(LargestPossibleRegion, Spacing, Origin):
it is copied directly from the input speed image
it is specified by the user. Default values are used if the user does
not specify all the information.
 The output information is computed as follows.
If the speed image is nullptr or if the OverrideOutputInformation is
set to true, the output information is set from user specified
parameters. These parameters can be specified using methods
FastMarchingImageFilterBase::SetOutputRegion() ,
FastMarchingImageFilterBase::SetOutputSpacing() ,
FastMarchingImageFilterBase::SetOutputDirection() ,
FastMarchingImageFilterBase::SetOutputOrigin() .
 Else the output information is copied from the input speed image.
Implementation of this class is based on Chapter 8 of "Level Set
Methods and Fast Marching Methods", J.A. Sethian, Cambridge Press,
Second edition, 1999.
For an alternative implementation, see itk::FastMarchingImageFilter .
TTraits
traits
See:
FastMarchingImageFilter
ImageFastMarchingTraits
ImageFastMarchingTraits2
FastMarchingBase for the procedural interface
itk::FastMarchingImageFilterBase for the Doxygen on the original ITK class.
FastMarchingBaseImageFilter}
%C++ includes: sitkFastMarchingBaseImageFilter.h
\section{Methods}{
\describe{
\item{Self AddTrialPoint(std::vector< unsigned int > point):}{
Add TrialPoints point.
}
\item{Self ClearTrialPoints():}{
Remove all TrialPoints points.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ FastMarchingBaseImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::vector< double > GetInitialTrialValues() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetNormalizationFactor() const:}{
Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.
}
\item{double GetStoppingValue() const:}{
Get the Fast Marching algorithm Stopping Value.
}
\item{TopologyCheckType GetTopologyCheck() const:}{}
\item{std::vector< std::vector< unsigned int > > GetTrialPoints() const:}{
Get the container of Trial Points representing the initial front.
}
\item{Self SetInitialTrialValues(std::vector< double > InitialTrialValues):}{
Set the initial seed values for corresponding trial point.
}
\item{Self SetNormalizationFactor(double NormalizationFactor):}{
Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.
}
\item{Self SetStoppingValue(double StoppingValue):}{
Set the Fast Marching algorithm Stopping Value. The Fast Marching
algorithm is terminated when the value of the smallest trial point is
greater than the stopping value.
}
\item{Self SetTopologyCheck(TopologyCheckType TopologyCheck):}{}
\item{Self SetTrialPoints(std::vector< std::vector< unsigned int > > TrialPoints):}{
Set the container of Trial Points representing the initial front.
Trial points are represented as a VectorContainer of LevelSetNodes.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FastMarchingBaseImageFilter():}{
Destructor
}
}
}
