/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.util.EnumCounters;

public enum Quota {
    NAMESPACE,
    STORAGESPACE;


    public static boolean isViolated(long quota, long usage) {
        return quota >= 0L && usage > quota;
    }

    static boolean isViolated(long quota, long usage, long delta) {
        return quota >= 0L && delta > 0L && usage > quota - delta;
    }

    public static class Counts
    extends EnumCounters<Quota> {
        public static Counts newInstance(long namespace, long storagespace) {
            Counts c = new Counts();
            c.set(NAMESPACE, namespace);
            c.set(STORAGESPACE, storagespace);
            return c;
        }

        public static Counts newInstance() {
            return Counts.newInstance(0L, 0L);
        }

        Counts() {
            super(Quota.class);
        }
    }
}

