/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.StringHelper;

@InterfaceAudience.Private
public class Apps {
    public static final String APP = "application";
    public static final String ID = "ID";
    private static final Pattern VAR_SUBBER = Pattern.compile(Shell.getEnvironmentVariableRegex());
    private static final Pattern VARVAL_SPLITTER = Pattern.compile("(?<=^|,)([A-Za-z_][A-Za-z0-9_]*)=([^,]*)");

    public static ApplicationId toAppID(String aid) {
        Iterator<String> it = StringHelper._split(aid).iterator();
        return Apps.toAppID(APP, aid, it);
    }

    public static ApplicationId toAppID(String prefix, String s, Iterator<String> it) {
        if (!it.hasNext() || !it.next().equals(prefix)) {
            Apps.throwParseException(StringHelper.sjoin(prefix, ID), s);
        }
        Apps.shouldHaveNext(prefix, s, it);
        ApplicationId appId = ApplicationId.newInstance(Long.parseLong(it.next()), Integer.parseInt(it.next()));
        return appId;
    }

    public static void shouldHaveNext(String prefix, String s, Iterator<String> it) {
        if (!it.hasNext()) {
            Apps.throwParseException(StringHelper.sjoin(prefix, ID), s);
        }
    }

    public static void throwParseException(String name, String s) {
        throw new YarnRuntimeException(StringHelper.join("Error parsing ", name, ": ", s));
    }

    private static void setEnvFromString(Map<String, String> env, String envVar, String varString, String classPathSeparator) {
        Matcher m = VAR_SUBBER.matcher(varString);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String replace = env.get(var);
            if (replace == null) {
                replace = System.getenv(var);
            }
            if (replace == null) {
                replace = "";
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(replace));
        }
        m.appendTail(sb);
        Apps.addToEnvironment(env, envVar, sb.toString(), classPathSeparator);
    }

    public static void setEnvFromInputString(Map<String, String> env, String envString, String classPathSeparator) {
        if (envString != null && envString.length() > 0) {
            Matcher varValMatcher = VARVAL_SPLITTER.matcher(envString);
            while (varValMatcher.find()) {
                String envVar = varValMatcher.group(1);
                String varString = varValMatcher.group(2);
                Apps.setEnvFromString(env, envVar, varString, classPathSeparator);
            }
        }
    }

    private static void setEnvFromInputStringNoExpand(Map<String, String> env, String envString, String classPathSeparator) {
        if (envString != null && envString.length() > 0) {
            Matcher varValMatcher = VARVAL_SPLITTER.matcher(envString);
            while (varValMatcher.find()) {
                String envVar = varValMatcher.group(1);
                String varString = varValMatcher.group(2);
                Apps.addToEnvironment(env, envVar, varString, classPathSeparator);
            }
        }
    }

    private static void setEnvFromInputStringMap(Map<String, String> env, Map<String, String> inputMap, String classPathSeparator) {
        for (Map.Entry<String, String> inputVar : inputMap.entrySet()) {
            String envVar = inputVar.getKey();
            String varString = inputVar.getValue();
            Apps.setEnvFromString(env, envVar, varString, classPathSeparator);
        }
    }

    public static void setEnvFromInputProperty(Map<String, String> env, String propName, String defaultPropValue, Configuration conf, String classPathSeparator) {
        String envString = conf.get(propName, defaultPropValue);
        HashMap<String, String> tmpEnv = new HashMap<String, String>();
        Apps.setEnvFromInputStringNoExpand(tmpEnv, envString, classPathSeparator);
        Map<String, String> inputMap = conf.getPropsWithPrefix(propName + ".");
        tmpEnv.putAll(inputMap);
        Apps.setEnvFromInputStringMap(env, tmpEnv, classPathSeparator);
    }

    private static Set<String> getEnvVarsFromInputString(String envString) {
        HashSet<String> envSet = new HashSet<String>();
        if (envString != null && envString.length() > 0) {
            Matcher varValMatcher = VARVAL_SPLITTER.matcher(envString);
            while (varValMatcher.find()) {
                String envVar = varValMatcher.group(1);
                envSet.add(envVar);
            }
        }
        return envSet;
    }

    public static Set<String> getEnvVarsFromInputProperty(String propName, String defaultPropValue, Configuration conf) {
        String envString = conf.get(propName, defaultPropValue);
        Set<String> varSet = Apps.getEnvVarsFromInputString(envString);
        Map<String, String> propMap = conf.getPropsWithPrefix(propName + ".");
        varSet.addAll(propMap.keySet());
        return varSet;
    }

    @Deprecated
    public static void setEnvFromInputString(Map<String, String> env, String envString) {
        Apps.setEnvFromInputString(env, envString, File.pathSeparator);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static void addToEnvironment(Map<String, String> environment, String variable, String value, String classPathSeparator) {
        String val = environment.get(variable);
        val = val == null ? value : val + classPathSeparator + value;
        environment.put(StringInterner.weakIntern(variable), StringInterner.weakIntern(val));
    }

    @Deprecated
    public static void addToEnvironment(Map<String, String> environment, String variable, String value) {
        Apps.addToEnvironment(environment, variable, value, File.pathSeparator);
    }

    public static String crossPlatformify(String var) {
        return "{{" + var + "}}";
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static boolean shouldCountTowardsNodeBlacklisting(int exitStatus) {
        switch (exitStatus) {
            case -107: 
            case -106: 
            case -105: 
            case -102: 
            case -100: {
                return false;
            }
            case -101: {
                return false;
            }
            case -104: 
            case -103: {
                return false;
            }
            case 0: {
                return false;
            }
            case -1000: {
                return true;
            }
        }
        return true;
    }

    public static boolean isApplicationFinalState(YarnApplicationState appState) {
        return appState == YarnApplicationState.FINISHED || appState == YarnApplicationState.FAILED || appState == YarnApplicationState.KILLED;
    }
}

