"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadAssetsFromFile = exports.createIndexTemplate = exports.createAllTemplatesSettled = exports.assetMapper = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _getting_started_routes = require("../../../common/constants/getting_started_routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const assetMapper = tutorialId => {
  const component = _getting_started_routes.COMPONENT_MAP[tutorialId] || 'default-component';
  const version = _getting_started_routes.VERSION_MAP[tutorialId] || '1.0.0';
  const signal = _getting_started_routes.SIGNAL_MAP[tutorialId] ? `-${_getting_started_routes.SIGNAL_MAP[tutorialId]}` : '';
  return `${component}-${version}${signal}.ndjson`;
};
exports.assetMapper = assetMapper;
const loadAssetsFromFile = async tutorialId => {
  try {
    const fileName = assetMapper(tutorialId);
    const filePath = _path.default.join(__dirname, `assets/${fileName}`);
    const fileData = await _fs.default.promises.readFile(filePath, 'utf8');
    return fileData;
  } catch (error) {
    throw new Error(`Error loading asset: ${tutorialId}`);
  }
};
exports.loadAssetsFromFile = loadAssetsFromFile;
const createAllTemplatesSettled = async (context, indexTemplates, dataSourceMDSId) => {
  const results = await Promise.allSettled(indexTemplates.map(({
    name,
    template,
    templatePath
  }) => createIndexTemplate(context, name, template, dataSourceMDSId, templatePath)));
  return results.map((result, index) => {
    const templateName = indexTemplates[index].name;
    if (result.status === 'fulfilled') {
      return {
        name: templateName,
        success: true
      };
    }
    return {
      name: templateName,
      success: false,
      reason: result.reason
    };
  });
};
exports.createAllTemplatesSettled = createAllTemplatesSettled;
const createIndexTemplate = async (context, name, template, dataSourceMDSId, templatePath) => {
  try {
    const osClient = dataSourceMDSId ? await context.dataSource.opensearch.getClient(dataSourceMDSId) : context.core.opensearch.client.asCurrentUser;
    return await osClient.transport.request({
      method: 'PUT',
      path: templatePath,
      body: template
    });
  } catch (error) {
    console.error(`Failed to create index template ${name}:`, error);
    throw error;
  }
};
exports.createIndexTemplate = createIndexTemplate;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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