/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.XSKeyvalI;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.driver.XSPrincipalI;
import oracle.jdbc.driver.XSSessionNamespaceI;
import oracle.jdbc.internal.XSEvent;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSessionNamespace;

class NTFXSEvent
extends XSEvent {
    private static final long serialVersionUID = 301415165532636629L;
    private final XSNamespaceI[] kpxssyncns;
    private final XSNamespaceI[] kpxssyncinvalidns;
    private final XSPrincipalI[] kpxssyncroles;
    private final XSSessionNamespaceI[] kpxssyncsessns;
    private final int kpxssyncrolever;
    private final int kpxssyncsessflg;
    private final int kpxssynccacheflg;
    private final XSKeyvalI kvl;

    @Override
    public XSNamespace[] getNamespaces() {
        return this.kpxssyncns;
    }

    @Override
    public XSNamespace[] getInvalidNamespaces() {
        return this.kpxssyncinvalidns;
    }

    @Override
    public XSPrincipal[] getSessionRoles() {
        return this.kpxssyncroles;
    }

    @Override
    public XSSessionNamespace[] getSessionNamespaces() {
        return this.kpxssyncsessns;
    }

    @Override
    public int getRoleVersion() {
        return this.kpxssyncrolever;
    }

    @Override
    public long getSessionFlags() {
        return this.kpxssyncsessflg;
    }

    @Override
    public long getCacheFlags() {
        return this.kpxssynccacheflg;
    }

    @Override
    public XSKeyval getKeyval() {
        return this.kvl;
    }

    NTFXSEvent(T4CConnection conn) throws SQLException, IOException {
        super(conn);
        T4CMAREngine meg = conn.getMarshalEngine();
        int kpxssyncnsl = (int)meg.unmarshalUB4();
        if (kpxssyncnsl > 0) {
            meg.unmarshalUB1();
        }
        this.kpxssyncns = new XSNamespaceI[kpxssyncnsl];
        for (int i = 0; i < kpxssyncnsl; ++i) {
            this.kpxssyncns[i] = XSNamespaceI.unmarshal(meg);
        }
        int kpxssyncinvalidnsl = (int)meg.unmarshalUB4();
        if (kpxssyncinvalidnsl > 0) {
            meg.unmarshalUB1();
        }
        this.kpxssyncinvalidns = new XSNamespaceI[kpxssyncinvalidnsl];
        for (int i = 0; i < kpxssyncinvalidnsl; ++i) {
            this.kpxssyncinvalidns[i] = XSNamespaceI.unmarshal(meg);
        }
        int kpxssyncrolesl = (int)meg.unmarshalUB4();
        if (kpxssyncrolesl > 0) {
            meg.unmarshalUB1();
        }
        this.kpxssyncroles = new XSPrincipalI[kpxssyncrolesl];
        for (int i = 0; i < kpxssyncrolesl; ++i) {
            this.kpxssyncroles[i] = XSPrincipalI.unmarshal(meg);
        }
        int kpxssyncsessnsl = (int)meg.unmarshalUB4();
        if (kpxssyncsessnsl > 0) {
            meg.unmarshalUB1();
        }
        this.kpxssyncsessns = new XSSessionNamespaceI[kpxssyncsessnsl];
        for (int i = 0; i < kpxssyncsessnsl; ++i) {
            meg.unmarshalUB1();
            meg.unmarshalUB1();
            meg.unmarshalUB1();
            this.kpxssyncsessns[i] = XSSessionNamespaceI.unmarshal(meg);
        }
        this.kpxssyncrolever = (int)meg.unmarshalUB4();
        this.kpxssyncsessflg = (int)meg.unmarshalUB4();
        this.kpxssynccacheflg = (int)meg.unmarshalUB4();
        short kvsize = meg.unmarshalUB1();
        if (kvsize != 0) {
            meg.unmarshalUB1();
            meg.unmarshalUB1();
            this.kvl = XSKeyvalI.unmarshal(meg);
        } else {
            this.kvl = null;
        }
    }
}

