/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.Range;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractRange<T>
implements Range<T>,
Comparable<Range> {
    private PropertyChangeSupport changeSupport;

    public Range<T> copy() {
        throw new UnsupportedOperationException("Copy method not implemented");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(evt);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public abstract Range<T> createIntermediate(Range<T> var1, double var2);

    @Override
    public int compareTo(Range o) {
        int lowerGap = (int)(this.minimum() - o.minimum());
        if (this.size() == 0.0 && o.size() == 0.0) {
            return lowerGap;
        }
        if (this.size() == 0.0 && this.size() < o.size()) {
            return -1;
        }
        if (o.size() == 0.0 && this.size() > o.size()) {
            return 1;
        }
        return lowerGap == 0 ? (int)(this.maximum() - o.maximum()) : lowerGap;
    }
}

