/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.simplify.RingHull;
import org.locationtech.jts.simplify.RingHullIndex;

public class PolygonHullSimplifier {
    private Geometry inputGeom;
    private boolean isOuter;
    private double vertexNumFraction = -1.0;
    private double areaDeltaRatio = -1.0;
    private GeometryFactory geomFactory;

    public static Geometry hull(Geometry geom, boolean isOuter, double vertexNumFraction) {
        PolygonHullSimplifier hull = new PolygonHullSimplifier(geom, isOuter);
        hull.setVertexNumFraction(Math.abs(vertexNumFraction));
        return hull.getResult();
    }

    public static Geometry hullByAreaDelta(Geometry geom, boolean isOuter, double areaDeltaRatio) {
        PolygonHullSimplifier hull = new PolygonHullSimplifier(geom, isOuter);
        hull.setAreaDeltaRatio(Math.abs(areaDeltaRatio));
        return hull.getResult();
    }

    public PolygonHullSimplifier(Geometry inputGeom, boolean isOuter) {
        this.inputGeom = inputGeom;
        this.geomFactory = inputGeom.getFactory();
        this.isOuter = isOuter;
        if (!(inputGeom instanceof Polygonal)) {
            throw new IllegalArgumentException("Input geometry must be  polygonal");
        }
    }

    public void setVertexNumFraction(double vertexNumFraction) {
        double frac;
        this.vertexNumFraction = frac = MathUtil.clamp(vertexNumFraction, 0.0, 1.0);
    }

    public void setAreaDeltaRatio(double areaDeltaRatio) {
        this.areaDeltaRatio = areaDeltaRatio;
    }

    public Geometry getResult() {
        if (this.vertexNumFraction == 1.0 || this.areaDeltaRatio == 0.0) {
            return this.inputGeom.copy();
        }
        if (this.inputGeom instanceof MultiPolygon) {
            boolean isOverlapPossible;
            boolean bl = isOverlapPossible = this.isOuter && this.inputGeom.getNumGeometries() > 1;
            if (isOverlapPossible) {
                return this.computeMultiPolygonAll((MultiPolygon)this.inputGeom);
            }
            return this.computeMultiPolygonEach((MultiPolygon)this.inputGeom);
        }
        if (this.inputGeom instanceof Polygon) {
            return this.computePolygon((Polygon)this.inputGeom);
        }
        throw new IllegalArgumentException("Input geometry must be polygonal");
    }

    private Geometry computeMultiPolygonAll(MultiPolygon multiPoly) {
        RingHullIndex hullIndex = new RingHullIndex();
        int nPoly = multiPoly.getNumGeometries();
        List[] polyHulls = new ArrayList[nPoly];
        for (int i = 0; i < multiPoly.getNumGeometries(); ++i) {
            List<RingHull> ringHulls;
            Polygon poly = (Polygon)multiPoly.getGeometryN(i);
            polyHulls[i] = ringHulls = this.initPolygon(poly, hullIndex);
        }
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (int i = 0; i < multiPoly.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)multiPoly.getGeometryN(i);
            Polygon hull = this.polygonHull(poly, polyHulls[i], hullIndex);
            polys.add(hull);
        }
        return this.geomFactory.createMultiPolygon(GeometryFactory.toPolygonArray(polys));
    }

    private Geometry computeMultiPolygonEach(MultiPolygon multiPoly) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (int i = 0; i < multiPoly.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)multiPoly.getGeometryN(i);
            Polygon hull = this.computePolygon(poly);
            polys.add(hull);
        }
        return this.geomFactory.createMultiPolygon(GeometryFactory.toPolygonArray(polys));
    }

    private Polygon computePolygon(Polygon poly) {
        boolean isOverlapPossible;
        RingHullIndex hullIndex = null;
        boolean bl = isOverlapPossible = !this.isOuter && poly.getNumInteriorRing() > 0;
        if (isOverlapPossible) {
            hullIndex = new RingHullIndex();
        }
        List<RingHull> hulls = this.initPolygon(poly, hullIndex);
        Polygon hull = this.polygonHull(poly, hulls, hullIndex);
        return hull;
    }

    private List<RingHull> initPolygon(Polygon poly, RingHullIndex hullIndex) {
        ArrayList<RingHull> hulls = new ArrayList<RingHull>();
        if (poly.isEmpty()) {
            return hulls;
        }
        double areaTotal = 0.0;
        if (this.areaDeltaRatio >= 0.0) {
            areaTotal = this.ringArea(poly);
        }
        hulls.add(this.createRingHull(poly.getExteriorRing(), this.isOuter, areaTotal, hullIndex));
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            hulls.add(this.createRingHull(poly.getInteriorRingN(i), !this.isOuter, areaTotal, hullIndex));
        }
        return hulls;
    }

    private double ringArea(Polygon poly) {
        double area = Area.ofRing(poly.getExteriorRing().getCoordinateSequence());
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            area += Area.ofRing(poly.getInteriorRingN(i).getCoordinateSequence());
        }
        return area;
    }

    private RingHull createRingHull(LinearRing ring, boolean isOuter, double areaTotal, RingHullIndex hullIndex) {
        RingHull ringHull = new RingHull(ring, isOuter);
        if (this.vertexNumFraction >= 0.0) {
            int targetVertexCount = (int)Math.ceil(this.vertexNumFraction * (double)(ring.getNumPoints() - 1));
            ringHull.setMinVertexNum(targetVertexCount);
        } else if (this.areaDeltaRatio >= 0.0) {
            double ringArea = Area.ofRing(ring.getCoordinateSequence());
            double ringWeight = ringArea / areaTotal;
            double maxAreaDelta = ringWeight * this.areaDeltaRatio * ringArea;
            ringHull.setMaxAreaDelta(maxAreaDelta);
        }
        if (hullIndex != null) {
            hullIndex.add(ringHull);
        }
        return ringHull;
    }

    private Polygon polygonHull(Polygon poly, List<RingHull> ringHulls, RingHullIndex hullIndex) {
        if (poly.isEmpty()) {
            return this.geomFactory.createPolygon();
        }
        int ringIndex = 0;
        LinearRing shellHull = ringHulls.get(ringIndex++).getHull(hullIndex);
        ArrayList<LinearRing> holeHulls = new ArrayList<LinearRing>();
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            LinearRing hull = ringHulls.get(ringIndex++).getHull(hullIndex);
            holeHulls.add(hull);
        }
        LinearRing[] resultHoles = GeometryFactory.toLinearRingArray(holeHulls);
        return this.geomFactory.createPolygon(shellHull, resultHoles);
    }
}

