/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.mutable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.kafka.server.mutable.BoundedListTooLongException;

public class BoundedList<E>
implements List<E> {
    private final int maxLength;
    private final List<E> underlying;

    public static <E> BoundedList<E> newArrayBacked(int maxLength) {
        return new BoundedList(maxLength, new ArrayList());
    }

    public static <E> BoundedList<E> newArrayBacked(int maxLength, int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Invalid non-positive initialCapacity of " + initialCapacity);
        }
        return new BoundedList(maxLength, new ArrayList(initialCapacity));
    }

    private BoundedList(int maxLength, List<E> underlying) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Invalid non-positive maxLength of " + maxLength);
        }
        if (underlying.size() > maxLength) {
            throw new BoundedListTooLongException("Cannot wrap list, because it is longer than the maximum length " + maxLength);
        }
        this.maxLength = maxLength;
        this.underlying = underlying;
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return Collections.unmodifiableList(this.underlying).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.underlying.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this.underlying.size() >= this.maxLength) {
            throw new BoundedListTooLongException("Cannot add another element to the list because it would exceed the maximum length of " + this.maxLength);
        }
        return this.underlying.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.underlying.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.underlying.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int numToAdd = c.size();
        if (this.underlying.size() > this.maxLength - numToAdd) {
            throw new BoundedListTooLongException("Cannot add another " + numToAdd + " element(s) to the list because it would exceed the maximum length of " + this.maxLength);
        }
        return this.underlying.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int numToAdd = c.size();
        if (this.underlying.size() > this.maxLength - numToAdd) {
            throw new BoundedListTooLongException("Cannot add another " + numToAdd + " element(s) to the list because it would exceed the maximum length of " + this.maxLength);
        }
        return this.underlying.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.underlying.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.underlying.retainAll(c);
    }

    @Override
    public void clear() {
        this.underlying.clear();
    }

    @Override
    public E get(int index) {
        return this.underlying.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.underlying.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        if (this.underlying.size() >= this.maxLength) {
            throw new BoundedListTooLongException("Cannot add another element to the list because it would exceed the maximum length of " + this.maxLength);
        }
        this.underlying.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.underlying.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.underlying.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.underlying.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return Collections.unmodifiableList(this.underlying).listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return Collections.unmodifiableList(this.underlying).listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.underlying).subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        return this.underlying.equals(o);
    }

    @Override
    public int hashCode() {
        return this.underlying.hashCode();
    }

    public String toString() {
        return this.underlying.toString();
    }
}

