/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.breadcrumb;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.EmptyAction;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.DoubleClickMouseAdapter;
import org.jkiss.dbeaver.ui.controls.breadcrumb.BreadcrumbViewer;
import org.jkiss.utils.CommonUtils;

final class BreadcrumbItem
extends Item {
    private static final int DROP_DOWN_MAX_ITEMS = 30;
    private final BreadcrumbViewer viewer;
    private final Composite container;
    private final Label elementArrow;
    private final Label elementImage;
    private final Label elementText;
    private final Composite detailComposite;
    private final Composite imageComposite;
    private final Composite textComposite;
    private final MenuManager menuManager;
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private ILabelProvider toolTipLabelProvider;
    private boolean showText = true;

    public BreadcrumbItem(@NotNull BreadcrumbViewer viewer, @NotNull Composite parent) {
        super((Widget)parent, 0);
        this.viewer = viewer;
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).create());
        this.elementArrow = new Label(this.container, 0);
        this.elementArrow.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.elementArrow.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TREE_EXPAND));
        this.detailComposite = new Composite(this.container, 0);
        this.detailComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.detailComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).create());
        this.imageComposite = new Composite(this.detailComposite, 0);
        this.imageComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.imageComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(2, 1).create());
        this.textComposite = new Composite(this.detailComposite, 0);
        this.textComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(2, 2).create());
        this.elementImage = new Label(this.imageComposite, 0);
        this.elementImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.elementText = new Label(this.textComposite, 0);
        this.elementText.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addElementListener((Control)this.detailComposite);
        this.addElementListener((Control)this.imageComposite);
        this.addElementListener((Control)this.textComposite);
        this.addElementListener((Control)this.elementImage);
        this.addElementListener((Control)this.elementText);
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(manager -> {
            ITreeContentProvider contentProvider = viewer.getDropDownContentProvider();
            Object[] elements = contentProvider.getElements(this.getData());
            int i = 0;
            while (i < Math.min(elements.length, 30)) {
                final Object element = elements[i];
                ILabelProvider labelProvider = (ILabelProvider)viewer.getLabelProvider();
                String name = labelProvider.getText(element);
                Image image = labelProvider.getImage(element);
                manager.add((IAction)new Action(name, ImageDescriptor.createFromImage((Image)image)){

                    public void run() {
                        BreadcrumbItem.this.openElement(element);
                    }
                });
                ++i;
            }
            if (elements.length > 30) {
                manager.add((IAction)new EmptyAction(NLS.bind((String)"... {0} more", (Object)(elements.length - 30))));
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.container.dispose();
        this.menuManager.dispose();
    }

    public void refresh() {
        Object input = this.getData();
        this.setText(this.labelProvider.getText(input));
        this.setImage(this.labelProvider.getImage(input));
        this.setToolTipText(this.toolTipLabelProvider.getText(input));
        this.setArrowVisible(this.contentProvider.getParent(this.getData()) != null);
    }

    @NotNull
    public BreadcrumbViewer getViewer() {
        return this.viewer;
    }

    @NotNull
    public Composite getContainer() {
        return this.container;
    }

    @NotNull
    public Rectangle getBounds() {
        return this.container.getBounds();
    }

    public void setLabelProvider(@NotNull ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setContentProvider(@NotNull ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setToolTipLabelProvider(@NotNull ILabelProvider toolTipLabelProvider) {
        this.toolTipLabelProvider = toolTipLabelProvider;
    }

    public void setImage(@Nullable Image image) {
        if (image != this.elementImage.getImage()) {
            this.elementImage.setImage(image);
        }
    }

    public void setText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.elementText.getText())) {
            this.elementText.setText(text);
        }
    }

    public void setToolTipText(@Nullable String toolTipText) {
        this.textComposite.setToolTipText(toolTipText);
        this.elementText.setToolTipText(toolTipText);
        this.elementImage.setToolTipText(toolTipText);
    }

    public void setTrailing(boolean trailing) {
        ((GridData)this.container.getLayoutData()).grabExcessHorizontalSpace = trailing;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setShowText(boolean showText) {
        if (this.showText == showText) {
            return;
        }
        this.showText = showText;
        UIUtils.setControlVisible((Control)this.textComposite, showText);
        if (showText) {
            this.detailComposite.setTabList(new Control[]{this.textComposite});
        } else {
            this.detailComposite.setTabList(new Control[]{this.imageComposite});
        }
    }

    public int computeWidth() {
        return this.container.computeSize((int)-1, (int)-1).x;
    }

    private void setArrowVisible(boolean visible) {
        UIUtils.setControlVisible((Control)this.elementArrow, visible);
    }

    private void showMenu() {
        Point location = this.detailComposite.toDisplay(0, 0);
        if (CommonUtils.isBitSet((int)this.viewer.getStyle(), (int)128)) {
            location.y += this.detailComposite.getSize().y;
        }
        Menu menu = this.menuManager.createContextMenu((Control)this.container);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private void openElement(@NotNull Object element) {
        this.viewer.fireMenuSelection(element);
    }

    private void addElementListener(@NotNull Control control) {
        control.addMenuDetectListener(e -> this.showMenu());
        control.addMouseListener((MouseListener)new DoubleClickMouseAdapter(){

            @Override
            public void onMouseSingleClick(@NotNull MouseEvent e) {
                BreadcrumbItem.this.showMenu();
            }

            @Override
            public void onMouseDoubleClick(@NotNull MouseEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItem.this.getViewer();
                viewer.selectItem(BreadcrumbItem.this);
                viewer.fireDoubleClick();
            }
        });
    }
}

