﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/migrationhuborchestrator/MigrationHubOrchestrator_EXPORTS.h>
#include <aws/migrationhuborchestrator/model/StepGroupStatus.h>
#include <aws/migrationhuborchestrator/model/Tool.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MigrationHubOrchestrator {
namespace Model {
class GetTemplateStepGroupResult {
 public:
  AWS_MIGRATIONHUBORCHESTRATOR_API GetTemplateStepGroupResult() = default;
  AWS_MIGRATIONHUBORCHESTRATOR_API GetTemplateStepGroupResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MIGRATIONHUBORCHESTRATOR_API GetTemplateStepGroupResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID of the template.</p>
   */
  inline const Aws::String& GetTemplateId() const { return m_templateId; }
  template <typename TemplateIdT = Aws::String>
  void SetTemplateId(TemplateIdT&& value) {
    m_templateIdHasBeenSet = true;
    m_templateId = std::forward<TemplateIdT>(value);
  }
  template <typename TemplateIdT = Aws::String>
  GetTemplateStepGroupResult& WithTemplateId(TemplateIdT&& value) {
    SetTemplateId(std::forward<TemplateIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the step group.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  GetTemplateStepGroupResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the step group.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetTemplateStepGroupResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the step group.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetTemplateStepGroupResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the step group.</p>
   */
  inline StepGroupStatus GetStatus() const { return m_status; }
  inline void SetStatus(StepGroupStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline GetTemplateStepGroupResult& WithStatus(StepGroupStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the step group was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  GetTemplateStepGroupResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the step group was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  GetTemplateStepGroupResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>List of AWS services utilized in a migration workflow.</p>
   */
  inline const Aws::Vector<Tool>& GetTools() const { return m_tools; }
  template <typename ToolsT = Aws::Vector<Tool>>
  void SetTools(ToolsT&& value) {
    m_toolsHasBeenSet = true;
    m_tools = std::forward<ToolsT>(value);
  }
  template <typename ToolsT = Aws::Vector<Tool>>
  GetTemplateStepGroupResult& WithTools(ToolsT&& value) {
    SetTools(std::forward<ToolsT>(value));
    return *this;
  }
  template <typename ToolsT = Tool>
  GetTemplateStepGroupResult& AddTools(ToolsT&& value) {
    m_toolsHasBeenSet = true;
    m_tools.emplace_back(std::forward<ToolsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The previous step group.</p>
   */
  inline const Aws::Vector<Aws::String>& GetPrevious() const { return m_previous; }
  template <typename PreviousT = Aws::Vector<Aws::String>>
  void SetPrevious(PreviousT&& value) {
    m_previousHasBeenSet = true;
    m_previous = std::forward<PreviousT>(value);
  }
  template <typename PreviousT = Aws::Vector<Aws::String>>
  GetTemplateStepGroupResult& WithPrevious(PreviousT&& value) {
    SetPrevious(std::forward<PreviousT>(value));
    return *this;
  }
  template <typename PreviousT = Aws::String>
  GetTemplateStepGroupResult& AddPrevious(PreviousT&& value) {
    m_previousHasBeenSet = true;
    m_previous.emplace_back(std::forward<PreviousT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next step group.</p>
   */
  inline const Aws::Vector<Aws::String>& GetNext() const { return m_next; }
  template <typename NextT = Aws::Vector<Aws::String>>
  void SetNext(NextT&& value) {
    m_nextHasBeenSet = true;
    m_next = std::forward<NextT>(value);
  }
  template <typename NextT = Aws::Vector<Aws::String>>
  GetTemplateStepGroupResult& WithNext(NextT&& value) {
    SetNext(std::forward<NextT>(value));
    return *this;
  }
  template <typename NextT = Aws::String>
  GetTemplateStepGroupResult& AddNext(NextT&& value) {
    m_nextHasBeenSet = true;
    m_next.emplace_back(std::forward<NextT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetTemplateStepGroupResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_templateId;

  Aws::String m_id;

  Aws::String m_name;

  Aws::String m_description;

  StepGroupStatus m_status{StepGroupStatus::NOT_SET};

  Aws::Utils::DateTime m_creationTime{};

  Aws::Utils::DateTime m_lastModifiedTime{};

  Aws::Vector<Tool> m_tools;

  Aws::Vector<Aws::String> m_previous;

  Aws::Vector<Aws::String> m_next;

  Aws::String m_requestId;
  bool m_templateIdHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_toolsHasBeenSet = false;
  bool m_previousHasBeenSet = false;
  bool m_nextHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MigrationHubOrchestrator
}  // namespace Aws
