import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
  Provider,
} from "@smithy/types";
import { CloudFrontClientResolvedConfig } from "../CloudFrontClient";
export interface CloudFrontHttpAuthSchemeParameters
  extends HttpAuthSchemeParameters {
  region?: string;
}
export interface CloudFrontHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    CloudFrontClientResolvedConfig,
    HandlerExecutionContext,
    CloudFrontHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultCloudFrontHttpAuthSchemeParametersProvider: (
  config: CloudFrontClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<CloudFrontHttpAuthSchemeParameters>;
export interface CloudFrontHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<CloudFrontHttpAuthSchemeParameters> {}
export declare const defaultCloudFrontHttpAuthSchemeProvider: CloudFrontHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  authSchemePreference?: string[] | Provider<string[]>;
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: CloudFrontHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly authSchemePreference: Provider<string[]>;
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: CloudFrontHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
