---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, structure d'une page
---

# Quelle est la structure d'une page LaTeX ?

## Le découpage de la page

Pour simplifier, une page est composée du corps du texte, d'un en-tête 
et d'un pied de page. Des marges sont également définies de chaque côté 
du corps du texte.

Mais rien de tel qu'un bon exemple visuel pour comprendre cette organisation 
et sa finesse.

L'extension <ctanpkg:layout> produit, avec la commande `\layout`, une page 
d'exemple qui montre la taille relative des différentes zones de la page, 
en incluant les modifications que vous pourriez avoir fait 
sur les paramètres de la page. Elle vous guidera donc, au besoin, 
dans la définition d'une structure personnalisée de page.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{layout}

\begin{document}
\layout
\end{document}
```

Notez que  <ctanpkg:layout> reconnait l'option `french` : 
l'extension décrit alors en commentaire les dimensions de la page en français.


## Les dimensions associées à la page

Observables avec l'extension <ctanpkg:layout>, les différentes dimensions 
sont décrites à la question "[](liste_des_parametres_de_page)".


## Les liens entre les différentes dimensions de la page

LaTeX contrôle la mise en page avec un certain nombre de paramètres, 
qui vous permettent de modifier la distance entre les bords d'une page 
et les bords gauche et supérieur du texte, la largeur et la hauteur du texte,
et le placement des autres éléments sur la page. Cependant, ils sont 
quelque peu complexes et il est facile de se tromper dans leurs interrelations
lors de la redéfinition de la mise en page. L'extension <ctanpkg:layout>, 
citée ci-dessus, n'affiche pas ses interrelations.

De fait, même la modification de la hauteur et de la largeur du texte, 
`\textheight` et `\textwidth`, nécessite plus de soin que vous ne le pensez :
- la hauteur doit être définie pour s'adapter à un nombre entier de lignes 
  de texte (en termes de multiples de `\baselineskip`) ;
- la largeur doit être limitée par le nombre de caractères par ligne.

Les marges sont contrôlées par deux paramètres : `\oddsidemargin` et 
`\evensidemargin`, dont les noms proviennent de la convention selon laquelle 
les pages du recto, impaires (*odd*), apparaissent sur le côté droit 
d'une planche de deux pages et les pages du verso, paires (*even*), 
sur le côté gauche. Les deux paramètres se réfèrent en fait à la marge 
de gauche des pages concernées. Dans chaque cas, la marge de droite 
est déterminée implicitement, à partir de la valeur de `\textwidth` 
et de la largeur du papier. Dans un document en recto uniquement, 
correspondant à la présentation par défaut dans de nombreuses classes, 
telles les classes standard <ctanpkg:article> et <ctanpkg:report>, 
`\oddsidemargin` représente les deux marges.

La position zéro (ou "origine") sur la page est à un pouce du haut du papier 
et à un pouce du côté gauche. Les mesures horizontales positives s'étendent
ensuite en largueur sur la page et les mesures verticales positives 
s'étendent le long de la page. Ainsi, les paramètres `\evensidemargin`, 
`\oddsidemargin` et `\topmargin` doivent être réglés à 1 pouce de moins 
que la vraie marge. Pour des marges plus proches des bords gauche 
et supérieur de la page que 1 pouce, les paramètres de marge 
doivent être définis par des valeurs négatives.


## La redéfinition des dimensions associées à la page

Chaque classe de documents assigne des valeurs par défaut aux paramètres 
de mise en page. L'utilisateur peut redéfinir les valeurs de ces paramètres. 
Cela lui permet de créer sa propre mise en page. 

Vous pouvez ici vous tourner vers la question 
"[](modifier_les_parametres_de_page.md)".