% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_filter-methods.R
\name{filterfun_sample}
\alias{filterfun_sample}
\title{A sample-wise filter function builder
analogous to \code{\link[genefilter]{filterfun}}.}
\usage{
filterfun_sample(...)
}
\arguments{
\item{...}{A comma-separated list of functions.}
}
\value{
An enclosure (function) that itself will return a logical vector, 
 according to the
 functions provided in the argument list, evaluated in order. The output of
 filterfun_sample is appropriate for the `flist' argument to the 
 genefilter_sample method.
}
\description{
See the \code{\link[genefilter]{filterfun}}, from the Bioconductor repository,
for a taxa-/gene-wise filter (and further examples).
}
\examples{
# Use simulated abundance matrix
set.seed(711)
testOTU <- otu_table(matrix(sample(1:50, 25, replace=TRUE), 5, 5), taxa_are_rows=FALSE)
f1  <- filterfun_sample(topk(2))
wh1 <- genefilter_sample(testOTU, f1, A=2)
wh2 <- c(TRUE, TRUE, TRUE, FALSE, FALSE)
prune_taxa(wh1, testOTU)
prune_taxa(wh2, testOTU)
}
\seealso{
\code{\link[genefilter]{filterfun}}, \code{\link{genefilter_sample}}
}
