CREATE TABLE IF NOT EXISTS us_gaz (
    id serial,
    seq integer,
    word text,
    stdword text,
    token integer, is_custom boolean NOT NULL DEFAULT true, CONSTRAINT pk_us_gaz PRIMARY KEY(id)
);

-- this will be needed for upgrading to prevent purging of custom entries
DELETE FROM us_gaz WHERE is_custom = false;

-- needed so entries we add will default to not custom
ALTER TABLE us_gaz ALTER COLUMN is_custom SET DEFAULT false;

INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AB', 'ALBERTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'AB', 'ALBERTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'AB', 'ALBERTA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AFB', 'AIR FORCE BASE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'A F B', 'AIR FORCE BASE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AIR FORCE BASE', 'AIR FORCE BASE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AK', 'ALASKA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'AK', 'ALASKA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'AK', 'ALASKA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AL', 'ALABAMA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'AL', 'ALABAMA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'AL', 'ALABAMA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ALA', 'ALABAMA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ALA', 'ALABAMA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ALA', 'ALABAMA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ALABAMA', 'ALABAMA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ALABAMA', 'ALABAMA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ALASKA', 'ALASKA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ALASKA', 'ALASKA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ALBERTA', 'ALBERTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ALBERTA', 'ALBERTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AR', 'ARKANSAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'AR', 'ARKANSAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'AR', 'ARKANSAS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ARIZ', 'ARIZONA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ARIZ', 'ARIZONA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ARIZ', 'ARIZONA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ARIZONA', 'ARIZONA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ARIZONA', 'ARIZONA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ARK', 'ARKANSAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ARK', 'ARKANSAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ARK', 'ARKANSAS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ARKANSAS', 'ARKANSAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ARKANSAS', 'ARKANSAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AZ', 'ARIZONA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'AZ', 'ARIZONA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'AZ', 'ARIZONA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'B C', 'BRITISH COLUMBIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'B C', 'BRITISH COLUMBIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'B C', 'BRITISH COLUMBIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'BC', 'BRITISH COLUMBIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'BC', 'BRITISH COLUMBIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'BC', 'BRITISH COLUMBIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'BRITISH COLUMBIA', 'BRITISH COLUMBIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'BRITISH COLUMBIA', 'BRITISH COLUMBIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CA', 'CALIFORNIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CA', 'CALIFORNIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'CA', 'CALIFORNIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (4, 'CA', 'CANADA', 12);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (5, 'CA', 'CARRE', 2);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CALIF', 'CALIFORNIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CALIF', 'CALIFORNIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'CALIF', 'CALIFORNIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CALIFORNIA', 'CALIFORNIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CALIFORNIA', 'CALIFORNIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CANADA', 'CANADA', 12);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CANADA', 'CANADA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CO', 'COLORADO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CO', 'COLORADO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'CO', 'COLORADO', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'COLOMBIE BRITANNIQUE', 'BRITISH COLUMBIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'COLOMBIE BRITANNIQUE', 'BRITISH COLUMBIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'COLORADO', 'COLORADO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'COLORADO', 'COLORADO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CONN', 'CONNECTICUT', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CONN', 'CONNECTICUT', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'CONN', 'CONNECTICUT', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CONNECTICUT', 'CONNECTICUT', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CONNECTICUT', 'CONNECTICUT', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CT', 'CONNECTICUT', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'CT', 'CONNECTICUT', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'CT', 'CONNECTICUT', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DC', 'DISTRICT OF COLUMBIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'DC', 'DISTRICT OF COLUMBIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'DC', 'DISTRICT OF COLUMBIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE', 'DELAWARE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'DE', 'DELAWARE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DEL', 'DELAWARE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'DEL', 'DELAWARE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'DEL', 'DELAWARE', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DELAWARE', 'DELAWARE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'DELAWARE', 'DELAWARE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DISTRICT OF COLUMBIA', 'DISTRICT OF COLUMBIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'DISTRICT OF COLUMBIA', 'DISTRICT OF COLUMBIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FL', 'FLORIDA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'FL', 'FLORIDA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'FL', 'FLORIDA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FLA', 'FLORIDA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'FLA', 'FLORIDA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'FLA', 'FLORIDA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FLORIDA', 'FLORIDA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'FLORIDA', 'FLORIDA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FRKS', 'FORKS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'GA', 'GEORGIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'GA', 'GEORGIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'GA', 'GEORGIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'GEORGIA', 'GEORGIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'GEORGIA', 'GEORGIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HAWAII', 'HAWAII', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'HAWAII', 'HAWAII', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HI', 'HAWAII', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'HI', 'HAWAII', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'HI', 'HAWAII', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'IA', 'IOWA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'IA', 'IOWA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'IA', 'IOWA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ID', 'IDAHO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ID', 'IDAHO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ID', 'IDAHO', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'IDAHO', 'IDAHO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'IDAHO', 'IDAHO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'IL', 'ILLINOIS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'IL', 'ILLINOIS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'IL', 'ILLINOIS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ILE DU PRINCE EDOUARD', 'PRINCE EDWARD ISLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ILE DU PRINCE EDOUARD', 'PRINCE EDWARD ISLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ILL', 'ILLINOIS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ILL', 'ILLINOIS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ILL', 'ILLINOIS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ILLINOIS', 'ILLINOIS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ILLINOIS', 'ILLINOIS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'IN', 'INDIANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'IN', 'INDIANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'IN', 'INDIANA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'IND', 'INDIANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'IND', 'INDIANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'IND', 'INDIANA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'INDIANA', 'INDIANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'INDIANA', 'INDIANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'IOWA', 'IOWA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'IOWA', 'IOWA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'KANSAS', 'KANSAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'KANSAS', 'KANSAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'KENT', 'KENTUCKY', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'KENT', 'KENTUCKY', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'KENT', 'KENTUCKY', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'KENTUCKY', 'KENTUCKY', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'KENTUCKY', 'KENTUCKY', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'KS', 'KANSAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'KS', 'KANSAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'KS', 'KANSAS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'KY', 'KENTUCKY', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'KY', 'KENTUCKY', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'KY', 'KENTUCKY', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA', 'LOUISIANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'LA', 'LOUISIANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'LA', 'LOUISIANA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LABRADOR', 'NEWFOUNDLAND AND LABRADOR', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'LABRADOR', 'NEWFOUNDLAND AND LABRADOR', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LOUISIANA', 'LOUISIANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'LOUISIANA', 'LOUISIANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MA', 'MASSACHUSETTS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MA', 'MASSACHUSETTS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MA', 'MASSACHUSETTS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (4, 'MA', 'MANOR', 2);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MAINE', 'MAINE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MAINE', 'MAINE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MANITOBA', 'MANITOBA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MANITOBA', 'MANITOBA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MARYLAND', 'MARYLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MARYLAND', 'MARYLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MASS', 'MASSACHUSETTS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MASS', 'MASSACHUSETTS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MASS', 'MASSACHUSETTS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MASSACHUSETTS', 'MASSACHUSETTS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MASSACHUSETTS', 'MASSACHUSETTS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MB', 'MANITOBA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MB', 'MANITOBA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MB', 'MANITOBA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MD', 'MARYLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MD', 'MARYLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MD', 'MARYLAND', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ME', 'MAINE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ME', 'MAINE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ME', 'MAINE', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MI', 'MICHIGAN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MI', 'MICHIGAN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MI', 'MICHIGAN', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MICH', 'MICHIGAN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MICH', 'MICHIGAN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MICH', 'MICHIGAN', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MICHIGAN', 'MICHIGAN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MICHIGAN', 'MICHIGAN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MINN', 'MINNESOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MINN', 'MINNESOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MINN', 'MINNESOTA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MINNESOTA', 'MINNESOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MINNESOTA', 'MINNESOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MISSISSIPPI', 'MISSISSIPPI', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MISSISSIPPI', 'MISSISSIPPI', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MISSOURI', 'MISSOURI', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MISSOURI', 'MISSOURI', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MN', 'MINNESOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MN', 'MINNESOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MN', 'MINNESOTA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MO', 'MISSOURI', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MO', 'MISSOURI', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MO', 'MISSOURI', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MONT', 'MONTANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MONT', 'MONTANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MONT', 'MONTANA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MONTANA', 'MONTANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MONTANA', 'MONTANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MT', 'MONTANA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MT', 'MONTANA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MT', 'MONTANA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MS', 'MISSISSIPPI', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'MS', 'MISSISSIPPI', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'MS', 'MISSISSIPPI', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'N CAROLINA', 'NORTH CAROLINA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'N CAROLINA', 'NORTH CAROLINA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'N DAKOTA', 'NORTH DAKOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'N DAKOTA', 'NORTH DAKOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NB', 'NEW BRUNSWICK', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NB', 'NEW BRUNSWICK', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NB', 'NEW BRUNSWICK', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NC', 'NORTH CAROLINA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NC', 'NORTH CAROLINA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NC', 'NORTH CAROLINA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ND', 'NORTH DAKOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ND', 'NORTH DAKOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ND', 'NORTH DAKOTA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NE', 'NEBRASKA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NE', 'NEBRASKA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NE', 'NEBRASKA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEB', 'NEBRASKA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEB', 'NEBRASKA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NEB', 'NEBRASKA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEBRASKA', 'NEBRASKA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEBRASKA', 'NEBRASKA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEV', 'NEVADA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEV', 'NEVADA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NEV', 'NEVADA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEVADA', 'NEVADA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEVADA', 'NEVADA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEW BRUNSWICK', 'NEW BRUNSWICK', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEW BRUNSWICK', 'NEW BRUNSWICK', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEW HAMPSHIRE', 'NEW HAMPSHIRE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEW HAMPSHIRE', 'NEW HAMPSHIRE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEW JERSEY', 'NEW JERSEY', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEW JERSEY', 'NEW JERSEY', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEW MEXICO', 'NEW MEXICO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEW MEXICO', 'NEW MEXICO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEW YORK', 'NEW YORK', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEW YORK', 'NEW YORK', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NEWFOUNDLAND', 'NEWFOUNDLAND AND LABRADOR', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NEWFOUNDLAND', 'NEWFOUNDLAND AND LABRADOR', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NF', 'NEWFOUNDLAND AND LABRADOR', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NF', 'NEWFOUNDLAND AND LABRADOR', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NF', 'NEWFOUNDLAND AND LABRADOR', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NH', 'NEW HAMPSHIRE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NH', 'NEW HAMPSHIRE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NH', 'NEW HAMPSHIRE', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NJ', 'NEW JERSEY', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NJ', 'NEW JERSEY', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NJ', 'NEW JERSEY', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NL', 'NEWFOUNDLAND AND LABRADOR', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NL', 'NEWFOUNDLAND AND LABRADOR', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NL', 'NEWFOUNDLAND AND LABRADOR', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NM', 'NEW MEXICO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NM', 'NEW MEXICO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NM', 'NEW MEXICO', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NORTH CAROLINA', 'NORTH CAROLINA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NORTH CAROLINA', 'NORTH CAROLINA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NORTH DAKOTA', 'NORTH DAKOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NORTH DAKOTA', 'NORTH DAKOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NORTHWEST', 'NORTHWEST', 22);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NORTHWEST TERRITORIES', 'NORTHWEST TERRITORIES', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NORTHWEST TERRITORIES', 'NORTHWEST TERRITORIES', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NOUVEAU BRUNSWICK', 'NEW BRUNSWICK', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NOUVEAU BRUNSWICK', 'NEW BRUNSWICK', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NOUVELLE ECOSSE', 'NOVA SCOTIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NOUVELLE ECOSSE', 'NOVA SCOTIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NOVA SCOTIA', 'NOVA SCOTIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NOVA SCOTIA', 'NOVA SCOTIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NS', 'NOVA SCOTIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NS', 'NOVA SCOTIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NS', 'NOVA SCOTIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NT', 'NORTHWEST TERRITORIES', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NT', 'NORTHWEST TERRITORIES', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NT', 'NORTHWEST TERRITORIES', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NU', 'NUNAVUT', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NU', 'NUNAVUT', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NU', 'NUNAVUT', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NUNAVUT', 'NUNAVUT', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NUNAVUT', 'NUNAVUT', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NV', 'NEVADA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NV', 'NEVADA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NV', 'NEVADA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NY', 'NEW YORK', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'NY', 'NEW YORK', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'NY', 'NEW YORK', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'OH', 'OHIO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'OH', 'OHIO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'OH', 'OHIO', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'OHIO', 'OHIO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'OHIO', 'OHIO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'OK', 'OKLAHOMA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'OK', 'OKLAHOMA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'OK', 'OKLAHOMA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'OKLA', 'OKLAHOMA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'OKLA', 'OKLAHOMA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'OKLA', 'OKLAHOMA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'OKLAHOMA', 'OKLAHOMA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'OKLAHOMA', 'OKLAHOMA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ON', 'ONTARIO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ON', 'ONTARIO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ON', 'ONTARIO', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ONT', 'ONTARIO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ONT', 'ONTARIO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ONT', 'ONTARIO', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ONTARIO', 'ONTARIO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ONTARIO', 'ONTARIO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'OR', 'OREGON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'OR', 'OREGON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'OR', 'OREGON', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ORE', 'OREGON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'ORE', 'OREGON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'ORE', 'OREGON', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'OREGON', 'OREGON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'OREGON', 'OREGON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PA', 'PENNSYLVANIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PA', 'PENNSYLVANIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'PA', 'PENNSYLVANIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PE', 'PRINCE EDWARD ISLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PE', 'PRINCE EDWARD ISLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'PE', 'PRINCE EDWARD ISLAND', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PEI', 'PRINCE EDWARD ISLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PEI', 'PRINCE EDWARD ISLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'PEI', 'PRINCE EDWARD ISLAND', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PENN', 'PENNSYLVANIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PENN', 'PENNSYLVANIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'PENN', 'PENNSYLVANIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PENNA', 'PENNSYLVANIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PENNA', 'PENNSYLVANIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'PENNA', 'PENNSYLVANIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PENNSYLVANIA', 'PENNSYLVANIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PENNSYLVANIA', 'PENNSYLVANIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PQ', 'QUEBEC', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PQ', 'QUEBEC', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'PQ', 'QUEBEC', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PR', 'PUERTO RICO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PR', 'PUERTO RICO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'PR', 'PUERTO RICO', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PRINCE EDWARD ISLAND', 'PRINCE EDWARD ISLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PRINCE EDWARD ISLAND', 'PRINCE EDWARD ISLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PUERTO RICO', 'PUERTO RICO', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'PUERTO RICO', 'PUERTO RICO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'QC', 'QUEBEC', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'QC', 'QUEBEC', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'QC', 'QUEBEC', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'QUEBEC', 'QUEBEC', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'QUEBEC', 'QUEBEC', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'RHODE ISLAND', 'RHODE ISLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'RHODE ISLAND', 'RHODE ISLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'RI', 'RHODE ISLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'RI', 'RHODE ISLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'RI', 'RHODE ISLAND', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'S CAROLINA', 'SOUTH CAROLINA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'S CAROLINA', 'SOUTH CAROLINA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'S DAKOTA', 'SOUTH DAKOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'S DAKOTA', 'SOUTH DAKOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SASK', 'SASKATCHEWAN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'SASK', 'SASKATCHEWAN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SASKATCHEWAN', 'SASKATCHEWAN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'SASKATCHEWAN', 'SASKATCHEWAN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SC', 'SOUTH CAROLINA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'SC', 'SOUTH CAROLINA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'SC', 'SOUTH CAROLINA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SD', 'SOUTH DAKOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'SD', 'SOUTH DAKOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'SD', 'SOUTH DAKOTA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SK', 'SASKATCHEWAN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'SK', 'SASKATCHEWAN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'SK', 'SASKATCHEWAN', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SOUTH CAROLINA', 'SOUTH CAROLINA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'SOUTH CAROLINA', 'SOUTH CAROLINA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SOUTH DAKOTA', 'SOUTH DAKOTA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'SOUTH DAKOTA', 'SOUTH DAKOTA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TENN', 'TENNESSEE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TENN', 'TENNESSEE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'TENN', 'TENNESSEE', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TENNESSEE', 'TENNESSEE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TENNESSEE', 'TENNESSEE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TERRE NEUVE', 'NEWFOUNDLAND', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TERRE NEUVE', 'NEWFOUNDLAND', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TERRITOIRES DU NORD OUES', 'NORTHWEST TERRITORIES', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TERRITOIRES DU NORD OUES', 'NORTHWEST TERRITORIES', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TEX', 'TEXAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TEX', 'TEXAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'TEX', 'TEXAS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TEXAS', 'TEXAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TEXAS', 'TEXAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TN', 'TENNESSEE', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TN', 'TENNESSEE', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'TN', 'TENNESSEE', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TX', 'TEXAS', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'TX', 'TEXAS', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'TX', 'TEXAS', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'U S', 'US', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'U S', 'USA', 12);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'U S A', 'USA', 12);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'UNITED STATES OF AMERICA', 'USA', 12);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'US', 'US', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'US', 'USA', 12);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'USA', 'USA', 12);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'UT', 'UTAH', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'UT', 'UTAH', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'UT', 'UTAH', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'UTAH', 'UTAH', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'UTAH', 'UTAH', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'VA', 'VIRGINIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'VA', 'VIRGINIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'VA', 'VIRGINIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'VERMONT', 'VERMONT', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'VERMONT', 'VERMONT', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'VIRGINIA', 'VIRGINIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'VIRGINIA', 'VIRGINIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'VT', 'VERMONT', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'VT', 'VERMONT', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'VT', 'VERMONT', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'W VIRGINIA', 'WEST VIRGINIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'W VIRGINIA', 'WEST VIRGINIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WA', 'WASHINGTON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WA', 'WASHINGTON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'WA', 'WASHINGTON', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WASH', 'WASHINGTON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WASH', 'WASHINGTON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'WASH', 'WASHINGTON', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WASHINGTON', 'WASHINGTON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WASHINGTON', 'WASHINGTON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WEST VIRGINIA', 'WEST VIRGINIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WEST VIRGINIA', 'WEST VIRGINIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WI', 'WISCONSIN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WI', 'WISCONSIN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'WI', 'WISCONSIN', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WISC', 'WISCONSIN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WISC', 'WISCONSIN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'WISC', 'WISCONSIN', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WISCONSIN', 'WISCONSIN', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WISCONSIN', 'WISCONSIN', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WV', 'WEST VIRGINIA', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WV', 'WEST VIRGINIA', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'WV', 'WEST VIRGINIA', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WY', 'WYOMING', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WY', 'WYOMING', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'WY', 'WYOMING', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WYOMING', 'WYOMING', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'WYOMING', 'WYOMING', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'YK', 'YUKON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'YK', 'YUKON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'YK', 'YUKON', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'YT', 'YUKON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'YT', 'YUKON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (3, 'YT', 'YUKON', 6);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'YUKON', 'YUKON', 11);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'YUKON', 'YUKON', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'BOIS D ARC', 'BOIS D ARC', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'BOIS D''ARC', 'BOIS D ARC', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CAMP H M SMITH', 'CAMP H M SMITH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CAMP HM SMITH', 'CAMP H M SMITH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'COEUR D ALENE', 'COEUR D ALENE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'COEUR D''ALENE', 'COEUR D ALENE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'D HANIS', 'D HANIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'D''HANIS', 'D HANIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL PASO', 'EL PASO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (2, 'EL PASO', 'EL PASO', 1);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT GEORGE G MEADE', 'FORT GEORGE G MEADE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT GEORGE MEADE', 'FORT GEORGE G MEADE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT MEADE', 'FORT GEORGE G MEADE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LAND O LAKES', 'LAND O LAKES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LAND O''LAKES', 'LAND O LAKES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'M C B H KANEOHE BAY', 'M C B H KANEOHE BAY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCBH KANEOHE BAY', 'M C B H KANEOHE BAY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'N VAN', 'NORTH VANCOUVER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'N VANCOUVER', 'NORTH VANCOUVER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NO VANCOUVER', 'NORTH VANCOUVER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'NORTH VANCOUVER', 'NORTH VANCOUVER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'O BRIEN', 'O BRIEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'O''BRIEN', 'O BRIEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'O FALLON', 'O FALLON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'O''FALLON', 'O FALLON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'O NEALS', 'O NEALS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'O''NEALS', 'O NEALS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ROUND O', 'ROUND O', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'S COFFEYVILLE', 'SOUTH COFFEYVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SOUTH COFFEYVILLE', 'SOUTH COFFEYVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'U S A F ACADEMY', 'U S A F ACADEMY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'USAF ACADEMY', 'U S A F ACADEMY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'W VAN', 'WEST VANCOUVER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'W VANCOUVER', 'WEST VANCOUVER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'WEST VANCOUVER', 'WEST VANCOUVER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AU GRES', 'AU GRES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AU SABLE FORKS', 'AU SABLE FORKS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AU SABLE FRKS', 'AU SABLE FORKS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AU TRAIN', 'AU TRAIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AVON BY THE SEA', 'AVON BY THE SEA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'AVON BY SEA', 'AVON BY THE SEA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'BAYOU LA BATRE', 'BAYOU LA BATRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'BIRD IN HAND', 'BIRD IN HAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CAMDEN ON GAULEY', 'CAMDEN ON GAULEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CARDIFF BY THE SEA', 'CARDIFF BY THE SEA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CARDIFF BY SEA', 'CARDIFF BY THE SEA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CASTLETON ON HUDSON', 'CASTLETON ON HUDSON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CAVE IN ROCK', 'CAVE IN ROCK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CORNWALL ON HUDSON', 'CORNWALL ON HUDSON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'CROTON ON HUDSON', 'CROTON ON HUDSON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE BEQUE', 'DE BEQUE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE BERRY', 'DE BERRY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE FOREST', 'DE FOREST', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE GRAFF', 'DE GRAFF', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE KALB', 'DE KALB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE KALB JUNCTION', 'DE KALB JUNCTION', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE LAND', 'DE LAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE LEON', 'DE LEON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE LEON SPRINGS', 'DE LEON SPRINGS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE MOSSVILLE', 'DE MOSSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE PERE', 'DE PERE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE PEYSTER', 'DE PEYSTER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE QUEEN', 'DE QUEEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE RUYTER', 'DE RUYTER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE SMET', 'DE SMET', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE SOTO', 'DE SOTO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE TOUR VILLAGE', 'DE TOUR VILLAGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE VALLS BLUFF', 'DE VALLS BLUFF', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'VALLS BLUFF', 'DE VALLS BLUFF', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE WITT', 'DE WITT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DE YOUNG', 'DE YOUNG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DU BOIS', 'DU BOIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DU PONT', 'DU PONT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'DU QUOIN', 'DU QUOIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'E MC KEESPORT', 'EAST MC KEESPORT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'E MCKEESPORT', 'EAST MC KEESPORT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EAST MC KEESPORT', 'EAST MC KEESPORT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EAST MCKEESPORT', 'EAST MC KEESPORT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL CAJON', 'EL CAJON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL CAMPO', 'EL CAMPO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL CENTRO', 'EL CENTRO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL CERRITO', 'EL CERRITO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL DORADO', 'EL DORADO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL DORADO HILLS', 'EL DORADO HILLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL DORADO SPRINGS', 'EL DORADO SPRINGS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL MIRAGE', 'EL MIRAGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL MONTE', 'EL MONTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL NIDO', 'EL NIDO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL PRADO', 'EL PRADO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL RENO', 'EL RENO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL RITO', 'EL RITO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL SEGUNDO', 'EL SEGUNDO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'EL SOBRANTE', 'EL SOBRANTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FALLS OF ROUGH', 'FALLS OF ROUGH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FOND DU LAC', 'FOND DU LAC', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORKS OF SALMON', 'FORKS OF SALMON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT MC COY', 'FORT MC COY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT MCCOY', 'FORT MC COY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT MC KAVETT', 'FORT MC KAVETT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT MCKAVETT', 'FORT MC KAVETT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FT MITCHELL', 'FORT MITCHELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT MITCHELL', 'FORT MITCHELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FT MYER', 'FORT MYER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT MYER', 'FORT MYER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FT WARREN AFB', 'FORT WARREN AFB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'FORT WARREN AFB', 'FORT WARREN AFB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HASTINGS ON HUDSON', 'HASTINGS ON HUDSON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HAVRE DE GRACE', 'HAVRE DE GRACE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HI HAT', 'HI HAT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HO HO KUS', 'HO HO KUS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HOWEY IN THE HILLS', 'HOWEY IN THE HILLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'HOWEY IN HILLS', 'HOWEY IN THE HILLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ISLE LA MOTTE', 'ISLE LA MOTTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ISLE OF PALMS', 'ISLE OF PALMS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ISLE OF SPRINGS', 'ISLE OF SPRINGS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'JAY EM', 'JAY EM', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'KING OF PRUSSIA', 'KING OF PRUSSIA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA BARGE', 'LA BARGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA BELLE', 'LA BELLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA CANADA FLINTRIDGE', 'LA CANADA FLINTRIDGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA CENTER', 'LA CENTER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA CONNER', 'LA CONNER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA COSTE', 'LA COSTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA CRESCENT', 'LA CRESCENT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA CRESCENTA', 'LA CRESCENTA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA CROSSE', 'LA CROSSE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA FARGE', 'LA FARGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA FARGEVILLE', 'LA FARGEVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA FAYETTE', 'LA FAYETTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA FERIA', 'LA FERIA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA FOLLETTE', 'LA FOLLETTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA FONTAINE', 'LA FONTAINE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA GRANDE', 'LA GRANDE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA GRANGE', 'LA GRANGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA GRANGE PARK', 'LA GRANGE PARK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA HABRA', 'LA HABRA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA HARPE', 'LA HARPE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA HONDA', 'LA HONDA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA JARA', 'LA JARA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA JOLLA', 'LA JOLLA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA JOSE', 'LA JOSE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA JOYA', 'LA JOYA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA JUNTA', 'LA JUNTA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA LOMA', 'LA LOMA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA LUZ', 'LA LUZ', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA MADERA', 'LA MADERA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA MARQUE', 'LA MARQUE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA MESA', 'LA MESA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA MIRADA', 'LA MIRADA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA MOILLE', 'LA MOILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA MONTE', 'LA MONTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA MOTTE', 'LA MOTTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PALMA', 'LA PALMA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PINE', 'LA PINE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PLACE', 'LA PLACE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PLATA', 'LA PLATA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PORTE', 'LA PORTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PORTE CITY', 'LA PORTE CITY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PRAIRIE', 'LA PRAIRIE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA PUENTE', 'LA PUENTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA QUINTA', 'LA QUINTA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA RUE', 'LA RUE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA RUSSELL', 'LA RUSSELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA SALLE', 'LA SALLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA VALLE', 'LA VALLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA VERGNE', 'LA VERGNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA VERKIN', 'LA VERKIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA VERNE', 'LA VERNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA VERNIA', 'LA VERNIA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA VETA', 'LA VETA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LA VISTA', 'LA VISTA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LAC DU FLAMBEAU', 'LAC DU FLAMBEAU', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LAKE IN THE HILLS', 'LAKE IN THE HILLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LAKE IN HILLS', 'LAKE IN THE HILLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE CENTER', 'LE CENTER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE CLAIRE', 'LE CLAIRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE GRAND', 'LE GRAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE MARS', 'LE MARS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE RAYSVILLE', 'LE RAYSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE ROY', 'LE ROY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE SUEUR', 'LE SUEUR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LE VERNE', 'LU VERNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'LU VERNE', 'LU VERNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MARINE ON SAINT CROIX', 'MARINE ON SAINT CROIX', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC ADENVILLE', 'MC ADENVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCADENVILLE', 'MC ADENVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC ALISTER', 'MC ALISTER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCALISTER', 'MC ALISTER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC ALISTERVILLE', 'MC ALISTERVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCALISTERVILLE', 'MC ALISTERVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC ALPIN', 'MC ALPIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCALPIN', 'MC ALPIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC ANDREWS', 'MC ANDREWS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCANDREWS', 'MC ANDREWS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC ARTHUR', 'MC ARTHUR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCARTHUR', 'MC ARTHUR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC BAIN', 'MC BAIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCBAIN', 'MC BAIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC BEE', 'MC BEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCBEE', 'MC BEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CALL CREEK', 'MC CALL CREEK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCALL CREEK', 'MC CALL CREEK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CALLA', 'MC CALLA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCALLA', 'MC CALLA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CALLSBURG', 'MC CALLSBURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCALLSBURG', 'MC CALLSBURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CAMEY', 'MC CAMEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCAMEY', 'MC CAMEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CARLEY', 'MC CARLEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCARLEY', 'MC CARLEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CARR', 'MC CARR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCARR', 'MC CARR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CASKILL', 'MC CASKILL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCASKILL', 'MC CASKILL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CAULLEY', 'MC CAULLEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCAULLEY', 'MC CAULLEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CAYSVILLE', 'MC CAYSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCAYSVILLE', 'MC CAYSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CLAVE', 'MC CLAVE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCLAVE', 'MC CLAVE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CLELLAND', 'MC CLELLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCLELLAND', 'MC CLELLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CLELLANDTOWN', 'MC CLELLANDTOWN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCLELLANDTOWN', 'MC CLELLANDTOWN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CLELLANVILLE', 'MC CLELLANVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCLELLANVILLE', 'MC CLELLANVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CLURE', 'MC CLURE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCLURE', 'MC CLURE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CLURG', 'MC CLURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCLURG', 'MC CLURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC COLL', 'MC COLL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCOLL', 'MC COLL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC COMB', 'MC COMB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCOMB', 'MC COMB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CONNELL', 'MC CONNELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCONNELL', 'MC CONNELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CONNELLS', 'MC CONNELLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCONNELLS', 'MC CONNELLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CONNELLSBURG', 'MC CONNELLSBURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCONNELLSBURG', 'MC CONNELLSBURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC COOK', 'MC COOK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCOOK', 'MC COOK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC COOL', 'MC COOL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCOOL', 'MC COOL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC COOL JUNCTION', 'MC COOL JUNCTION', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCOOL JUNCTION', 'MC COOL JUNCTION', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CORDSVILLE', 'MC CORDSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCORDSVILLE', 'MC CORDSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CORMICK', 'MC CORMICK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCORMICK', 'MC CORMICK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC COY', 'MC COY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCOY', 'MC COY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CRACKEN', 'MC CRACKEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCRACKEN', 'MC CRACKEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CRORY', 'MC CRORY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCRORY', 'MC CRORY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CUNE', 'MC CUNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCUNE', 'MC CUNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC CUTCHENVILLE', 'MC CUTCHENVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCCUTCHENVILLE', 'MC CUTCHENVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC DADE', 'MC DADE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCDADE', 'MC DADE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC DANIELS', 'MC DANIELS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCDANIELS', 'MC DANIELS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC DAVID', 'MC DAVID', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCDAVID', 'MC DAVID', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC DERMOTT', 'MC DERMOTT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCDERMOTT', 'MC DERMOTT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC DONALD', 'MC DONALD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCDONALD', 'MC DONALD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC DONOUGH', 'MC DONOUGH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCDONOUGH', 'MC DONOUGH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC DOWELL', 'MC DOWELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCDOWELL', 'MC DOWELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC EWEN', 'MC EWEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCEWEN', 'MC EWEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC FALL', 'MC FALL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCFALL', 'MC FALL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC FARLAND', 'MC FARLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCFARLAND', 'MC FARLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC GAHEYSVILLE', 'MC GAHEYSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCGAHEYSVILLE', 'MC GAHEYSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC GEE', 'MC GEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCGEE', 'MC GEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC GEHEE', 'MC GEHEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCGEHEE', 'MC GEHEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC GRADY', 'MC GRADY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCGRADY', 'MC GRADY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC GRATH', 'MC GRATH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCGRATH', 'MC GRATH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC GRAW', 'MC GRAW', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCGRAW', 'MC GRAW', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC GREGOR', 'MC GREGOR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCGREGOR', 'MC GREGOR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC HENRY', 'MC HENRY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCHENRY', 'MC HENRY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC INTIRE', 'MC INTIRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCINTIRE', 'MC INTIRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC INTOSH', 'MC INTOSH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCINTOSH', 'MC INTOSH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC INTYRE', 'MC INTYRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCINTYRE', 'MC INTYRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC KEAN', 'MC KEAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCKEAN', 'MC KEAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC KEE', 'MC KEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCKEE', 'MC KEE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC KEES ROCKS', 'MC KEES ROCKS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCKEES ROCKS', 'MC KEES ROCKS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC KENNEY', 'MC KENNEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCKENNEY', 'MC KENNEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC KENZIE', 'MC KENZIE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCKENZIE', 'MC KENZIE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC KITTRICK', 'MC KITTRICK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCKITTRICK', 'MC KITTRICK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC LAIN', 'MC LAIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCLAIN', 'MC LAIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC LAUGHLIN', 'MC LAUGHLIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCLAUGHLIN', 'MC LAUGHLIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC LEAN', 'MC LEAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCLEAN', 'MC LEAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC LEANSBORO', 'MC LEANSBORO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCLEANSBORO', 'MC LEANSBORO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC LEANSVILLE', 'MC LEANSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCLEANSVILLE', 'MC LEANSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC LEOD', 'MC LEOD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCLEOD', 'MC LEOD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC LOUTH', 'MC LOUTH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCLOUTH', 'MC LOUTH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC MILLAN', 'MC MILLAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCMILLAN', 'MC MILLAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC MINNVILLE', 'MC MINNVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCMINNVILLE', 'MC MINNVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC NABB', 'MC NABB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCNABB', 'MC NABB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC NEAL', 'MC NEAL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCNEAL', 'MC NEAL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC NEIL', 'MC NEIL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCNEIL', 'MC NEIL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC QUEENEY', 'MC QUEENEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCQUEENEY', 'MC QUEENEY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC RAE', 'MC RAE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCRAE', 'MC RAE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC ROBERTS', 'MC ROBERTS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCROBERTS', 'MC ROBERTS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC SHERRYSTOWN', 'MC SHERRYSTOWN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCSHERRYSTOWN', 'MC SHERRYSTOWN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MC VEYTOWN', 'MC VEYTOWN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MCVEYTOWN', 'MC VEYTOWN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MEADOWS OF DAN', 'MEADOWS OF DAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MI WUK VILLAGE', 'MI WUK VILLAGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MOUTH OF WILSON', 'MOUTH OF WILSON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MT ZION', 'MOUNT ZION', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'MOUNT ZION', 'MOUNT ZION', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PE ELL', 'PE ELL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'POINT OF ROCKS', 'POINT OF ROCKS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PONCE DE LEON', 'PONCE DE LEON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PRAIRIE DU CHIEN', 'PRAIRIE DU CHIEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PRAIRIE DU ROCHER', 'PRAIRIE DU ROCHER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'PRAIRIE DU SAC', 'PRAIRIE DU SAC', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'RANCHO SANTA FE', 'RANCHO SANTA FE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'RANCHOS DE TAOS', 'RANCHOS DE TAOS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SANTA FE', 'SANTA FE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SANTA FE SPRINGS', 'SANTA FE SPRINGS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'S EL MONTE', 'SOUTH EL MONTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SOUTH EL MONTE', 'SOUTH EL MONTE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT COLUMBANS', 'SAINT COLUMBANS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST COLUMBANS', 'SAINT COLUMBANS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TOWNSHIP OF WASHINGTON', 'TOWNSHIP OF WASHINGTON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TRUTH OR CONSEQUENCES', 'TRUTH OR CONSEQUENCES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'TY TY', 'TY TY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'VILLAGE OF NAGOG WOODS', 'VILLAGE OF NAGOG WOODS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST AGATHA', 'SAINT AGATHA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ALBANS', 'SAINT ALBANS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ANDREWS', 'SAINT ANDREWS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ANN', 'SAINT ANN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ANN HIGHLANDS', 'SAINT ANN HIGHLANDS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ANNA', 'SAINT ANNA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ANNE', 'SAINT ANNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ANSGAR', 'SAINT ANSGAR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ANTHONY', 'SAINT ANTHONY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ARMAND', 'SAINT ARMAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST AUBERT', 'SAINT AUBERT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST AUGUSTA', 'SAINT AUGUSTA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST AUGUSTINE', 'SAINT AUGUSTINE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST AUGUSTINE BEACH', 'SAINT AUGUSTINE BEACH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST AUGUSTINE SHORES', 'SAINT AUGUSTINE SHORES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST AUGUSTINE SOUTH', 'SAINT AUGUSTINE SOUTH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST BENEDICT', 'SAINT BENEDICT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST BERNARD', 'SAINT BERNARD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST BERNICE', 'SAINT BERNICE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST BONAVENTURE', 'SAINT BONAVENTURE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST BONIFACIUS', 'SAINT BONIFACIUS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST BRIDGET', 'SAINT BRIDGET', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CHARLES', 'SAINT CHARLES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CHARLES MESA', 'SAINT CHARLES MESA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CLAIR', 'SAINT CLAIR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CLAIR SHORES', 'SAINT CLAIR SHORES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CLAIRSVILLE', 'SAINT CLAIRSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CLEMENT', 'SAINT CLEMENT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CLERE', 'SAINT CLERE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CLOUD', 'SAINT CLOUD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CROIX', 'SAINT CROIX', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST CROIX FALLS', 'SAINT CROIX FALLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST DAVID', 'SAINT DAVID', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST DONATUS', 'SAINT DONATUS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST EDWARD', 'SAINT EDWARD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ELIZABETH', 'SAINT ELIZABETH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ELMO', 'SAINT ELMO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST FERDINAND', 'SAINT FERDINAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST FLORIAN', 'SAINT FLORIAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST FRANCIS', 'SAINT FRANCIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST FRANCISVILLE', 'SAINT FRANCISVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST FRANCOIS', 'SAINT FRANCOIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST GABRIEL', 'SAINT GABRIEL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST GEORGE', 'SAINT GEORGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST GEORGE ISLAND', 'SAINT GEORGE ISLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST GERMAIN', 'SAINT GERMAIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST HEDWIG', 'SAINT HEDWIG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST HELEN', 'SAINT HELEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST HELENA', 'SAINT HELENA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST HELENA ISLAND', 'SAINT HELENA ISLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST HELENS', 'SAINT HELENS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST HENRY', 'SAINT HENRY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST HILAIRE', 'SAINT HILAIRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST IGNACE', 'SAINT IGNACE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST IGNATIUS', 'SAINT IGNATIUS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JACOB', 'SAINT JACOB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JAMES', 'SAINT JAMES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JAMES CITY', 'SAINT JAMES CITY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JO', 'SAINT JO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOE', 'SAINT JOE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOHN', 'SAINT JOHN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOHNS', 'SAINT JOHNS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOHNS-FREEMONT', 'SAINT JOHNS-FREEMONT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOHNS FREEMONT', 'SAINT JOHNS-FREEMONT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOHNSBURY', 'SAINT JOHNSBURY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOHNSVILLE', 'SAINT JOHNSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JOSEPH', 'SAINT JOSEPH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST JUST', 'SAINT JUST', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LAWRENCE', 'SAINT LAWRENCE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LEO', 'SAINT LEO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LEON', 'SAINT LEON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LEONARD', 'SAINT LEONARD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LIBORY', 'SAINT LIBORY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LOUIS', 'SAINT LOUIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LOUIS PARK', 'SAINT LOUIS PARK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LOUISVILLE', 'SAINT LOUISVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LUCAS', 'SAINT LUCAS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST LUCIE VILLAGE', 'SAINT LUCIE VILLAGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARIE', 'SAINT MARIE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARIES', 'SAINT MARIES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARKS', 'SAINT MARKS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARTIN', 'SAINT MARTIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARTINS', 'SAINT MARTINS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARTINVILLE', 'SAINT MARTINVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARY', 'SAINT MARY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARY OF THE WOODS', 'SAINT MARY OF THE WOODS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARY''S', 'SAINT MARY''S', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARYS', 'SAINT MARYS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MARYS POINT', 'SAINT MARYS POINT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MATHIAS', 'SAINT MATHIAS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MATTHEWS', 'SAINT MATTHEWS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MAURICE', 'SAINT MAURICE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MEINRAD', 'SAINT MEINRAD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MICHAEL', 'SAINT MICHAEL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST MICHAELS', 'SAINT MICHAELS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST NAZIANZ', 'SAINT NAZIANZ', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST OLAF', 'SAINT OLAF', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ONGE', 'SAINT ONGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PARIS', 'SAINT PARIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PAUL', 'SAINT PAUL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PAUL PARK', 'SAINT PAUL PARK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PAULS', 'SAINT PAULS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PETE BEACH', 'SAINT PETE BEACH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PETER', 'SAINT PETER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PETERS', 'SAINT PETERS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PETERSBURG', 'SAINT PETERSBURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST PIERRE', 'SAINT PIERRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST REGIS', 'SAINT REGIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST REGIS FALLS', 'SAINT REGIS FALLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST REGIS MOHAWK', 'SAINT REGIS MOHAWK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST REGIS PARK', 'SAINT REGIS PARK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ROBERT', 'SAINT ROBERT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ROSA', 'SAINT ROSA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST ROSE', 'SAINT ROSE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST SIMONS', 'SAINT SIMONS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST STEPHEN', 'SAINT STEPHEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST STEPHENS', 'SAINT STEPHENS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST STEPHENS CHURCH', 'SAINT STEPHENS CHURCH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST THOMAS', 'SAINT THOMAS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST VINCENT', 'SAINT VINCENT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST VINCENT COLLEGE', 'SAINT VINCENT COLLEGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST WENDEL', 'SAINT WENDEL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'ST XAVIER', 'SAINT XAVIER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT AGATHA', 'SAINT AGATHA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ALBANS', 'SAINT ALBANS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ANDREWS', 'SAINT ANDREWS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ANN', 'SAINT ANN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ANN HIGHLANDS', 'SAINT ANN HIGHLANDS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ANNA', 'SAINT ANNA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ANNE', 'SAINT ANNE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ANSGAR', 'SAINT ANSGAR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ANTHONY', 'SAINT ANTHONY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ARMAND', 'SAINT ARMAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT AUBERT', 'SAINT AUBERT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT AUGUSTA', 'SAINT AUGUSTA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT AUGUSTINE', 'SAINT AUGUSTINE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT AUGUSTINE BEACH', 'SAINT AUGUSTINE BEACH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT AUGUSTINE SHORES', 'SAINT AUGUSTINE SHORES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT AUGUSTINE SOUTH', 'SAINT AUGUSTINE SOUTH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT BENEDICT', 'SAINT BENEDICT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT BERNARD', 'SAINT BERNARD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT BERNICE', 'SAINT BERNICE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT BONAVENTURE', 'SAINT BONAVENTURE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT BONIFACIUS', 'SAINT BONIFACIUS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT BRIDGET', 'SAINT BRIDGET', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CHARLES', 'SAINT CHARLES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CHARLES MESA', 'SAINT CHARLES MESA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CLAIR', 'SAINT CLAIR', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CLAIR SHORES', 'SAINT CLAIR SHORES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CLAIRSVILLE', 'SAINT CLAIRSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CLEMENT', 'SAINT CLEMENT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CLERE', 'SAINT CLERE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CLOUD', 'SAINT CLOUD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CROIX', 'SAINT CROIX', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT CROIX FALLS', 'SAINT CROIX FALLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT DAVID', 'SAINT DAVID', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT DONATUS', 'SAINT DONATUS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT EDWARD', 'SAINT EDWARD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ELIZABETH', 'SAINT ELIZABETH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ELMO', 'SAINT ELMO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT FERDINAND', 'SAINT FERDINAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT FLORIAN', 'SAINT FLORIAN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT FRANCIS', 'SAINT FRANCIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT FRANCISVILLE', 'SAINT FRANCISVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT FRANCOIS', 'SAINT FRANCOIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT GABRIEL', 'SAINT GABRIEL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT GEORGE', 'SAINT GEORGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT GEORGE ISLAND', 'SAINT GEORGE ISLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT GERMAIN', 'SAINT GERMAIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT HEDWIG', 'SAINT HEDWIG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT HELEN', 'SAINT HELEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT HELENA', 'SAINT HELENA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT HELENA ISLAND', 'SAINT HELENA ISLAND', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT HELENS', 'SAINT HELENS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT HENRY', 'SAINT HENRY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT HILAIRE', 'SAINT HILAIRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT IGNACE', 'SAINT IGNACE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT IGNATIUS', 'SAINT IGNATIUS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JACOB', 'SAINT JACOB', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JAMES', 'SAINT JAMES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JAMES CITY', 'SAINT JAMES CITY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JO', 'SAINT JO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOE', 'SAINT JOE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOHN', 'SAINT JOHN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOHNS', 'SAINT JOHNS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOHNS-FREEMONT', 'SAINT JOHNS-FREEMONT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOHNS FREEMONT', 'SAINT JOHNS-FREEMONT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOHNSBURY', 'SAINT JOHNSBURY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOHNSVILLE', 'SAINT JOHNSVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JOSEPH', 'SAINT JOSEPH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT JUST', 'SAINT JUST', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LAWRENCE', 'SAINT LAWRENCE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LEO', 'SAINT LEO', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LEON', 'SAINT LEON', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LEONARD', 'SAINT LEONARD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LIBORY', 'SAINT LIBORY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LOUIS', 'SAINT LOUIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LOUIS PARK', 'SAINT LOUIS PARK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LOUISVILLE', 'SAINT LOUISVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LUCAS', 'SAINT LUCAS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT LUCIE VILLAGE', 'SAINT LUCIE VILLAGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARIE', 'SAINT MARIE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARIES', 'SAINT MARIES', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARKS', 'SAINT MARKS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARTIN', 'SAINT MARTIN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARTINS', 'SAINT MARTINS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARTINVILLE', 'SAINT MARTINVILLE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARY', 'SAINT MARY', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARY OF THE WOODS', 'SAINT MARY OF THE WOODS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARY''S', 'SAINT MARY''S', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARYS', 'SAINT MARYS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MARYS POINT', 'SAINT MARYS POINT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MATHIAS', 'SAINT MATHIAS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MATTHEWS', 'SAINT MATTHEWS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MAURICE', 'SAINT MAURICE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MEINRAD', 'SAINT MEINRAD', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MICHAEL', 'SAINT MICHAEL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT MICHAELS', 'SAINT MICHAELS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT NAZIANZ', 'SAINT NAZIANZ', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT OLAF', 'SAINT OLAF', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ONGE', 'SAINT ONGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PARIS', 'SAINT PARIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PAUL', 'SAINT PAUL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PAUL PARK', 'SAINT PAUL PARK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PAULS', 'SAINT PAULS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PETE BEACH', 'SAINT PETE BEACH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PETER', 'SAINT PETER', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PETERS', 'SAINT PETERS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PETERSBURG', 'SAINT PETERSBURG', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT PIERRE', 'SAINT PIERRE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT REGIS', 'SAINT REGIS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT REGIS FALLS', 'SAINT REGIS FALLS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT REGIS MOHAWK', 'SAINT REGIS MOHAWK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT REGIS PARK', 'SAINT REGIS PARK', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ROBERT', 'SAINT ROBERT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ROSA', 'SAINT ROSA', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT ROSE', 'SAINT ROSE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT SIMONS', 'SAINT SIMONS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT STEPHEN', 'SAINT STEPHEN', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT STEPHENS', 'SAINT STEPHENS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT STEPHENS CHURCH', 'SAINT STEPHENS CHURCH', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT THOMAS', 'SAINT THOMAS', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT VINCENT', 'SAINT VINCENT', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT VINCENT COLLEGE', 'SAINT VINCENT COLLEGE', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT WENDEL', 'SAINT WENDEL', 10);
INSERT INTO us_gaz (seq, word, stdword, token) VALUES (1, 'SAINT XAVIER', 'SAINT XAVIER', 10);

-- needed set default back to custom so new user entries won't be purged
ALTER TABLE us_gaz ALTER COLUMN is_custom SET DEFAULT true;
