#                                                         -*- Perl -*-
# Copyright (c) 2001  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
#  (WAVE) ᤿ե륯饹
#
package FreePWING::Sound;

require 5.005;
require Exporter;
use English;
use FileHandle;
use FreePWING::Tag;
use strict;
use integer;

use vars qw(@ISA
	    @EXPORT
	    @EXPORT_OK
	    $block_length
	    $tag_prefix);

@ISA = qw(Exporter);

#
# ֥åĹ (Хȿ)
#
$block_length = 2048;

#
# :
#	new()
# ᥽åɤζʬ:
# 	public 饹᥽åɡ
# :
# 	֥Ȥ롣
# :
# 	֥ȤؤΥե󥹤֤
#
sub new {
    my $type = shift;
    my $new = {
	# ХʥեΥϥɥ
	'handle' => FileHandle->new(),

	# Хʥե̾
	'file_name' => '',

	# 񤭹ȥ
	'entry_count' => 0,

	# ХʥեΥեå (ޤǤ˽񤭹Хȿ)
	'position' => 0,

	# 
	'tag' => FreePWING::Tag->new(),

	# λ (satomii)
	'end_tag_prefix' => 'sound-end',

	# ե (satomii)
	'fmt_file_name' => '',
	'fmt_handle' => FileHandle->new(),

	# 顼å
	'error_message' => '',
    };
    return bless($new, $type);
}

#
# :
#	open(file_name, [tag_file_name, [fmt_file_name]])
#           file_name
#		ƥȥե̾
#           tag_file_name
#		ե̾
#           fmt_file_name
#		ե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	񤭹ѤΥƥȥե򳫤
# :
#	 1 ֤Ԥ 0 ֤
#
sub open {
    my $self = shift;
    my ($file_name, $tag_file_name, $fmt_file_name) = @ARG;

    #
    # ե򳫤
    #
    $self->{'file_name'} = $file_name;
    if (!$self->{'handle'}->open($self->{'file_name'}, 'w')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    binmode($self->{'handle'});

    #
    # ե򳫤
    #
    if (defined($tag_file_name)
	&& !$self->{'tag'}->open($tag_file_name)) {
	$self->{'error_message'} = $self->{'tag'}->error_message();
	$self->close_internal();
        return 0;
    }

    #
    # ե򳫤(satomii)
    #
    if (defined($fmt_file_name)) {
	$self->{'fmt_file_name'} = $fmt_file_name;
	if (!$self->{'fmt_handle'}->open($fmt_file_name, 'w')) {
	    $self->{'error_message'} =
		"failed to open the file, $ERRNO: $fmt_file_name";
	    $self->close_internal();
	    return 0;
	}
    }

    return 1;
}

#
# :
#	close()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	֥ȤƤƥȥե뷲Ĥ롣
#	ƥȥե򳫤Ƥʤϡ⤷ʤ
# :
#	 1 ֤Ԥ 0 ֤
#
sub close {
    my $self = shift;

    if (!$self->{'handle'}->fileno()) {
	return 1;
    }

    #
    # Ⱦüʥ֥åθ "\0" 롣
    #
    my $pad_length = $block_length - $self->{'handle'}->tell() % $block_length;
    if ($pad_length < $block_length
	&& !$self->{'handle'}->print("\0" x $pad_length)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	return 0;
    }
	
    #
    # եĤ롣
    #
    $self->close_internal();

    return 1;
}

#
# :
#	close_internal()
# ᥽åɤζʬ:
# 	private 󥹥󥹥᥽åɡ
# :
#       close() ѥ᥽åɡ
#
sub close_internal {
    my $self = shift;

    if ($self->{'handle'}->fileno()) {
	$self->{'handle'}->close();
    }
    $self->{'tag'}->close_internal();

    #
    # ե뤬ƤĤ롣(satomii)
    #
    if ($self->{'fmt_handle'}->fileno()) {
	$self->{'fmt_handle'}->close();
    }
}

#
# :
#	add_data(tag, file_name)
#	    tag
#		̾
#	    file_name
#		ɲäХʥե̾
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿 WAVE եƤ򡢥ǡȤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_data {
    my $self = shift;
    my ($tag, $file_name) = @ARG;

    #
    # Ͽ롣
    #
    if (!$self->{'tag'}->add_entry('sound:' . $tag, $self->{'position'})) {
	$self->{'error_message'} = $self->{'tag'}->error_message();
	$self->close_internal();
	return 0;
    }

    #
    # ꤵ줿ե򳫤
    #
    my $handle = FileHandle->new();
    if (!$handle->open($file_name, 'r')) {
	$self->{'error_message'} =
	    "failed to open the file, $ERRNO: " . $file_name;
	$self->close_internal();
	return 0;
    }
    binmode($handle);

    #
    # ꤵ줿եηĴ٤ work/sndfmt ˵Ͽ롣(satomii)
    #
    my ($data, $data_length);

    $data_length = $handle->read($data, 8);
    if ($data_length != 8) {
	$self->{'error_message'} = (!defined($data_length)) ?
	    "failed to read the file, $ERRNO: $file_name" :
	    "unknown sound format: $file_name";
	$self->close_internal();
	return 0;
    }

    if (substr($data, 0, 4) eq 'RIFF') {
	#
	# WAVE ե
	#
	$data_length = $handle->read($data, 4);
	if ($data_length != 4) {
	    $self->{'error_message'} = (!defined($data_length)) ?
		"failed to read the file, $ERRNO: $file_name" :
		"invalid RIFF data: $file_name";
	    $self->close_internal();
	    return 0;
	} elsif ($data ne 'WAVE') {
	    $self->{'error_message'} =
		"unknown RIFF type, $data: $file_name";
	    $self->close_internal();
	    return 0;
	}

	if ($self->{'fmt_handle'}->fileno()) {
	    my $header_position = $handle->tell();
	    my ($chunk_code, $chunk_length);

	    #
	    # fmt 󥯤õ
	    #
	    while (1) {
		$data_length = $handle->read($data, 8);
		if ($data_length != 8) {
		    $self->{'error_message'} = do {
			if (!defined($data_length)) {
			    "failed to read the file, $ERRNO: $file_name";
			} elsif ($data_length == 0) {
			    "unexpected end of file: $file_name";
			} else {
			    "invalid WAVE data: $file_name";
			}
		    };
		    $self->close_internal();
		    return 0;
		}

		$chunk_code = substr($data, 0, 4);
		$chunk_length = unpack('L', substr($data, 4));

		$data_length = $handle->read($data, $chunk_length);
		if ($data_length != $chunk_length) {
		    $self->{'error_message'} = (!defined($data_length)) ?
			"failed to read the file, $ERRNO: $file_name" :
			"failed to read the $chunk_code chunk: $file_name";
		    $self->close_internal();
		    return 0;
		}

		if ($chunk_code ne 'fmt ') {
		    next;
		} elsif ($chunk_length < 16) {
		    $self->{'error_message'} =
			"invalid fmt chunk: $file_name";
		    $self->close_internal();
		    return 0;
		}

		#
		# ͥץ󥰼ȿӥåĹ롣
		#
		my @fmt = unpack('S2L2S2', $data);
		if (!$self->{'fmt_handle'}->printf(
			 "%s\t01\t%d0%d%d\n",
			 $tag,
			 ($fmt[1] == 2) ? 1 : 0,
			 ($fmt[5] == 16) ? 0 : 1,
			 ($fmt[2] == 441000) ? 0 :
			 ($fmt[2] == 220500) ? 1 : 2)) {
		    $self->{'error_message'} =
			"failed to write the file, $ERRNO: "
			. $self->{'fmt_file_name'};
		    $self->close_internal();
		    return 0;
		}
		last;
	    }

	    #
	    # ɤ߽Ф֤ǽΥ֥󥯤Ƭ᤹
	    #
	    if (!$handle->seek($header_position, 0)) {
		$self->{'error_message'} =
		    "failed to seek the file, $ERRNO: $file_name";
		$self->close_internal();
		return 0;
	    }
	}

    } elsif ($data eq "MThd\x00\x00\x00\x06") {
	#
	# MIDI ե (SMF)
	#
	if ($self->{'fmt_handle'}->fileno()) {
	    if (!$self->{'fmt_handle'}->print("$tag\t02\t0000\n")) {
		$self->{'error_message'} =
		    "failed to write the file, $ERRNO: "
		    . $self->{'fmt_file_name'};
		$self->close_internal();
		return 0;
	    }
	}

	#
	# ɤ߽Ф֤Ƭ᤹
	# ޤϺǽΥȥå󥯤Ƭˤ٤? MIDI бեȤ
	# ʤƥȤǤJIS X 4081 λͽ򤪻Ŭ˽
	# 
	#
	if (!$handle->seek(0, 0)) {
	    $self->{'error_message'} =
		"failed to seek the file, $ERRNO: $file_name";
	    $self->close_internal();
	    return 0;
	}

    } else {
	$self->{'error_message'} = "unknown sound format: $file_name";
	$self->close_internal();
	return 0;
    }

    #
    # ǡɤ߹ǥХʥե˽񤭹ࡣ
    #
    my $start_position = $self->{'position'};

    for (;;) {
	$data_length = $handle->read($data, $block_length);
	if (!defined($data_length)) {
	    $self->{'error_message'} =
		"failed to read the file, $ERRNO: $file_name";
	    $self->close_internal();
	    return 0;
	} elsif ($data_length == 0) {
	    last;
	}
	if (!$self->{'handle'}->print($data)) {
	    $self->{'error_message'} =
		"failed to write the file, $ERRNO: " . $self->{'file_name'};
	    $self->close_internal();
	    return 0;
	}
	$self->{'position'} += $data_length;
    }

    #
    # ꤵ줿եĤ롣
    #
    $handle->close();
    $self->{'entry_count'}++;

    #
    # λϿ롣
    #
    if (defined($self->{'end_tag_prefix'})) {
	my ($end_tag) = $self->{'end_tag_prefix'} . ':' . $tag;
	my ($end_position) = $self->{'position'} - 1;
	if ($end_position < $start_position) {
	    $end_position = $start_position;
	}

	if (!$self->{'tag'}->add_entry($end_tag, $end_position)) {
	    $self->{'error_message'} = $self->{'tag'}->error_message();
	    $self->close_internal();
	    return 0;
	}
    }

    return 1;
}

#
# :
#	add_binary(tag, binary)
#	    tag
#		̾
#	    binary
#		ɲäХʥ
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
# 	Ϳ줿ХʥƤ򡢥ǡȤɲä롣
# :
#	 1 ֤Ԥ 0 ֤
#
sub add_binary {
    my $self = shift;
    my ($tag, $binary) = @ARG;
    my $pos = 0;

    #
    # Ͽ롣
    #
    if (!$self->{'tag'}->add_entry('sound:' . $tag, $self->{'position'})) {
	$self->{'error_message'} = $self->{'tag'}->error_message();
	$self->close_internal();
	return 0;
    }

    #
    # ꤵ줿եηĴ٤ work/sndfmt ˵Ͽ롣(satomii)
    #
    my ($data, $data_length);

    $data = substr ($binary, 0, 8);
    if (length($data) != 8) {
	$self->{'error_message'} = "unknown sound format";
	$self->close_internal();
	return 0;
    }

    if (substr($data, 0, 4) eq 'RIFF') {
	#
	# WAVE ե
	#
	$data = substr($binary, 8, 4);
	$pos = 12;
	if (length($data) != 4) {
	    $self->{'error_message'} = "invalid RIFF data";
	    $self->close_internal();
	    return 0;
	} elsif ($data ne 'WAVE') {
	    $self->{'error_message'} =
		"unknown RIFF type, $data";
	    $self->close_internal();
	    return 0;
	}

	if ($self->{'fmt_handle'}->fileno()) {
	    my $header_position = $pos;
	    my ($chunk_code, $chunk_length);

	    #
	    # fmt 󥯤õ
	    #
	    while (1) {
		$data = substr($binary, $pos, 8);
		$data_length = length($data);
		$pos += 8;
		if ($data_length != 8) {
		    $self->{'error_message'} = do {
			if ($data_length == 0) {
			    "unexpected end of data";
			} else {
			    "invalid WAVE data";
			}
		    };
		    $self->close_internal();
		    return 0;
		}

		$chunk_code = substr($data, 0, 4);
		$chunk_length = unpack('L', substr($data, 4));

		$data = substr($binary, $pos, $chunk_length);
		$pos += $chunk_length;
		if (length($data) != $chunk_length) {
		    $self->{'error_message'} = "failed to read the $chunk_code chunk";
		    $self->close_internal();
		    return 0;
		}

		if ($chunk_code ne 'fmt ') {
		    next;
		} elsif ($chunk_length < 16) {
		    $self->{'error_message'} =
			"invalid fmt chunk";
		    $self->close_internal();
		    return 0;
		}

		#
		# ͥץ󥰼ȿӥåĹ롣
		#
		my @fmt = unpack('S2L2S2', $data);
		if (!$self->{'fmt_handle'}->printf(
			 "%s\t01\t%d0%d%d\n",
			 $tag,
			 ($fmt[1] == 2) ? 1 : 0,
			 ($fmt[5] == 16) ? 0 : 1,
			 ($fmt[2] == 441000) ? 0 :
			 ($fmt[2] == 220500) ? 1 : 2)) {
		    $self->{'error_message'} =
			"failed to write the file, $ERRNO: "
			. $self->{'fmt_file_name'};
		    $self->close_internal();
		    return 0;
		}
		last;
	    }

	    #
	    # ɤ߽Ф֤ǽΥ֥󥯤Ƭ᤹
	    #
	    $pos = $header_position;
	}

    } elsif ($data eq "MThd\x00\x00\x00\x06") {
	#
	# MIDI ե (SMF)
	#
	if ($self->{'fmt_handle'}->fileno()) {
	    if (!$self->{'fmt_handle'}->print("$tag\t02\t0000\n")) {
		$self->{'error_message'} =
		    "failed to write the file, $ERRNO: "
		    . $self->{'fmt_file_name'};
		$self->close_internal();
		return 0;
	    }
	}

	#
	# ɤ߽Ф֤Ƭ᤹
	# ޤϺǽΥȥå󥯤Ƭˤ٤? MIDI бեȤ
	# ʤƥȤǤJIS X 4081 λͽ򤪻Ŭ˽
	# 
	#
	$pos = 0;

    } else {
	$self->{'error_message'} = "unknown sound format";
	$self->close_internal();
	return 0;
    }

    #
    # ǡɤ߹ǥХʥե˽񤭹ࡣ
    #
    my $start_position = $self->{'position'};

    $data = substr($binary, $pos);
    if (!$self->{'handle'}->print($data)) {
	$self->{'error_message'} =
	    "failed to write the file, $ERRNO: " . $self->{'file_name'};
	$self->close_internal();
	return 0;
    }
    $self->{'position'} += length($data);

    #
    #
    #
    $self->{'entry_count'}++;

    #
    # λϿ롣
    #
    if (defined($self->{'end_tag_prefix'})) {
	my ($end_tag) = $self->{'end_tag_prefix'} . ':' . $tag;
	my ($end_position) = $self->{'position'} - 1;
	if ($end_position < $start_position) {
	    $end_position = $start_position;
	}

	if (!$self->{'tag'}->add_entry($end_tag, $end_position)) {
	    $self->{'error_message'} = $self->{'tag'}->error_message();
	    $self->close_internal();
	    return 0;
	}
    }

    return 1;
}

######################################################################
# <󥹥ѿ֤ͤ᥽åɷ>
#
# :
#	󥹥ѿ̾()
# ᥽åɤζʬ:
# 	public 󥹥󥹥᥽åɡ
# :
#	󥹥ѿ֤ͤ
#
sub file_name {
    my $self = shift;
    return $self->{'file_name'};
}

sub tag_file_name {
    my $self = shift;
    return $self->{'tag'}->file_name();
}

sub entry_count {
    my $self = shift;
    return $self->{'entry_count'};
}

sub error_message {
    my $self = shift;
    return $self->{'error_message'};
}

1;
