# This is a CamiTK python action
import camitk

def init(self:camitk.Action):
    self.mesh = None
    camitk.info("CamiTK version: " + camitk.__version__)
    camitk.info("Opened components: " + str(len(camitk.Application.getTopLevelComponents())))
    camitk.Application.open(camitk.Core.getTestDataDir() + "/brain.mha")
    for c in camitk.Application.getTopLevelComponents():
        print(c.getName()) # print will print to CamiTK console without timestamp, level and location in code

def process(self:camitk.Action):
    # for testing purpose as during test setInputComponents is called which does not trigger targetDefined(..)
    targetDefined(self)

    # get the current target
    image = self.getTargets()[-1]
    
    # get current threshold from the GUI and set the threshold property of the threshold action
    currentThreshold = self.getParameterValue("Threshold")
    self.thresholdAction.setParameterValue("Low Threshold", currentThreshold)
    
    #-- 1. compute the threshold image (binary image)
    self.thresholdImage = camitk.Application.applyAction("Threshold (VTK)", image)
    
    #--2. chain this into a pipeline to obtain the reconstruction
    # setup reconstruction action parameter (can also)    
    reconstructionAction = camitk.Application.getAction("Reconstruction")
    reconstructionAction.setParameterValue("Subsample original image?", True)
    self.mesh = camitk.Application.applyAction("Reconstruction", self.thresholdImage)
    # Rename the output and change 
    self.mesh.setName(image.getName() + " mesh")
    self.mesh.setColor([0.66, 0.33, 1.0, 0.3]) # you don't have to add an alpha

    #--3. some cleanup: close the intermediary component (force closing = True, 
    # which closes the component even if it is set as modified)
    if self.getParameterValue("Close Intermediate Images"):
        camitk.Application.close(self.thresholdImage, True)
    
    #--4. show the mesh projection
    meshProjectionAction = camitk.Application.getAction("Mesh Projection")
    # setup default mesh projection parameters
    meshProjectionAction.setParameterValue("ImageComponent List", 0) # assume there the first image component is the correct one
    meshProjectionAction.setParameterValue("Contour Line Width", 3)
    camitk.Application.applyAction("Mesh Projection", self.mesh)
    # Set the visibility boolean once everything is setup 
    # (this is specific to the "Mesh Projection" action logic, which requires this parameter to be set 
    # only after the action is applied)
    meshProjectionAction.setParameterValue("Show Mesh Projection", True)

    self.refreshApplication()
    return True

def targetDefined(self:camitk.Action):
    image = self.getTargets()[-1]
    
    self.thresholdAction = camitk.Application.getAction("Threshold (VTK)")
    # uncomment to check that the threshold action is loaded and available
    # assert self.thresholdAction is not None, f"Cannot find the 'Threshold (VTK)' action. Please check your configuration"
    
    # let the threshold action compute the low threshold value (the action computes (max-min)/2)
    # from the voxels values and use it to update the GUI
    self.thresholdAction.setInputComponent(image)
    adjustedThreshold = self.thresholdAction.getParameterValue("Low Threshold")
    self.setParameterValue("Threshold", adjustedThreshold)
