/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_jv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_002 = "Afrika";
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_DE = "J\u00e9rman";
        final String metaValue_FR = "Prancis";
        final String metaValue_HR = "Kroasia";
        final String metaValue_JP = "Jepang";
        final String metaValue_LU = "Luksemburg";
        final String metaValue_LA = "Laos";
        final String metaValue_LV = "Latvia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NR = "Nauru";
        final String metaValue_NL = "Walanda";
        final String metaValue_RU = "Rusia";
        final String metaValue_WS = "Samoa";
        final String metaValue_SO = "Somalia";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_hy = "Armenia";
        final String metaValue_ccp = "Chakma";
        final String metaValue_ka = "Georgia";
        final String metaValue_el = "Yunani";
        final String metaValue_he = "Ibrani";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_my = "Myanmar";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Odia";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sunda";
        final String metaValue_syr = "Siriak";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thailand";
        final String metaValue_vai = "Vai";
        final Object[][] data = new Object[][] {
            { "001", "Donya" },
            { "002", metaValue_002 },
            { "003", "Am\u00e9rika Lor" },
            { "005", "Am\u00e9rika Kidul" },
            { "009", "Os\u00e9ania" },
            { "011", "Afrika Kulon" },
            { "013", "Am\u00e9rika Tengah" },
            { "014", "Afrika W\u00e9tan" },
            { "015", "Afrika Lor" },
            { "017", "Afrika Sisih Tengah" },
            { "018", "Afrika Sisih Kidul" },
            { "019", "Am\u00e9rika" },
            { "021", "Am\u00e9rika Sisih Lor" },
            { "029", "Karibia" },
            { "030", "Asia W\u00e9tan" },
            { "034", "Asia Kidul" },
            { "035", "Asia Kidul-w\u00e9tan" },
            { "039", "\u00c9ropah Kidul" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Daerah Mikronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Tengah" },
            { "145", "Asia Kulon" },
            { "150", "\u00c9ropah" },
            { "151", "\u00c9ropah W\u00e9tan" },
            { "154", "\u00c9ropah Lor" },
            { "155", "\u00c9ropah Kulon" },
            { "202", "Afrika Kidule Sahara" },
            { "419", "Am\u00e9rika Latin" },
            { "AC", "Pulo Ascension" },
            { "AD", "Andora" },
            { "AE", "Uni \u00c9mirat Arab" },
            { "AF", "Afganistan" },
            { "AG", "Antigua lan Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albani" },
            { "AM", "Arm\u00e9nia" },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "AR", "Arg\u00e8ntina" },
            { "AS", "Samoa Amerika" },
            { "AT", "Ostenrik" },
            { "AU", "Ostrali" },
            { "AW", "Aruba" },
            { "AX", "Kapuloan Alan" },
            { "AZ", metaValue_AZ },
            { "BA", "Bosnia lan H\u00e8rs\u00e9govina" },
            { "BB", "Barbadhos" },
            { "BD", "Banggalad\u00e9sa" },
            { "BE", "B\u00e8lgi" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgari" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "B\u00e9nin" },
            { "BL", "Saint Barth\u00e9l\u00e9mi" },
            { "BM", "Bermuda" },
            { "BN", "Brun\u00e9i" },
            { "BO", "Bolivia" },
            { "BQ", "Karibia Walanda" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Pulo Bov\u00e8t" },
            { "BW", "Botswana" },
            { "BY", "B\u00e9larus" },
            { "BZ", "B\u00e9lis\u00e9" },
            { "CA", "Kanada" },
            { "CC", "Kapuloan Cocos (Keeling)" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "R\u00e9publik Afrika Tengah" },
            { "CG", "Kongo - Brassaville" },
            { "CH", "Switserlan" },
            { "CI", "Pasisir Gadhing" },
            { "CK", "Kapuloan Cook" },
            { "CL", "Cil\u00e9" },
            { "CM", "Kamerun" },
            { "CN", "Tyongkok" },
            { "CO", "Kolombia" },
            { "CP", "Pulo Clipperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Pongol Verd\u00e9" },
            { "CW", "Kurasao" },
            { "CX", "Pulo Natal" },
            { "CY", "Siprus" },
            { "CZ", "C\u00e9ko" },
            { "DE", metaValue_DE },
            { "DG", "Diego Garcia" },
            { "DJ", "Jibuti" },
            { "DK", "Dh\u00e8nemarken" },
            { "DM", "Dominika" },
            { "DO", "R\u00e9publik Dominika" },
            { "DZ", "Aljasair" },
            { "EA", "S\u00e9uta lan Melila" },
            { "EC", "\u00c9kuadhor" },
            { "EE", "\u00c9stonia" },
            { "EG", "Mesir" },
            { "EH", "Sahara Kulon" },
            { "ER", "\u00c9ritr\u00e9a" },
            { "ES", "Sepanyol" },
            { "ET", "\u00c9tiopia" },
            { "EU", "Uni \u00c9ropah" },
            { "EZ", "Zona \u00c9uro" },
            { "FI", "Finlan" },
            { "FJ", "Fiji" },
            { "FK", "Kapuloan Falkland" },
            { "FM", "F\u00e9derasi Mikron\u00e9sia" },
            { "FO", "Kapuloan Faro" },
            { "FR", metaValue_FR },
            { "GA", "Gabon" },
            { "GB", "Karajan Manunggal" },
            { "GD", "Gr\u00e9nada" },
            { "GE", "G\u00e9orgia" },
            { "GF", "Guyana Prancis" },
            { "GG", "Guernsei" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guad\u00e9lup" },
            { "GQ", "Guin\u00e9a Katulistiwa" },
            { "GR", "Grikenlan" },
            { "GS", "Georgia Kidul lan Kapuloan Sandwich Kidul" },
            { "GT", "Guat\u00e9mala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Laladan Administratif Astamiwa Hong Kong" },
            { "HM", "Kapuloan Heard lan McDonald" },
            { "HN", "Honduras" },
            { "HR", metaValue_HR },
            { "HT", "Haiti" },
            { "HU", "Honggari" },
            { "IC", "Kapuloan Kanari" },
            { "ID", "Indon\u00e9sia" },
            { "IE", "R\u00e9publik Irlan" },
            { "IL", "Isra\u00e8l" },
            { "IM", "Pulo Man" },
            { "IN", "Indhia" },
            { "IO", "Wilayah Inggris nang Segoro Hindia" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "\u00c8slan" },
            { "IT", "Itali" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Yordania" },
            { "JP", metaValue_JP },
            { "KE", "K\u00e9nya" },
            { "KG", "Kirgistan" },
            { "KH", "Kamboja" },
            { "KI", "Kiribati" },
            { "KM", "Komoro" },
            { "KN", "Saint Kits lan N\u00e8vis" },
            { "KP", "Korea Lor" },
            { "KR", "Kor\u00e9a Kidul" },
            { "KW", "Kuwait" },
            { "KY", "Kapuloan K\u00e9man" },
            { "KZ", "Kasakstan" },
            { "LA", metaValue_LA },
            { "LB", "Libanon" },
            { "LC", "Santa Lusia" },
            { "LI", "Liktenst\u00e9n" },
            { "LK", "Sri Lanka" },
            { "LR", "Lib\u00e8ria" },
            { "LS", "L\u00e9sotho" },
            { "LT", "Litowen" },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "Libya" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Monten\u00e9gro" },
            { "MF", "Santa Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Kapuloan Marshall" },
            { "MK", "R\u00e9publik Mak\u00e9donia Lor" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", metaValue_MN },
            { "MO", "Laladan Administratif Astamiwa Makau" },
            { "MP", "Kapuloan Mariana Lor" },
            { "MQ", "Martinik" },
            { "MR", "Mauritania" },
            { "MS", "Mons\u00e9rat" },
            { "MT", metaValue_MT },
            { "MU", "Mauritius" },
            { "MV", "Malad\u00e9wa" },
            { "MW", "Malawi" },
            { "MX", "M\u00e8ksiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Kal\u00e9donia Anyar" },
            { "NE", "Nig\u00e9r" },
            { "NF", "Pulo Norfolk" },
            { "NG", "Nig\u00e9ria" },
            { "NI", "Nikaragua" },
            { "NL", metaValue_NL },
            { "NO", "Nurw\u00e8gen" },
            { "NP", "N\u00e9pal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Selandia Anyar" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinesia Prancis" },
            { "PG", "Papua Nugini" },
            { "PH", "Pilipina" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "Saint Pi\u00e8r lan Miku\u00e9lon" },
            { "PN", "Kapuloan Pitcairn" },
            { "PR", "Pu\u00e8rto Riko" },
            { "PS", "Tlatah Pal\u00e8stina" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Oseania Paling Njaba" },
            { "RE", "R\u00e9union" },
            { "RO", "Rum\u00e9ni" },
            { "RS", "S\u00e8rbi" },
            { "RU", metaValue_RU },
            { "RW", "Rwanda" },
            { "SA", "Arab Saudi" },
            { "SB", "Kapuloan Suleman" },
            { "SC", "S\u00e9s\u00e8l" },
            { "SD", "Sudan" },
            { "SE", "Sw\u00e8dhen" },
            { "SG", "Singapura" },
            { "SH", "Saint H\u00e9l\u00e9na" },
            { "SI", "Slov\u00e9nia" },
            { "SJ", "Svalbard lan Jan Mayen" },
            { "SK", "Slowak" },
            { "SL", "Si\u00e9ra L\u00e9on\u00e9" },
            { "SM", "San Marino" },
            { "SN", "S\u00e9n\u00e9gal" },
            { "SO", metaValue_SO },
            { "SR", "Suriname" },
            { "SS", "Sudan Kidul" },
            { "ST", "Sao Tom\u00e9 lan Princip\u00e9" },
            { "SV", "\u00c8l Salvador" },
            { "SX", "Sint Mart\u00e9n" },
            { "SY", "Suriah" },
            { "SZ", "Swasiland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks lan Kapuloan Kaikos" },
            { "TD", "Chad" },
            { "TF", "Wilayah Prancis nang Kutub Kidul" },
            { "TG", "Togo" },
            { "TH", "Tanah Thai" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Leste" },
            { "TM", "Turkm\u00e9nistan" },
            { "TN", "Tunisia" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "Trinidad lan Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukrania" },
            { "UG", "Uganda" },
            { "UM", "Kapuloan AS Paling Njaba" },
            { "UN", "Pasar\u00e9katan Bangsa-Bangsa" },
            { "US", "Am\u00e9rika Sar\u00e9kat" },
            { "UY", "Uruguay" },
            { "UZ", "Usb\u00e8kistan" },
            { "VA", "Kutha Vatikan" },
            { "VC", "Saint Vinsen lan Gr\u00e9nadin" },
            { "VE", "V\u00e9n\u00e9su\u00e9la" },
            { "VG", "Kapuloan Virgin Britania" },
            { "VI", "Kapuloan Virgin Am\u00e9rika" },
            { "VN", "Vi\u00e8tnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis lan Futuna" },
            { "WS", metaValue_WS },
            { "XA", "Logat Semu" },
            { "XB", "Rong Arah Semu" },
            { "XK", "Kosovo" },
            { "YE", "Yaman" },
            { "YT", "Mayotte" },
            { "ZA", "Afrika Kidul" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Daerah Ora Dikenali" },
            { "ab", "Abkhazian" },
            { "af", metaValue_002 },
            { "ak", "Akan" },
            { "am", "Amharik" },
            { "an", "Aragonese" },
            { "ar", "Arab" },
            { "as", "Assam" },
            { "av", "Avaric" },
            { "ay", "Aymara" },
            { "az", metaValue_AZ },
            { "ba", "Bashkir" },
            { "be", "Belarus" },
            { "bg", "Bulgaria" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengali" },
            { "bo", "Tibet" },
            { "br", "Breton" },
            { "bs", "Bosnia lan Hercegovina" },
            { "ca", "Katala" },
            { "ce", "Chechen" },
            { "ch", "Khamorro" },
            { "co", "Korsika" },
            { "cs", "Ceska" },
            { "cu", "Slavia Gerejani" },
            { "cv", "Khuvash" },
            { "cy", "Welsh" },
            { "da", "Dansk" },
            { "de", metaValue_DE },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Inggris" },
            { "eo", "Esperanto" },
            { "es", "Spanyol" },
            { "et", "Estonia" },
            { "eu", "Basque" },
            { "fa", "Persia" },
            { "ff", "Fulah" },
            { "fi", "Suomi" },
            { "fj", "Fijian" },
            { "fo", "Faroe" },
            { "fr", metaValue_FR },
            { "fy", "Frisia Sisih Kulon" },
            { "ga", "Irlandia" },
            { "gd", "Gaulia" },
            { "gl", "Galisia" },
            { "gn", "Guarani" },
            { "gu", "Gujarat" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "India" },
            { "hr", metaValue_HR },
            { "ht", "Kreol Haiti" },
            { "hu", "Hungaria" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesia" },
            { "ig", "Iqbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Islandia" },
            { "it", "Italia" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_JP },
            { "jv", "Jawa" },
            { "ka", metaValue_ka },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdis" },
            { "kv", "Komi" },
            { "kw", "Kernowek" },
            { "ky", "Kirgis" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", metaValue_LA },
            { "lt", "Lithuania" },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "mg", "Malagasi" },
            { "mh", "Marshallese" },
            { "mi", "Maori" },
            { "mk", "Makedonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "Marathi" },
            { "ms", "Melayu" },
            { "mt", metaValue_MT },
            { "my", metaValue_my },
            { "na", metaValue_NR },
            { "nb", "Bokm\u00e5l Norwegia" },
            { "nd", "Ndebele Lor" },
            { "ne", "Nepal" },
            { "ng", "Ndonga" },
            { "nl", metaValue_NL },
            { "nn", "Nynorsk Norwegia" },
            { "no", "Norwegia" },
            { "nr", "Ndebele Kidul" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Ossitan" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetia" },
            { "pa", "Punjab" },
            { "pl", "Polandia" },
            { "ps", "Pashto" },
            { "pt", "Portugis" },
            { "qu", "Quechua" },
            { "rm", "Roman" },
            { "rn", "Rundi" },
            { "ro", "Rumania" },
            { "ru", metaValue_RU },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskerta" },
            { "sc", "Sardinian" },
            { "sd", "Sindhi" },
            { "se", "Sami Sisih Lor" },
            { "sg", "Sango" },
            { "si", metaValue_si },
            { "sk", "Slowakia" },
            { "sl", "Slovenia" },
            { "sm", metaValue_WS },
            { "sn", "Shona" },
            { "so", metaValue_SO },
            { "sq", "Albania" },
            { "sr", "Serbia" },
            { "ss", "Swati" },
            { "st", "Sotho Sisih Kidul" },
            { "su", metaValue_su },
            { "sv", "Swedia" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "ty", "Tahiti" },
            { "ug", "Uighur" },
            { "uk", "Ukraina" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vietnam" },
            { "vo", "Volapuk" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "zh", "Tyonghwa" },
            { "zu", "Zulu" },
            { "ace", "Achinese" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Altai Sisih Kidul" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arn", "Mapushe" },
            { "arp", "Arapaho" },
            { "ars", "Arab Najdi" },
            { "asa", "Asu" },
            { "ast", "Asturia" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "ban", "Bali" },
            { "bas", "Basaa" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bho", "Bhojpuri" },
            { "bin", "Bini" },
            { "bla", "Siksik\u00e1" },
            { "brx", "Bodo" },
            { "bug", "Bugis" },
            { "byn", "Blin" },
            { "cay", "Kayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", "Cherokee" },
            { "chy", "Cheyenne" },
            { "ckb", "Kurdi Tengah" },
            { "clc", "Chilcotin" },
            { "crg", "Michif" },
            { "crj", "Kree Kidul Wetan" },
            { "crk", "Kree Polos" },
            { "crl", "Kree Lor Segara" },
            { "crm", "Moose Cree" },
            { "crr", "Karolina Algonquian" },
            { "csw", "Kree Rawa" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Sorbia Non Standar" },
            { "dua", "Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "eka", "Ekajuk" },
            { "ewo", "Ewondo" },
            { "fil", "Tagalog" },
            { "fon", "Fon" },
            { "frc", "Prancis Cajun" },
            { "frr", "Frisian Lor Segara" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gez", "Gees" },
            { "gil", "Gilbertese" },
            { "gor", "Gorontalo" },
            { "gsw", "Jerman Swiss" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "haw", "Hawaii" },
            { "hax", "Haida Sisih Kidul" },
            { "hil", "Hiligainon" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbia Standar" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Kanada Inuktitut Sisih Kulon" },
            { "ilo", "Iloko" },
            { "inh", "Ingus" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "kab", "Kabyle" },
            { "kac", "Kakhin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kbd", "Kabardian" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "krc", "Karachai-Balkar" },
            { "krl", "Karelian" },
            { "kru", "Kuruk" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Colonia" },
            { "kum", "Kumik" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lez", "Lesghian" },
            { "lil", "Lillooet" },
            { "lkt", "Lakota" },
            { "lmo", "Lombard" },
            { "lou", "Louisiana Creole" },
            { "loz", "Losi" },
            { "lrc", "Luri Sisih Lor" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Miso" },
            { "luy", "Luyia" },
            { "mad", "Madura" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makasar" },
            { "mas", "Masai" },
            { "mdf", "Moksha" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mgh", "Makhuwa-Meeto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Mi'kmak" },
            { "min", "Minangkabau" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Basa Multilingua" },
            { "mus", "Muskogee" },
            { "mwl", "Mirandese" },
            { "myv", "Ersia" },
            { "mzn", "Mazanderani" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Jerman Non Standar" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Sotho Sisih Lor" },
            { "nus", "Nuer" },
            { "nyn", "Nyankole" },
            { "ojb", "Ojibwa Kulon Segara" },
            { "ojc", "Ojibwa Tengah" },
            { "ojs", "Oji-Kree" },
            { "ojw", "Ojibwa Sisih Kulon" },
            { "oka", "Okanagan" },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcm", "Nigeria Pidgin" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamakuoddi" },
            { "prg", "Prusia" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rhg", "Rohingya" },
            { "rof", "Rombo" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "saq", "Samburu" },
            { "sat", "Santali" },
            { "sba", "Ngambai" },
            { "sbp", "Sangu" },
            { "scn", "Sisilia" },
            { "sco", "Skots" },
            { "seh", "Sena" },
            { "ses", "Koyraboro Senni" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "slh", "Lushootseed Sisih Kidul" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "str", "Selat Salish" },
            { "suk", "Sukuma" },
            { "swb", "Komorian" },
            { "syr", metaValue_syr },
            { "tce", "Tutkhone Sisih Kidul" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "ttm", "Tutkhone Sisih Lor" },
            { "tum", "Tumbuka" },
            { "tvl", "Tupalu" },
            { "twq", "Tasawaq" },
            { "tyv", "Tupinian" },
            { "tzm", "Tamazight Atlas Tengah" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Basa Ora Dikenali" },
            { "vai", metaValue_vai },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaitta" },
            { "war", "Warai" },
            { "wuu", "Tyonghwa Wu" },
            { "xal", "Kalmik" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kanton" },
            { "zgh", "Tamazight Moroko Standar" },
            { "zun", "Zuni" },
            { "zxx", "Konten tanpa linguistik" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Arab", "hija\u2019iyah" },
            { "Aran", "Nastalik" },
            { "Armn", metaValue_hy },
            { "Beng", "Bangla" },
            { "Bopo", "Bopomofo" },
            { "Brai", "Braille" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Wanda Manunggal Aborigin Kanada" },
            { "Cher", "Sherokee" },
            { "Cyrl", "Sirilik" },
            { "Deva", "Devanagari" },
            { "Ethi", "Ethiopik" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", "Gujarati" },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han nganggo Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hans", "Prasaja" },
            { "Hant", "Tradhisional" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hrkt", "Silabaris Jepang" },
            { "Jpan", metaValue_JP },
            { "Kana", "Katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", "Lao" },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_MN },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Ol Chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "Hanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinak" },
            { "Thaa", "Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", "Tibetan" },
            { "Vaii", metaValue_vai },
            { "Yiii", "Yi" },
            { "Zmth", "Notasi Matematika" },
            { "Zsye", "Emoji" },
            { "Zsym", "Simbol" },
            { "Zxxx", "Ora Ketulis" },
            { "Zyyy", "Umum" },
            { "Zzzz", "Skrip Ora Dikenali" },
            { "de_AT", "J\u00e9rman Ostenrik" },
            { "de_CH", "J\u00e9rman Switserlan" },
            { "en_AU", "Inggris Ostrali" },
            { "en_CA", "Inggris Kanada" },
            { "en_GB", "Inggris Karajan Manunggal" },
            { "en_US", "Inggris Am\u00e9rika Sar\u00e9kat" },
            { "es_ES", "Spanyol (Eropah)" },
            { "es_MX", "Spanyol (Meksiko)" },
            { "fr_CA", "Prancis Kanada" },
            { "fr_CH", "Prancis Switserlan" },
            { "nl_BE", "Flemis" },
            { "pt_BR", "Portugis Brasil" },
            { "pt_PT", "Portugis Portugal" },
            { "ar_001", "Arab Standar Anyar" },
            { "es_419", "Spanyol (Amerika Latin)" },
            { "key.ca", "Tanggalan" },
            { "key.cf", "Format Mata Uang" },
            { "key.co", "Urutan Pamilahan" },
            { "key.cu", "Mata Uang" },
            { "key.hc", "Siklus Jam (12 vs 24)" },
            { "key.lb", "Gaya Ganti Baris" },
            { "key.ms", "Sistem Pangukuran" },
            { "key.nu", "Angka" },
            { "zh_Hans", "Tyonghwa (Ringkes)" },
            { "zh_Hant", "Tyonghwa (Tradisional)" },
            { "type.ca.roc", "Tanggalan Minguo" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "type.nu.arab", "Digit Hindu-Arab" },
            { "type.nu.armn", "Angka Armenia" },
            { "type.nu.beng", "Digit Bengali" },
            { "type.nu.cakm", "Digit Chakma" },
            { "type.nu.deva", "Digit Devanagari" },
            { "type.nu.ethi", "Angka Etiopia" },
            { "type.nu.geor", "Angka Georgian" },
            { "type.nu.grek", "Angka Yunani" },
            { "type.nu.gujr", "Digit Gujarat" },
            { "type.nu.guru", "Digit Gurmukhi" },
            { "type.nu.hans", "Angka Mandarin Ringkes" },
            { "type.nu.hant", "Angka Mandarin Tradisional" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "type.nu.java", "Digit Jawa" },
            { "type.nu.jpan", "Angka Jepang" },
            { "type.nu.khmr", "Digit Khmer" },
            { "type.nu.knda", "Digit Kannada" },
            { "type.nu.laoo", "Digit Lao" },
            { "type.nu.latn", "Digit Latin" },
            { "type.nu.mlym", "Digit Malayalam" },
            { "type.nu.mtei", "Digit Meetei Mayek" },
            { "type.nu.mymr", "Digit Myanmar" },
            { "type.nu.olck", "Digit Ol Chiki" },
            { "type.nu.orya", "Digit Odia" },
            { "type.nu.taml", "Angka Tamil Tradisional" },
            { "type.nu.telu", "Digit Telugu" },
            { "type.nu.thai", "Digit Thailand" },
            { "type.nu.tibt", "Digit Tibet" },
            { "type.nu.vaii", "Digit Vai" },
            { "type.ca.dangi", "Tanggalan Dangi" },
            { "type.co.ducet", "Urutan Pamilahan Unicode Default" },
            { "type.lb.loose", "Gaya Ganti Baris Longgar" },
            { "type.nu.roman", "Angka Romawi" },
            { "type.ca.coptic", "Tanggalan Koptik" },
            { "type.ca.hebrew", "Tanggalan Ibrani" },
            { "type.co.search", "Panlusuran Tujuan Umum" },
            { "type.lb.normal", "Gaya Ganti Baris Normal" },
            { "type.lb.strict", "Gaya Ganti Baris Strik" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.ca.chinese", "Tanggalan Cina" },
            { "type.ca.islamic", "Tanggalan Islam" },
            { "type.ca.iso8601", "Tanggalan ISO-8601" },
            { "type.ca.persian", "Tanggalan Persia" },
            { "type.cf.account", "Format Mata Uang Akuntansi" },
            { "type.nu.arabext", "Digit Hindu-Arab Diambakake" },
            { "type.nu.armnlow", "Angka Huruf Cilik Armenia" },
            { "type.nu.greklow", "Angka Huruf Cilik Yunani" },
            { "type.nu.hanidec", "Angka Desimal Mandarin" },
            { "type.nu.hansfin", "Angka Finansial Mandarin Ringkes" },
            { "type.nu.hantfin", "Angka Finansial Mandarin Tradisional" },
            { "type.nu.jpanfin", "Angka Finansial Jepang" },
            { "type.nu.tamldec", "Digit Tamil" },
            { "type.ca.buddhist", "Tanggalan Buddha" },
            { "type.ca.ethiopic", "Tanggalan Etiopia" },
            { "type.ca.japanese", "Tanggalan Jepang" },
            { "type.cf.standard", "Format Mata Uang Standar" },
            { "type.co.standard", "Standar Ngurutke Urutan" },
            { "type.ms.uksystem", "Sistem Pangukuran Imperial" },
            { "type.ms.ussystem", "Sistem Pangukuran AS" },
            { "type.nu.fullwide", "Digit Amba Kebak" },
            { "type.nu.romanlow", "Angka Huruf Cilik Romawi" },
            { "type.ca.gregorian", "Tanggalan Gregorian" },
            { "type.ca.islamic-tbla", "Tanggalan Islam (tabel, jaman astronomi)" },
            { "type.ca.islamic-civil", "Tanggalan Islam (tabel, jaman sipil)" },
            { "type.ca.islamic-umalqura", "Tanggalan Islam (Mekah)" },
            { "type.ca.ethiopic-amete-alem", "Tanggalan Etiopia Amete Alem" },
        };
        return data;
    }
}
