/* SPDX-License-Identifier: GPL-2.0-only OR BSD-2-Clause */
/*
 * Copyright (C) 2024 Inochi Amaoto <inochiama@outlook.com>
 *
 */

#ifndef _DT_BINDINGS_PINCTRL_SG2042_H
#define _DT_BINDINGS_PINCTRL_SG2042_H

#define PINMUX(pin, mux) \
	(((pin) & 0xffff) | (((mux) & 0xff) << 16))

#define PIN_LPC_LCLK			0
#define PIN_LPC_LFRAME			1
#define PIN_LPC_LAD0			2
#define PIN_LPC_LAD1			3
#define PIN_LPC_LAD2			4
#define PIN_LPC_LAD3			5
#define PIN_LPC_LDRQ0			6
#define PIN_LPC_LDRQ1			7
#define PIN_LPC_SERIRQ			8
#define PIN_LPC_CLKRUN			9
#define PIN_LPC_LPME			10
#define PIN_LPC_LPCPD			11
#define PIN_LPC_LSMI			12
#define PIN_PCIE0_L0_RESET		13
#define PIN_PCIE0_L1_RESET		14
#define PIN_PCIE0_L0_WAKEUP		15
#define PIN_PCIE0_L1_WAKEUP		16
#define PIN_PCIE0_L0_CLKREQ_IN		17
#define PIN_PCIE0_L1_CLKREQ_IN		18
#define PIN_PCIE1_L0_RESET		19
#define PIN_PCIE1_L1_RESET		20
#define PIN_PCIE1_L0_WAKEUP		21
#define PIN_PCIE1_L1_WAKEUP		22
#define PIN_PCIE1_L0_CLKREQ_IN		23
#define PIN_PCIE1_L1_CLKREQ_IN		24
#define PIN_SPIF0_CLK_SEL1		25
#define PIN_SPIF0_CLK_SEL0		26
#define PIN_SPIF0_WP			27
#define PIN_SPIF0_HOLD			28
#define PIN_SPIF0_SDI			29
#define PIN_SPIF0_CS			30
#define PIN_SPIF0_SCK			31
#define PIN_SPIF0_SDO			32
#define PIN_SPIF1_CLK_SEL1		33
#define PIN_SPIF1_CLK_SEL0		34
#define PIN_SPIF1_WP			35
#define PIN_SPIF1_HOLD			36
#define PIN_SPIF1_SDI			37
#define PIN_SPIF1_CS			38
#define PIN_SPIF1_SCK			39
#define PIN_SPIF1_SDO			40
#define PIN_EMMC_WP			41
#define PIN_EMMC_CD			42
#define PIN_EMMC_RST			43
#define PIN_EMMC_PWR_EN			44
#define PIN_SDIO_CD			45
#define PIN_SDIO_WP			46
#define PIN_SDIO_RST			47
#define PIN_SDIO_PWR_EN			48
#define PIN_RGMII0_TXD0			49
#define PIN_RGMII0_TXD1			50
#define PIN_RGMII0_TXD2			51
#define PIN_RGMII0_TXD3			52
#define PIN_RGMII0_TXCTRL		53
#define PIN_RGMII0_RXD0			54
#define PIN_RGMII0_RXD1			55
#define PIN_RGMII0_RXD2			56
#define PIN_RGMII0_RXD3			57
#define PIN_RGMII0_RXCTRL		58
#define PIN_RGMII0_TXC			59
#define PIN_RGMII0_RXC			60
#define PIN_RGMII0_REFCLKO		61
#define PIN_RGMII0_IRQ			62
#define PIN_RGMII0_MDC			63
#define PIN_RGMII0_MDIO			64
#define PIN_PWM0			65
#define PIN_PWM1			66
#define PIN_PWM2			67
#define PIN_PWM3			68
#define PIN_FAN0			69
#define PIN_FAN1			70
#define PIN_FAN2			71
#define PIN_FAN3			72
#define PIN_IIC0_SDA			73
#define PIN_IIC0_SCL			74
#define PIN_IIC1_SDA			75
#define PIN_IIC1_SCL			76
#define PIN_IIC2_SDA			77
#define PIN_IIC2_SCL			78
#define PIN_IIC3_SDA			79
#define PIN_IIC3_SCL			80
#define PIN_UART0_TX			81
#define PIN_UART0_RX			82
#define PIN_UART0_RTS			83
#define PIN_UART0_CTS			84
#define PIN_UART1_TX			85
#define PIN_UART1_RX			86
#define PIN_UART1_RTS			87
#define PIN_UART1_CTS			88
#define PIN_UART2_TX			89
#define PIN_UART2_RX			90
#define PIN_UART2_RTS			91
#define PIN_UART2_CTS			92
#define PIN_UART3_TX			93
#define PIN_UART3_RX			94
#define PIN_UART3_RTS			95
#define PIN_UART3_CTS			96
#define PIN_SPI0_CS0			97
#define PIN_SPI0_CS1			98
#define PIN_SPI0_SDI			99
#define PIN_SPI0_SDO			100
#define PIN_SPI0_SCK			101
#define PIN_SPI1_CS0			102
#define PIN_SPI1_CS1			103
#define PIN_SPI1_SDI			104
#define PIN_SPI1_SDO			105
#define PIN_SPI1_SCK			106
#define PIN_JTAG0_TDO			107
#define PIN_JTAG0_TCK			108
#define PIN_JTAG0_TDI			109
#define PIN_JTAG0_TMS			110
#define PIN_JTAG0_TRST			111
#define PIN_JTAG0_SRST			112
#define PIN_JTAG1_TDO			113
#define PIN_JTAG1_TCK			114
#define PIN_JTAG1_TDI			115
#define PIN_JTAG1_TMS			116
#define PIN_JTAG1_TRST			117
#define PIN_JTAG1_SRST			118
#define PIN_JTAG2_TDO			119
#define PIN_JTAG2_TCK			120
#define PIN_JTAG2_TDI			121
#define PIN_JTAG2_TMS			122
#define PIN_JTAG2_TRST			123
#define PIN_JTAG2_SRST			124
#define PIN_GPIO0			125
#define PIN_GPIO1			126
#define PIN_GPIO2			127
#define PIN_GPIO3			128
#define PIN_GPIO4			129
#define PIN_GPIO5			130
#define PIN_GPIO6			131
#define PIN_GPIO7			132
#define PIN_GPIO8			133
#define PIN_GPIO9			134
#define PIN_GPIO10			135
#define PIN_GPIO11			136
#define PIN_GPIO12			137
#define PIN_GPIO13			138
#define PIN_GPIO14			139
#define PIN_GPIO15			140
#define PIN_GPIO16			141
#define PIN_GPIO17			142
#define PIN_GPIO18			143
#define PIN_GPIO19			144
#define PIN_GPIO20			145
#define PIN_GPIO21			146
#define PIN_GPIO22			147
#define PIN_GPIO23			148
#define PIN_GPIO24			149
#define PIN_GPIO25			150
#define PIN_GPIO26			151
#define PIN_GPIO27			152
#define PIN_GPIO28			153
#define PIN_GPIO29			154
#define PIN_GPIO30			155
#define PIN_GPIO31			156
#define PIN_MODE_SEL0			157
#define PIN_MODE_SEL1			158
#define PIN_MODE_SEL2			159
#define PIN_BOOT_SEL0			160
#define PIN_BOOT_SEL1			161
#define PIN_BOOT_SEL2			162
#define PIN_BOOT_SEL3			163
#define PIN_BOOT_SEL4			164
#define PIN_BOOT_SEL5			165
#define PIN_BOOT_SEL6			166
#define PIN_BOOT_SEL7			167
#define PIN_MULTI_SCKT			168
#define PIN_SCKT_ID0			169
#define PIN_SCKT_ID1			170
#define PIN_PLL_CLK_IN_MAIN		171
#define PIN_PLL_CLK_IN_DDR_L		172
#define PIN_PLL_CLK_IN_DDR_R		173
#define PIN_XTAL_32K			174
#define PIN_SYS_RST			175
#define PIN_PWR_BUTTON			176
#define PIN_TEST_EN			177
#define PIN_TEST_MODE_MBIST		178
#define PIN_TEST_MODE_SCAN		179
#define PIN_TEST_MODE_BSD		180
#define PIN_BISR_BYP			181

#endif /* _DT_BINDINGS_PINCTRL_SG2042_H */
