/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.context.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.polySymbols.context.PolyContext;
import com.intellij.polySymbols.context.PolyContextChangeListener;
import com.intellij.polySymbols.context.impl.ContextFileConfigInDir;
import com.intellij.polySymbols.context.impl.ContextRulesConfigInDir;
import com.intellij.polySymbols.context.impl.PolyContextDiscoveryKt;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\r2\n\u0010\u0016\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0017\u001a\u00060\nj\u0002`\u0018\u00a2\u0006\u0002\u0010\u0019J(\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\r2\n\u0010\u0016\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0017\u001a\u00060\nj\u0002`\u0018J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\rJ\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u000e\u001a'\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011\u0012\u000e\u0012\f0\u0012\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00110\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/polySymbols/context/impl/PolyContextDiscoveryInfo;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "previousContext", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/polySymbols/PolyContextKind;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "cachedData", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/polySymbols/context/impl/PolyContextDiscoveryInfo$CachedData;", "getProximityFromExtensions", "", "dir", "kind", "name", "Lcom/intellij/polySymbols/PolyContextName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Integer;", "updateContext", "contextFile", "getContextRulesConfigInDir", "Lcom/intellij/polySymbols/context/impl/ContextRulesConfigInDir;", "getContextFileConfigInDir", "Lcom/intellij/polySymbols/context/impl/ContextFileConfigInDir;", "getCachedDataForDir", "dispose", "", "CachedData", "intellij.platform.polySymbols"})
final class PolyContextDiscoveryInfo
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<String, Map<VirtualFile, String>> previousContext;
    @NotNull
    private final ConcurrentMap<VirtualFile, CachedData> cachedData;

    public PolyContextDiscoveryInfo(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.previousContext = new ConcurrentHashMap();
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.cachedData = concurrentMap;
        MessageBusConnection messageBus = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBus.subscribe(topic, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                previousContext.clear();
                cachedData.clear();
                1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Notifying that PolyContext may have changed due to roots changes.");
                ((PolyContextChangeListener)project.getMessageBus().syncPublisher(PolyContextChangeListener.Companion.getTOPIC())).contextMayHaveChanged();
            }
        });
        messageBus.subscribe(PolyContextChangeListener.Companion.getTOPIC(), () -> PolyContextDiscoveryInfo._init_$lambda$0(this));
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        messageBus.subscribe(topic2, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Object v1;
                block2: {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    Iterable iterable = events;
                    for (Object t : iterable) {
                        VFileEvent it = (VFileEvent)t;
                        boolean bl = false;
                        VirtualFile virtualFile = it.getFile();
                        if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getName() : null), (Object)PolyContext.POLY_SYMBOLS_CONTEXT_FILE)) continue;
                        v1 = t;
                        break block2;
                    }
                    v1 = null;
                }
                VFileEvent wsFile = v1;
                if (wsFile != null) {
                    3 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(3.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Notifying that PolyContext may have changed due to changes in " + wsFile.getPath() + ".");
                    BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ PolyContextDiscoveryInfo this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    ((PolyContextChangeListener)PolyContextDiscoveryInfo.access$getProject$p(this.this$0).getMessageBus().syncPublisher(PolyContextChangeListener.Companion.getTOPIC())).contextMayHaveChanged();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        });
        ExtensionPoint extensionPoint = PolyContextDiscoveryKt.access$getPOLY_SYMBOLS_CONTEXT_EP().getPoint();
        Intrinsics.checkNotNull((Object)extensionPoint);
        extensionPoint.addChangeListener(() -> PolyContextDiscoveryInfo._init_$lambda$1(this), (Disposable)this.project);
    }

    @Nullable
    public final Integer getProximityFromExtensions(@NotNull VirtualFile dir, @NotNull String kind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Integer)this.getCachedDataForDir(dir).getProximity().computeIfAbsent((Pair<String, String>)new Pair((Object)kind, (Object)name), arg_0 -> PolyContextDiscoveryInfo.getProximityFromExtensions$lambda$1(arg_0 -> PolyContextDiscoveryInfo.getProximityFromExtensions$lambda$0(this, kind, name, dir, arg_0), arg_0)).getValue();
    }

    @Nullable
    public final String updateContext(@NotNull VirtualFile contextFile, @NotNull String kind, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.previousContext.computeIfAbsent(kind, arg_0 -> PolyContextDiscoveryInfo.updateContext$lambda$1(PolyContextDiscoveryInfo::updateContext$lambda$0, arg_0)).put(contextFile, name);
    }

    @NotNull
    public final ContextRulesConfigInDir getContextRulesConfigInDir(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object object = this.getCachedDataForDir(dir).getRulesConfig().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ContextRulesConfigInDir)object;
    }

    @NotNull
    public final ContextFileConfigInDir getContextFileConfigInDir(@NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object object = this.getCachedDataForDir(dir).getFilesConfig().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ContextFileConfigInDir)object;
    }

    private final CachedData getCachedDataForDir(VirtualFile dir) {
        CachedData cachedData = this.cachedData.computeIfAbsent(dir, arg_0 -> PolyContextDiscoveryInfo.getCachedDataForDir$lambda$1(arg_0 -> PolyContextDiscoveryInfo.getCachedDataForDir$lambda$0(this, dir, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)cachedData, (String)"computeIfAbsent(...)");
        return cachedData;
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(PolyContextDiscoveryInfo this$0) {
        DaemonCodeAnalyzer.getInstance((Project)this$0.project).restart((Object)"PolyContextDiscoveryInfo.PolyContextChangeListener");
    }

    private static final void _init_$lambda$1(PolyContextDiscoveryInfo this$0) {
        this$0.cachedData.clear();
    }

    private static final CachedValue getProximityFromExtensions$lambda$0(PolyContextDiscoveryInfo this$0, String $kind, String $name, VirtualFile $dir, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CachedValuesManager.getManager((Project)this$0.project).createCachedValue(() -> PolyContextDiscoveryInfo.getProximityFromExtensions$lambda$0$0($kind, $name, this$0, $dir));
    }

    private static final CachedValueProvider.Result getProximityFromExtensions$lambda$0$0(String $kind, String $name, PolyContextDiscoveryInfo this$0, VirtualFile $dir) {
        return PolyContextDiscoveryKt.access$webContextProximityFromProviders($kind, $name, this$0.project, $dir);
    }

    private static final CachedValue getProximityFromExtensions$lambda$1(Function1 $tmp0, Object p0) {
        return (CachedValue)$tmp0.invoke(p0);
    }

    private static final Map updateContext$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ContainerUtil.createConcurrentWeakMap();
    }

    private static final Map updateContext$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final CachedData getCachedDataForDir$lambda$0(PolyContextDiscoveryInfo this$0, VirtualFile $dir, VirtualFile it) {
        return new CachedData(this$0.project, $dir);
    }

    private static final CachedData getCachedDataForDir$lambda$1(Function1 $tmp0, Object p0) {
        return (CachedData)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\b\u001a*\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\b\u0012\u00060\u000bj\u0002`\r0\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/polySymbols/context/impl/PolyContextDiscoveryInfo$CachedData;", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "proximity", "", "Lkotlin/Pair;", "", "Lcom/intellij/polySymbols/PolyContextKind;", "Lcom/intellij/polySymbols/PolyContextName;", "Lcom/intellij/psi/util/CachedValue;", "", "getProximity", "()Ljava/util/Map;", "rulesConfig", "Lcom/intellij/polySymbols/context/impl/ContextRulesConfigInDir;", "getRulesConfig", "()Lcom/intellij/psi/util/CachedValue;", "filesConfig", "Lcom/intellij/polySymbols/context/impl/ContextFileConfigInDir;", "getFilesConfig", "intellij.platform.polySymbols"})
    private static final class CachedData {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile directory;
        @NotNull
        private final Map<Pair<String, String>, CachedValue<Integer>> proximity;
        @NotNull
        private final CachedValue<ContextRulesConfigInDir> rulesConfig;
        @NotNull
        private final CachedValue<ContextFileConfigInDir> filesConfig;

        public CachedData(@NotNull Project project, @NotNull VirtualFile directory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.project = project;
            this.directory = directory;
            this.proximity = new ConcurrentHashMap();
            CachedValue cachedValue = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> CachedData.rulesConfig$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"createCachedValue(...)");
            this.rulesConfig = cachedValue;
            CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> CachedData.filesConfig$lambda$0(this));
            Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
            this.filesConfig = cachedValue2;
        }

        @NotNull
        public final Map<Pair<String, String>, CachedValue<Integer>> getProximity() {
            return this.proximity;
        }

        @NotNull
        public final CachedValue<ContextRulesConfigInDir> getRulesConfig() {
            return this.rulesConfig;
        }

        @NotNull
        public final CachedValue<ContextFileConfigInDir> getFilesConfig() {
            return this.filesConfig;
        }

        private static final CachedValueProvider.Result rulesConfig$lambda$0(CachedData this$0) {
            ContextRulesConfigInDir result2 = PolyContextDiscoveryKt.access$loadContextRulesConfiguration(this$0.project, this$0.directory);
            return CachedValueProvider.Result.create((Object)result2, (Collection)result2.getDependencies());
        }

        private static final CachedValueProvider.Result filesConfig$lambda$0(CachedData this$0) {
            ContextFileConfigInDir result2 = PolyContextDiscoveryKt.access$loadContextFilesConfiguration(this$0.directory);
            return CachedValueProvider.Result.create((Object)result2, (Collection)result2.getDependencies());
        }
    }
}

