/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.cache.CacheGatedPostingsReader;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCache;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCacheItem;
import org.opensearch.neuralsearch.sparse.codec.SparsePostingsEnum;
import org.opensearch.neuralsearch.sparse.codec.SparseTermsLuceneReader;
import org.opensearch.neuralsearch.sparse.data.PostingClusters;

public class SparseTerms
extends Terms {
    private final CacheKey cacheKey;
    private final CacheGatedPostingsReader reader;

    public SparseTerms(CacheKey cacheKey, SparseTermsLuceneReader sparseTermsLuceneReader, String field) {
        this.cacheKey = cacheKey;
        ClusteredPostingCacheItem clusteredPostingCacheItem = ClusteredPostingCache.getInstance().getOrCreate(cacheKey);
        this.reader = new CacheGatedPostingsReader(field, clusteredPostingCacheItem.getReader(), clusteredPostingCacheItem.getWriter(), sparseTermsLuceneReader);
    }

    public TermsEnum iterator() throws IOException {
        return new SparseTermsEnum();
    }

    public long size() throws IOException {
        return this.reader.size();
    }

    public long getSumTotalTermFreq() throws IOException {
        return 0L;
    }

    public long getSumDocFreq() throws IOException {
        return 0L;
    }

    public int getDocCount() throws IOException {
        return 0;
    }

    public boolean hasFreqs() {
        return false;
    }

    public boolean hasOffsets() {
        return false;
    }

    public boolean hasPositions() {
        return false;
    }

    public boolean hasPayloads() {
        return false;
    }

    @Generated
    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    @Generated
    public CacheGatedPostingsReader getReader() {
        return this.reader;
    }

    class SparseTermsEnum
    extends BaseTermsEnum {
        private BytesRef currentTerm;
        private Iterator<BytesRef> termIterator;

        SparseTermsEnum() throws IOException {
            Set<BytesRef> terms = SparseTerms.this.reader.getTerms();
            if (terms != null) {
                this.termIterator = terms.iterator();
            }
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            if (SparseTerms.this.reader.read(text) == null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            this.currentTerm = text.clone();
            return TermsEnum.SeekStatus.FOUND;
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BytesRef term() throws IOException {
            return this.currentTerm;
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            if (this.currentTerm == null) {
                return null;
            }
            PostingClusters clusters = SparseTerms.this.reader.read(this.currentTerm);
            if (clusters != null) {
                return new SparsePostingsEnum(clusters, SparseTerms.this.cacheKey);
            }
            return null;
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BytesRef next() throws IOException {
            if (this.termIterator == null || !this.termIterator.hasNext()) {
                this.currentTerm = null;
                return null;
            }
            this.currentTerm = this.termIterator.next();
            return this.currentTerm;
        }
    }
}

