/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ParsedHeader;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.StructuredDataTerminal;

public class DecryptStructureOutput {
    private final Map<String, StructuredDataTerminal> plaintextStructure;
    private final Map<String, CryptoAction> cryptoSchema;
    private final ParsedHeader parsedHeader;

    protected DecryptStructureOutput(BuilderImpl builder) {
        this.plaintextStructure = builder.plaintextStructure();
        this.cryptoSchema = builder.cryptoSchema();
        this.parsedHeader = builder.parsedHeader();
    }

    public Map<String, StructuredDataTerminal> plaintextStructure() {
        return this.plaintextStructure;
    }

    public Map<String, CryptoAction> cryptoSchema() {
        return this.cryptoSchema;
    }

    public ParsedHeader parsedHeader() {
        return this.parsedHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected Map<String, StructuredDataTerminal> plaintextStructure;
        protected Map<String, CryptoAction> cryptoSchema;
        protected ParsedHeader parsedHeader;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptStructureOutput model) {
            this.plaintextStructure = model.plaintextStructure();
            this.cryptoSchema = model.cryptoSchema();
            this.parsedHeader = model.parsedHeader();
        }

        @Override
        public Builder plaintextStructure(Map<String, StructuredDataTerminal> plaintextStructure) {
            this.plaintextStructure = plaintextStructure;
            return this;
        }

        @Override
        public Map<String, StructuredDataTerminal> plaintextStructure() {
            return this.plaintextStructure;
        }

        @Override
        public Builder cryptoSchema(Map<String, CryptoAction> cryptoSchema) {
            this.cryptoSchema = cryptoSchema;
            return this;
        }

        @Override
        public Map<String, CryptoAction> cryptoSchema() {
            return this.cryptoSchema;
        }

        @Override
        public Builder parsedHeader(ParsedHeader parsedHeader) {
            this.parsedHeader = parsedHeader;
            return this;
        }

        @Override
        public ParsedHeader parsedHeader() {
            return this.parsedHeader;
        }

        @Override
        public DecryptStructureOutput build() {
            if (Objects.isNull(this.plaintextStructure())) {
                throw new IllegalArgumentException("Missing value for required field `plaintextStructure`");
            }
            if (Objects.isNull(this.cryptoSchema())) {
                throw new IllegalArgumentException("Missing value for required field `cryptoSchema`");
            }
            if (Objects.isNull(this.parsedHeader())) {
                throw new IllegalArgumentException("Missing value for required field `parsedHeader`");
            }
            return new DecryptStructureOutput(this);
        }
    }

    public static interface Builder {
        public Builder plaintextStructure(Map<String, StructuredDataTerminal> var1);

        public Map<String, StructuredDataTerminal> plaintextStructure();

        public Builder cryptoSchema(Map<String, CryptoAction> var1);

        public Map<String, CryptoAction> cryptoSchema();

        public Builder parsedHeader(ParsedHeader var1);

        public ParsedHeader parsedHeader();

        public DecryptStructureOutput build();
    }
}

