/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.legacy;

import StandardLibraryInternal.InternalResult;
import Wrappers_Compile.Option;
import Wrappers_Compile.Result;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.DynamoDBEncryptor;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionFlags;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.ILegacyDynamoDbEncryptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.ToNative;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyOverride;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.internaldafny.types.LegacyPolicy;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.ToDafny;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.legacy._ExternBase_InternalLegacyOverride;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.DecryptItemInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.DynamoDbItemEncryptorConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.EncryptItemInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.Error;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model.DecryptItemOutput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model.EncryptItemOutput;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction;
import software.amazon.smithy.dafny.conversion.ToDafny;
import software.amazon.smithy.dafny.conversion.ToNative;

public class InternalLegacyOverride
extends _ExternBase_InternalLegacyOverride {
    private DynamoDBEncryptor encryptor;
    private Map<String, Set<EncryptionFlags>> actions;
    private EncryptionContext encryptionContext;
    private LegacyPolicy _policy;
    private DafnySequence<Character> materialDescriptionFieldName;
    private DafnySequence<Character> signatureFieldName;

    private InternalLegacyOverride(DynamoDBEncryptor encryptor, Map<String, Set<EncryptionFlags>> actions, EncryptionContext encryptionContext, LegacyPolicy policy) {
        this.encryptor = encryptor;
        this.actions = actions;
        this.encryptionContext = encryptionContext;
        this._policy = policy;
        this.materialDescriptionFieldName = ToDafny.Simple.CharacterSequence((String)encryptor.getMaterialDescriptionFieldName());
        this.signatureFieldName = ToDafny.Simple.CharacterSequence((String)encryptor.getSignatureFieldName());
    }

    public static TypeDescriptor<InternalLegacyOverride> _typeDescriptor() {
        return TypeDescriptor.referenceWithInitializer(InternalLegacyOverride.class, () -> null);
    }

    @Override
    public boolean IsLegacyInput(DecryptItemInput input) {
        return input.is_DecryptItemInput() && input._encryptedItem.contains(this.materialDescriptionFieldName) && input._encryptedItem.contains(this.signatureFieldName);
    }

    public LegacyPolicy policy() {
        return this._policy;
    }

    @Override
    public Result<software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.EncryptItemOutput, Error> EncryptItem(EncryptItemInput input) {
        if (!this._policy.is_FORCE__LEGACY__ENCRYPT__ALLOW__LEGACY__DECRYPT()) {
            return this.CreateEncryptItemFailure(InternalLegacyOverride.createError("Legacy Policy does not support encrypt."));
        }
        try {
            Map<String, AttributeValue> plaintextItem = software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.ToNative.EncryptItemInput(input).plaintextItem();
            Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> encryptedItem = this.encryptor.encryptRecord(InternalLegacyOverride.V2MapToV1Map(plaintextItem), this.actions, this.encryptionContext);
            EncryptItemOutput nativeOutput = EncryptItemOutput.builder().encryptedItem(InternalLegacyOverride.V1MapToV2Map(encryptedItem)).build();
            software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.EncryptItemOutput dafnyOutput = ToDafny.EncryptItemOutput(nativeOutput);
            return this.CreateEncryptItemSuccess(dafnyOutput);
        }
        catch (Exception ex) {
            return this.CreateEncryptItemFailure(Error.create_Opaque(ex));
        }
    }

    @Override
    public Result<software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.DecryptItemOutput, Error> DecryptItem(DecryptItemInput input) {
        if (!this._policy.is_FORCE__LEGACY__ENCRYPT__ALLOW__LEGACY__DECRYPT() && !this._policy.is_FORBID__LEGACY__ENCRYPT__ALLOW__LEGACY__DECRYPT()) {
            return this.CreateDecryptItemFailure(InternalLegacyOverride.createError("Legacy Policy does not support decrypt."));
        }
        try {
            Map<String, AttributeValue> encryptedItem = software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.ToNative.DecryptItemInput(input).encryptedItem();
            Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> plaintextItem = this.encryptor.decryptRecord(InternalLegacyOverride.V2MapToV1Map(encryptedItem), this.actions, this.encryptionContext);
            DecryptItemOutput nativeOutput = DecryptItemOutput.builder().plaintextItem(InternalLegacyOverride.V1MapToV2Map(plaintextItem)).build();
            software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.internaldafny.types.DecryptItemOutput dafnyOutput = ToDafny.DecryptItemOutput(nativeOutput);
            return this.CreateDecryptItemSuccess(dafnyOutput);
        }
        catch (Exception ex) {
            return this.CreateDecryptItemFailure(Error.create_Opaque(ex));
        }
    }

    public static Result<Option<InternalLegacyOverride>, Error> Build(DynamoDbItemEncryptorConfig encryptorConfig) {
        if (encryptorConfig.dtor_legacyOverride().is_None()) {
            return InternalLegacyOverride.CreateBuildSuccess(InternalLegacyOverride.CreateInternalLegacyOverrideNone());
        }
        LegacyOverride legacyOverride = (LegacyOverride)encryptorConfig.dtor_legacyOverride().dtor_value();
        ILegacyDynamoDbEncryptor maybeEncryptor = ToNative.LegacyDynamoDbEncryptor(legacyOverride.dtor_encryptor());
        if (!InternalLegacyOverride.isDynamoDBEncryptor(maybeEncryptor)) {
            return InternalLegacyOverride.CreateBuildFailure(InternalLegacyOverride.createError("Legacy encryptor is not supported"));
        }
        InternalResult<EncryptionContext, Error> maybeEncryptionContext = InternalLegacyOverride.legacyEncryptionContext(encryptorConfig);
        if (maybeEncryptionContext.isFailure()) {
            return InternalLegacyOverride.CreateBuildFailure((Error)maybeEncryptionContext.error());
        }
        InternalResult<Map<String, Set<EncryptionFlags>>, Error> maybeActions = InternalLegacyOverride.legacyActions(legacyOverride.dtor_attributeActionsOnEncrypt());
        if (maybeActions.isFailure()) {
            return InternalLegacyOverride.CreateBuildFailure((Error)maybeEncryptionContext.error());
        }
        InternalLegacyOverride internalLegacyOverride = new InternalLegacyOverride((DynamoDBEncryptor)maybeEncryptor, (Map)maybeActions.value(), (EncryptionContext)maybeEncryptionContext.value(), legacyOverride.dtor_policy());
        return InternalLegacyOverride.CreateBuildSuccess(InternalLegacyOverride.CreateInternalLegacyOverrideSome(internalLegacyOverride));
    }

    public static Error createError(String message) {
        DafnySequence dafnyMessage = ToDafny.Simple.CharacterSequence((String)message);
        return Error.create_DynamoDbItemEncryptorException((DafnySequence<? extends Character>)dafnyMessage);
    }

    public static boolean isDynamoDBEncryptor(ILegacyDynamoDbEncryptor maybe) {
        return maybe instanceof DynamoDBEncryptor;
    }

    public static String ToNativeString(DafnySequence<? extends Character> s) {
        return ToNative.Simple.String(s);
    }

    public static DafnySequence<Character> ToDafnyString(String s) {
        return ToDafny.Simple.CharacterSequence((String)s);
    }

    public static InternalResult<EncryptionContext, Error> legacyEncryptionContext(DynamoDbItemEncryptorConfig config) {
        try {
            EncryptionContext.Builder encryptionContextBuilder = new EncryptionContext.Builder().withTableName(InternalLegacyOverride.ToNativeString(config.dtor_logicalTableName())).withHashKeyName(InternalLegacyOverride.ToNativeString(config.dtor_partitionKeyName()));
            EncryptionContext encryptionContext = config.dtor_sortKeyName().is_Some() ? encryptionContextBuilder.withRangeKeyName(InternalLegacyOverride.ToNativeString((DafnySequence<? extends Character>)((DafnySequence)config.dtor_sortKeyName().dtor_value()))).build() : encryptionContextBuilder.build();
            return InternalResult.success((Object)encryptionContext);
        }
        catch (Exception ex) {
            return InternalResult.failure((Object)Error.create_Opaque(ex));
        }
    }

    public static InternalResult<Map<String, Set<EncryptionFlags>>, Error> legacyActions(DafnyMap<? extends DafnySequence<? extends Character>, ? extends CryptoAction> attributeActionsOnEncrypt) {
        try {
            EnumSet<EncryptionFlags> signOnly = EnumSet.of(EncryptionFlags.SIGN);
            EnumSet<EncryptionFlags> encryptAndSign = EnumSet.of(EncryptionFlags.ENCRYPT, EncryptionFlags.SIGN);
            HashMap legacyActions = new HashMap();
            BiConsumer<DafnySequence, CryptoAction> buildLegacyActions = (dafnyKey, value) -> {
                String key = InternalLegacyOverride.ToNativeString((DafnySequence<? extends Character>)dafnyKey);
                if (value.is_SIGN__ONLY()) {
                    legacyActions.put(key, signOnly);
                } else if (value.is_ENCRYPT__AND__SIGN()) {
                    legacyActions.put(key, encryptAndSign);
                } else if (!value.is_DO__NOTHING()) {
                    throw new IllegalArgumentException("Unsupported CryptoAction.");
                }
            };
            attributeActionsOnEncrypt.forEach(buildLegacyActions);
            return InternalResult.success(legacyActions);
        }
        catch (IllegalArgumentException ex) {
            Error dafnyEx = Error.create_DynamoDbItemEncryptorException(InternalLegacyOverride.ToDafnyString(ex.getMessage()));
            return InternalResult.failure((Object)dafnyEx);
        }
        catch (Exception ex) {
            return InternalResult.failure((Object)Error.create_Opaque(ex));
        }
    }

    public static com.amazonaws.services.dynamodbv2.model.AttributeValue V2AttributeToV1Attribute(AttributeValue value) {
        com.amazonaws.services.dynamodbv2.model.AttributeValue attribute = new com.amazonaws.services.dynamodbv2.model.AttributeValue();
        switch (value.type()) {
            case B: {
                return attribute.withB(value.b().asByteBuffer());
            }
            case BOOL: {
                return attribute.withBOOL(value.bool());
            }
            case BS: {
                return attribute.withBS((Collection)value.bs().stream().map(b -> b.asByteBuffer()).collect(Collectors.toList()));
            }
            case L: {
                return attribute.withL((Collection)value.l().stream().map(a -> InternalLegacyOverride.V2AttributeToV1Attribute(a)).collect(Collectors.toList()));
            }
            case M: {
                return attribute.withM(InternalLegacyOverride.V2MapToV1Map(value.m()));
            }
            case N: {
                return attribute.withN(value.n());
            }
            case NS: {
                return attribute.withNS((Collection)value.ns());
            }
            case NUL: {
                return attribute.withNULL(value.nul());
            }
            case S: {
                return attribute.withS(value.s());
            }
            case SS: {
                return attribute.withSS((Collection)value.ss());
            }
            case UNKNOWN_TO_SDK_VERSION: {
                throw new IllegalArgumentException("omfg");
            }
        }
        throw new IllegalArgumentException("omfg");
    }

    public static Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> V2MapToV1Map(Map<String, AttributeValue> input) {
        return input.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> InternalLegacyOverride.V2AttributeToV1Attribute((AttributeValue)entry.getValue())));
    }

    public static AttributeValue V1AttributeToV2Attribute(com.amazonaws.services.dynamodbv2.model.AttributeValue value) {
        AttributeValue.Builder attributeBuilder = AttributeValue.builder();
        if (Boolean.TRUE.equals(value.getNULL())) {
            return (AttributeValue)attributeBuilder.nul(value.getNULL()).build();
        }
        if (Boolean.FALSE.equals(value.getNULL())) {
            throw new UnsupportedOperationException("False-NULL is not supported in DynamoDB");
        }
        if (value.getBOOL() != null) {
            return (AttributeValue)attributeBuilder.bool(value.getBOOL()).build();
        }
        if (value.getS() != null) {
            return (AttributeValue)attributeBuilder.s(value.getS()).build();
        }
        if (value.getN() != null) {
            return (AttributeValue)attributeBuilder.n(value.getN()).build();
        }
        if (value.getB() != null) {
            return (AttributeValue)attributeBuilder.b(SdkBytes.fromByteBuffer((ByteBuffer)value.getB())).build();
        }
        if (value.getSS() != null) {
            return (AttributeValue)attributeBuilder.ss((Collection)value.getSS()).build();
        }
        if (value.getNS() != null) {
            return (AttributeValue)attributeBuilder.ns((Collection)value.getNS()).build();
        }
        if (value.getBS() != null) {
            return (AttributeValue)attributeBuilder.bs((Collection)value.getBS().stream().map(bb -> SdkBytes.fromByteBuffer((ByteBuffer)bb)).collect(Collectors.toList())).build();
        }
        if (value.getL() != null) {
            return (AttributeValue)attributeBuilder.l((Collection)value.getL().stream().map(a -> InternalLegacyOverride.V1AttributeToV2Attribute(a)).collect(Collectors.toList())).build();
        }
        if (value.getM() != null) {
            return (AttributeValue)attributeBuilder.m(InternalLegacyOverride.V1MapToV2Map(value.getM())).build();
        }
        throw new IllegalArgumentException("Unsupported Value" + value);
    }

    public static Map<String, AttributeValue> V1MapToV2Map(Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> input) {
        return input.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> InternalLegacyOverride.V1AttributeToV2Attribute((com.amazonaws.services.dynamodbv2.model.AttributeValue)entry.getValue())));
    }
}

