/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningLogicWarningType;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailAutomatedReasoningLogicWarning
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailAutomatedReasoningLogicWarning> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailAutomatedReasoningLogicWarning.getter(GuardrailAutomatedReasoningLogicWarning::typeAsString)).setter(GuardrailAutomatedReasoningLogicWarning.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<GuardrailAutomatedReasoningStatement>> PREMISES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("premises").getter(GuardrailAutomatedReasoningLogicWarning.getter(GuardrailAutomatedReasoningLogicWarning::premises)).setter(GuardrailAutomatedReasoningLogicWarning.setter(Builder::premises)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("premises").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailAutomatedReasoningStatement>> CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("claims").getter(GuardrailAutomatedReasoningLogicWarning.getter(GuardrailAutomatedReasoningLogicWarning::claims)).setter(GuardrailAutomatedReasoningLogicWarning.setter(Builder::claims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claims").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PREMISES_FIELD, CLAIMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailAutomatedReasoningLogicWarning.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<GuardrailAutomatedReasoningStatement> premises;
    private final List<GuardrailAutomatedReasoningStatement> claims;

    private GuardrailAutomatedReasoningLogicWarning(BuilderImpl builder) {
        this.type = builder.type;
        this.premises = builder.premises;
        this.claims = builder.claims;
    }

    public final GuardrailAutomatedReasoningLogicWarningType type() {
        return GuardrailAutomatedReasoningLogicWarningType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasPremises() {
        return this.premises != null && !(this.premises instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningStatement> premises() {
        return this.premises;
    }

    public final boolean hasClaims() {
        return this.claims != null && !(this.claims instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningStatement> claims() {
        return this.claims;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPremises() ? this.premises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClaims() ? this.claims() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningLogicWarning)) {
            return false;
        }
        GuardrailAutomatedReasoningLogicWarning other = (GuardrailAutomatedReasoningLogicWarning)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasPremises() == other.hasPremises() && Objects.equals(this.premises(), other.premises()) && this.hasClaims() == other.hasClaims() && Objects.equals(this.claims(), other.claims());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailAutomatedReasoningLogicWarning").add("Type", (Object)this.typeAsString()).add("Premises", this.hasPremises() ? this.premises() : null).add("Claims", this.hasClaims() ? this.claims() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "premises": {
                return Optional.ofNullable(clazz.cast(this.premises()));
            }
            case "claims": {
                return Optional.ofNullable(clazz.cast(this.claims()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("premises", PREMISES_FIELD);
        map.put("claims", CLAIMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningLogicWarning, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningLogicWarning)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<GuardrailAutomatedReasoningStatement> premises = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailAutomatedReasoningStatement> claims = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningLogicWarning model) {
            this.type(model.type);
            this.premises(model.premises);
            this.claims(model.claims);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailAutomatedReasoningLogicWarningType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<GuardrailAutomatedReasoningStatement.Builder> getPremises() {
            List<GuardrailAutomatedReasoningStatement.Builder> result = GuardrailAutomatedReasoningStatementListCopier.copyToBuilder(this.premises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPremises(Collection<GuardrailAutomatedReasoningStatement.BuilderImpl> premises) {
            this.premises = GuardrailAutomatedReasoningStatementListCopier.copyFromBuilder(premises);
        }

        @Override
        public final Builder premises(Collection<GuardrailAutomatedReasoningStatement> premises) {
            this.premises = GuardrailAutomatedReasoningStatementListCopier.copy(premises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(GuardrailAutomatedReasoningStatement ... premises) {
            this.premises(Arrays.asList(premises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... premises) {
            this.premises(Stream.of(premises).map(c -> (GuardrailAutomatedReasoningStatement)((GuardrailAutomatedReasoningStatement.Builder)GuardrailAutomatedReasoningStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAutomatedReasoningStatement.Builder> getClaims() {
            List<GuardrailAutomatedReasoningStatement.Builder> result = GuardrailAutomatedReasoningStatementListCopier.copyToBuilder(this.claims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClaims(Collection<GuardrailAutomatedReasoningStatement.BuilderImpl> claims) {
            this.claims = GuardrailAutomatedReasoningStatementListCopier.copyFromBuilder(claims);
        }

        @Override
        public final Builder claims(Collection<GuardrailAutomatedReasoningStatement> claims) {
            this.claims = GuardrailAutomatedReasoningStatementListCopier.copy(claims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(GuardrailAutomatedReasoningStatement ... claims) {
            this.claims(Arrays.asList(claims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... claims) {
            this.claims(Stream.of(claims).map(c -> (GuardrailAutomatedReasoningStatement)((GuardrailAutomatedReasoningStatement.Builder)GuardrailAutomatedReasoningStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GuardrailAutomatedReasoningLogicWarning build() {
            return new GuardrailAutomatedReasoningLogicWarning(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailAutomatedReasoningLogicWarning> {
        public Builder type(String var1);

        public Builder type(GuardrailAutomatedReasoningLogicWarningType var1);

        public Builder premises(Collection<GuardrailAutomatedReasoningStatement> var1);

        public Builder premises(GuardrailAutomatedReasoningStatement ... var1);

        public Builder premises(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... var1);

        public Builder claims(Collection<GuardrailAutomatedReasoningStatement> var1);

        public Builder claims(GuardrailAutomatedReasoningStatement ... var1);

        public Builder claims(Consumer<GuardrailAutomatedReasoningStatement.Builder> ... var1);
    }
}

