/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.remote;

import com.intellij.CommonBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.HunspellDescriptor;
import com.intellij.grazie.remote.LanguageDownloader;
import com.intellij.grazie.remote.LanguageToolDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.io.DigestUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/grazie/remote/GrazieRemote;", "", "<init>", "()V", "isJLangAvailableLocally", "", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "isAvailableLocally", "allAvailableLocally", "languages", "", "downloadWithoutLicenseCheck", "downloadAsync", "", "project", "Lcom/intellij/openapi/project/Project;", "downloadMissing", "getLanguagesBasedOnUserAgreement", "isValidBundleForLanguage", "language", "file", "Ljava/nio/file/Path;", "checksum", "", "path", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieRemote.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieRemote.kt\ncom/intellij/grazie/remote/GrazieRemote\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1740#2,3:100\n774#2:103\n865#2,2:104\n774#2:106\n865#2,2:107\n*S KotlinDebug\n*F\n+ 1 GrazieRemote.kt\ncom/intellij/grazie/remote/GrazieRemote\n*L\n32#1:100,3\n61#1:103\n61#1:104,2\n74#1:106\n74#1:107,2\n*E\n"})
public final class GrazieRemote {
    @NotNull
    public static final GrazieRemote INSTANCE = new GrazieRemote();

    private GrazieRemote() {
    }

    public final boolean isJLangAvailableLocally(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        if (lang.isEnglish()) {
            return true;
        }
        Path path = GrazieDynamic.INSTANCE.getLangDynamicFolder(lang);
        LanguageToolDescriptor languageToolDescriptor = lang.getLtRemote();
        Intrinsics.checkNotNull((Object)languageToolDescriptor);
        Path path2 = path.resolve(languageToolDescriptor.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    public final boolean isAvailableLocally(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        if (lang.isEnglish()) {
            return true;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(GrazieDynamic.INSTANCE.getLangDynamicFolder(lang), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    public final boolean allAvailableLocally(@NotNull Collection<? extends Lang> languages2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(languages2, (String)"languages");
            Iterable $this$all$iv = languages2;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Lang it = (Lang)((Object)element$iv);
                    boolean bl2 = false;
                    if (INSTANCE.isAvailableLocally(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean downloadWithoutLicenseCheck(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return LanguageDownloader.INSTANCE.download$intellij_grazie_core(lang);
    }

    public final void downloadAsync(@NotNull Collection<? extends Lang> languages2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LanguageDownloader.INSTANCE.downloadAsync(languages2, project);
    }

    public final void downloadMissing(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.downloadAsync((Collection<? extends Lang>)GrazieConfig.Companion.get().getMissedLanguages(), project);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final Collection<Lang> getLanguagesBasedOnUserAgreement(@NotNull Collection<? extends Lang> languages2, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        boolean hasUserAgreement;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!Registry.Companion.is("grazie.show.gpl.warning")) {
            return languages2;
        }
        Iterable iterable = languages2;
        boolean $i$f$filter22 = false;
        void var6_7 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Lang it = (Lang)((Object)element$iv$iv);
            boolean bl = false;
            HunspellDescriptor hunspellDescriptor = it.getHunspellRemote();
            boolean bl2 = hunspellDescriptor != null ? hunspellDescriptor.isGplLicensed() : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List gplLanguages = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (gplLanguages.isEmpty()) {
            return languages2;
        }
        String[] $i$f$filter22 = new String[]{CollectionsKt.joinToString$default((Iterable)gplLanguages, null, null, null, (int)0, null, GrazieRemote::getLanguagesBasedOnUserAgreement$lambda$1, (int)31, null)};
        boolean bl = hasUserAgreement = Messages.showOkCancelDialog((Project)project, (String)SwingKTKt.msg("grazie.license.gpl.message", $i$f$filter22), (String)SwingKTKt.msg("grazie.license.gpl.title", new String[0]), (String)CommonBundle.getYesButtonText(), (String)(languages2.size() == gplLanguages.size() ? CommonBundle.getNoButtonText() : SwingKTKt.msg("grazie.license.gpl.cancel", new String[0])), (Icon)Messages.getQuestionIcon()) == 0;
        if (hasUserAgreement) {
            return languages2;
        }
        Iterable $this$filter$iv2 = languages2;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Lang it = (Lang)((Object)element$iv$iv);
            boolean bl3 = false;
            HunspellDescriptor hunspellDescriptor = it.getHunspellRemote();
            boolean bl4 = hunspellDescriptor != null ? hunspellDescriptor.isGplLicensed() : false;
            if (!(!bl4)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    public final boolean isValidBundleForLanguage(@NotNull Lang language, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LanguageToolDescriptor languageToolDescriptor = language.getLtRemote();
        if (languageToolDescriptor == null) {
            return false;
        }
        LanguageToolDescriptor remote = languageToolDescriptor;
        String actualChecksum = this.checksum(file);
        return Intrinsics.areEqual((Object)remote.getChecksum(), (Object)actualChecksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public final String checksum(@NotNull Path path) {
        MessageDigest messageDigest;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            MessageDigest digest = DigestUtil.md5();
            Closeable closeable2 = new DigestInputStream(it, digest);
            Throwable throwable2 = null;
            try {
                DigestInputStream stream = (DigestInputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                while (bytesRead != -1) {
                    bytesRead = stream.read(buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            messageDigest = digest;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        MessageDigest digest = messageDigest;
        return DigestUtil.digestToHash((MessageDigest)digest);
    }

    private static final CharSequence getLanguagesBasedOnUserAgreement$lambda$1(Lang it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getShortDisplayName();
    }
}

