/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.dialogs.InputDialog;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;

public class FindDataTypesByNameAction
extends DockingAction {
    public static final String NAME = "Find Data Types by Name";
    private final DataTypeManagerPlugin plugin;

    public FindDataTypesByNameAction(DataTypeManagerPlugin plugin, String menuSubGroup) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Find Data Types by Name..."}, null, "VeryLast", -1, menuSubGroup));
        this.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Find_Data_Types_By_Name"));
    }

    public void actionPerformed(ActionContext context) {
        InputDialog inputDialog = new InputDialog(NAME, "Please enter the search string: ");
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)inputDialog);
        if (inputDialog.isCanceled()) {
            return;
        }
        String searchString = inputDialog.getValue();
        DataTypesProvider newProvider = this.plugin.createProvider();
        newProvider.setTitle(NAME);
        newProvider.setFilterText(searchString);
        newProvider.setVisible(true);
    }
}

