/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.IconValue;
import generic.theme.JavaPropertyValue;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import resources.icons.UrlImageIcon;

public class GThemeValueMap {
    protected Map<String, ColorValue> colorMap = new HashMap<String, ColorValue>();
    protected Map<String, FontValue> fontMap = new HashMap<String, FontValue>();
    protected Map<String, IconValue> iconMap = new HashMap<String, IconValue>();
    protected Map<String, JavaPropertyValue> propertyMap = new HashMap<String, JavaPropertyValue>();

    public GThemeValueMap() {
    }

    public GThemeValueMap(GThemeValueMap initial) {
        this.load(initial);
    }

    public ColorValue addColor(ColorValue value) {
        if (value != null) {
            return this.colorMap.put(value.getId(), value);
        }
        return null;
    }

    public FontValue addFont(FontValue value) {
        if (value != null) {
            return this.fontMap.put(value.getId(), value);
        }
        return null;
    }

    public IconValue addIcon(IconValue value) {
        if (value != null) {
            return this.iconMap.put(value.getId(), value);
        }
        return null;
    }

    public JavaPropertyValue addProperty(JavaPropertyValue value) {
        if (value != null) {
            return this.propertyMap.put(value.getId(), value);
        }
        return null;
    }

    public ColorValue getColor(String id) {
        return this.colorMap.get(id);
    }

    public FontValue getFont(String id) {
        return this.fontMap.get(id);
    }

    public IconValue getIcon(String id) {
        return this.iconMap.get(id);
    }

    public JavaPropertyValue getProperty(String id) {
        return this.propertyMap.get(id);
    }

    public void load(GThemeValueMap valueMap) {
        if (valueMap == null) {
            return;
        }
        valueMap.colorMap.values().forEach(v -> this.addColor((ColorValue)v));
        valueMap.fontMap.values().forEach(v -> this.addFont((FontValue)v));
        valueMap.iconMap.values().forEach(v -> this.addIcon((IconValue)v));
        valueMap.propertyMap.values().forEach(v -> this.addProperty((JavaPropertyValue)v));
    }

    public List<ColorValue> getColors() {
        return new ArrayList<ColorValue>(this.colorMap.values());
    }

    public List<FontValue> getFonts() {
        return new ArrayList<FontValue>(this.fontMap.values());
    }

    public List<IconValue> getIcons() {
        return new ArrayList<IconValue>(this.iconMap.values());
    }

    public List<JavaPropertyValue> getProperties() {
        return new ArrayList<JavaPropertyValue>(this.propertyMap.values());
    }

    public boolean containsColor(String id) {
        return this.colorMap.containsKey(id);
    }

    public boolean containsFont(String id) {
        return this.fontMap.containsKey(id);
    }

    public boolean containsIcon(String id) {
        return this.iconMap.containsKey(id);
    }

    public boolean containsProperty(String id) {
        return this.propertyMap.containsKey(id);
    }

    public Object size() {
        return this.colorMap.size() + this.fontMap.size() + this.iconMap.size() + this.propertyMap.size();
    }

    public void clear() {
        this.colorMap.clear();
        this.fontMap.clear();
        this.iconMap.clear();
        this.propertyMap.clear();
    }

    public boolean isEmpty() {
        return this.colorMap.isEmpty() && this.fontMap.isEmpty() && this.iconMap.isEmpty() && this.propertyMap.isEmpty();
    }

    public void removeColor(String id) {
        this.colorMap.remove(id);
    }

    public void removeFont(String id) {
        this.fontMap.remove(id);
    }

    public void removeIcon(String id) {
        this.iconMap.remove(id);
    }

    public void removeProperty(String id) {
        this.propertyMap.remove(id);
    }

    public GThemeValueMap getChangedValues(GThemeValueMap base) {
        GThemeValueMap map = new GThemeValueMap();
        for (ColorValue color : this.colorMap.values()) {
            if (color.equals(base.getColor(color.getId()))) continue;
            map.addColor(color);
        }
        for (FontValue font : this.fontMap.values()) {
            if (font.equals(base.getFont(font.getId()))) continue;
            map.addFont(font);
        }
        for (IconValue icon : this.iconMap.values()) {
            if (icon.equals(base.getIcon(icon.getId()))) continue;
            map.addIcon(icon);
        }
        for (JavaPropertyValue property : this.propertyMap.values()) {
            if (property.equals(base.getProperty(property.getId()))) continue;
            map.addProperty(property);
        }
        return map;
    }

    public Set<File> getExternalIconFiles() {
        HashSet<File> files = new HashSet<File>();
        for (IconValue iconValue : this.iconMap.values()) {
            File iconFile;
            URL url;
            String filePath;
            UrlImageIcon urlIcon;
            String originalPath;
            Icon icon = (Icon)iconValue.getRawValue();
            if (!(icon instanceof UrlImageIcon) || !(originalPath = (urlIcon = (UrlImageIcon)icon).getOriginalPath()).startsWith("[EXTERNAL]") || (filePath = (url = urlIcon.getUrl()).getFile()) == null || !(iconFile = new File(filePath)).exists()) continue;
            files.add(iconFile);
        }
        return files;
    }

    public int hashCode() {
        return Objects.hash(this.colorMap, this.fontMap, this.iconMap, this.propertyMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GThemeValueMap other = (GThemeValueMap)obj;
        return Objects.equals(this.colorMap, other.colorMap) && Objects.equals(this.fontMap, other.fontMap) && Objects.equals(this.iconMap, other.iconMap) && Objects.equals(this.propertyMap, other.propertyMap);
    }

    public void checkForUnresolvedReferences() {
        for (ColorValue colorValue : this.colorMap.values()) {
            colorValue.get(this);
        }
        for (FontValue fontValue : this.fontMap.values()) {
            fontValue.get(this);
        }
        for (IconValue iconValue : this.iconMap.values()) {
            iconValue.get(this);
        }
        for (JavaPropertyValue propertyValue : this.propertyMap.values()) {
            propertyValue.get(this);
        }
    }

    public Set<String> getColorIds() {
        return this.colorMap.keySet();
    }

    public Set<String> getFontIds() {
        return this.fontMap.keySet();
    }

    public Set<String> getIconIds() {
        return this.iconMap.keySet();
    }

    public Set<String> getPropertyIds() {
        return this.propertyMap.keySet();
    }

    public Color getResolvedColor(String id) {
        ColorValue colorValue = this.colorMap.get(id);
        if (colorValue != null) {
            return (Color)colorValue.get(this);
        }
        return null;
    }

    public Font getResolvedFont(String id) {
        FontValue fontValue = this.fontMap.get(id);
        if (fontValue != null) {
            return fontValue.get(this);
        }
        return null;
    }

    public Icon getResolvedIcon(String id) {
        IconValue iconValue = this.iconMap.get(id);
        if (iconValue != null) {
            return iconValue.get(this);
        }
        return null;
    }

    public Object getResolvedProperty(String id) {
        JavaPropertyValue propertyValue = this.propertyMap.get(id);
        if (propertyValue != null) {
            return propertyValue.get(this);
        }
        return null;
    }
}

