/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.datatable.ProjectTreeAction;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeClipboardUtils;
import ghidra.framework.main.datatree.DataTreeNode;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.main.projectdata.actions.ProjectDataPasteAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import resources.Icons;
import resources.MultiIcon;

public class ProjectDataPasteLinkAction
extends ProjectTreeAction {
    private static Icon baseIcon = Icons.PASTE_ICON;
    private boolean relative;

    public ProjectDataPasteLinkAction(String owner, String group, boolean relative) {
        super("Paste " + ProjectDataPasteLinkAction.getLinkType(relative), owner);
        this.relative = relative;
        this.setPopupMenuData(new MenuData(new String[]{"Paste as " + ProjectDataPasteLinkAction.getLinkType(relative)}, ProjectDataPasteLinkAction.getIcon(), group));
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Paste_Link"));
    }

    private static String getLinkType(boolean relative) {
        return relative ? "Relative-Link" : "Link";
    }

    private static Icon getIcon() {
        MultiIcon multiIcon = new MultiIcon(baseIcon);
        multiIcon.addIcon(LinkHandler.LINK_ICON);
        return multiIcon;
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        DataTreeNode copyNode;
        if (!this.isEnabledForContext(context)) {
            return;
        }
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolder destFolder = DataTree.getRealInternalFolderForNode(node);
        if (destFolder == null) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)((Object)context.getTree()), (String)"Unsupported Operation", (Object)"Unsupported paste link condition");
        }
        if ((copyNode = this.getFolderOrFileCopyNode()) instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)copyNode;
            try {
                DomainFile domainFile = fileNode.getDomainFile();
                domainFile.copyToAsLink(destFolder, this.relative);
            }
            catch (IOException e) {
                Msg.showError(((Object)((Object)this)).getClass(), (Component)((Object)context.getTree()), (String)"Cannot Create Link", (Object)"Error occured while creating link file", (Throwable)e);
            }
        } else {
            try {
                DomainFolder domainFolder = ((DomainFolderNode)copyNode).getDomainFolder();
                domainFolder.copyToAsLink(destFolder, this.relative);
            }
            catch (IOException e) {
                Msg.showError(((Object)((Object)this)).getClass(), (Component)((Object)context.getTree()), (String)"Cannot Create Link", (Object)"Error occured while creating link file", (Throwable)e);
            }
        }
    }

    @Override
    protected boolean isEnabledForContext(FrontEndProjectTreeContext context) {
        if (!context.isInActiveProject() || !context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        GTreeNode node = (GTreeNode)context.getContextObject();
        DomainFolder destFolder = DataTree.getRealInternalFolderForNode(node);
        if (!ProjectDataPasteAction.checkNodeForPaste(destFolder)) {
            return false;
        }
        Project activeProject = AppInfo.getActiveProject();
        DataTreeNode copyNode = this.getFolderOrFileCopyNode();
        if (copyNode != null) {
            if (this.relative && copyNode.getProjectData() != activeProject.getProjectData()) {
                return false;
            }
            if (copyNode instanceof DomainFileNode) {
                DomainFileNode fileNode = (DomainFileNode)copyNode;
                DomainFile domainFile = fileNode.getDomainFile();
                try {
                    ContentHandler<?> contentHandler = DomainObjectAdapter.getContentHandler(domainFile.getContentType());
                    return contentHandler.getLinkHandler() != null;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private DataTreeNode getFolderOrFileCopyNode() {
        DomainFolderNode folderNode;
        DomainFileNode fileNode;
        List<GTreeNode> list = DataTreeClipboardUtils.getDataTreeNodesFromClipboard();
        if (list.size() != 1) {
            return null;
        }
        GTreeNode copyNode = list.get(0);
        if (copyNode instanceof DomainFileNode && !(fileNode = (DomainFileNode)copyNode).isCut()) {
            return fileNode;
        }
        if (copyNode instanceof DomainFolderNode && !(folderNode = (DomainFolderNode)copyNode).isCut()) {
            return folderNode;
        }
        return null;
    }
}

