/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DialogComponentProvider;
import docking.widgets.label.GLabel;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordChangeDialog
extends DialogComponentProvider {
    JPasswordField passwordField1;
    JPasswordField passwordField2;
    char[] newPassword = null;

    public PasswordChangeDialog(String title, String serverType, String serverName, String userID) {
        super(title, true);
        this.createWorkPanel(serverType, serverName, userID);
    }

    private void createWorkPanel(String serverType, String serverName, String userID) {
        JPanel wp = new JPanel((LayoutManager)new PairLayout(5, 5));
        wp.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        if (serverName != null) {
            wp.add(new GLabel(serverType + ":"));
            wp.add(new GLabel(serverName));
        }
        if (userID != null) {
            wp.add(new GLabel("User ID:"));
            GLabel nameLabel = new GLabel(userID);
            nameLabel.setName("NAME-COMPONENT");
            nameLabel.getAccessibleContext().setAccessibleName("Name");
            wp.add(nameLabel);
        }
        wp.add(new GLabel("New Password:"));
        this.passwordField1 = new JPasswordField(16);
        this.passwordField1.setName("PASSWORD-ENTRY1-COMPONENT");
        this.passwordField1.getAccessibleContext().setAccessibleName("Password Entry 1");
        wp.add(this.passwordField1);
        wp.add(new GLabel("Repeat Password:"));
        this.passwordField2 = new JPasswordField(16);
        this.passwordField2.setName("PASSWORD-ENTRY2-COMPONENT");
        this.passwordField2.getAccessibleContext().setAccessibleName("Password Entry 2");
        this.passwordField2.addActionListener(e -> this.okCallback());
        wp.add(this.passwordField2);
        wp.add(new GLabel());
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            private void displayWarning() {
                try {
                    boolean capsLockOn = Toolkit.getDefaultToolkit().getLockingKeyState(20);
                    if (capsLockOn) {
                        PasswordChangeDialog.this.setStatusText("Warning! Caps-Lock is on", MessageType.WARNING);
                    } else {
                        PasswordChangeDialog.this.clearStatusText();
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.displayWarning();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.displayWarning();
            }
        };
        this.passwordField1.addKeyListener(keyListener);
        this.passwordField2.addKeyListener(keyListener);
        wp.getAccessibleContext().setAccessibleName("Password Change");
        this.addWorkPanel(wp);
        this.addOKButton();
        this.addCancelButton();
    }

    public char[] getPassword() {
        return this.newPassword != null ? (char[])this.newPassword.clone() : null;
    }

    @Override
    protected void okCallback() {
        this.newPassword = this.passwordField1.getPassword();
        boolean success = false;
        try {
            if (this.newPassword.length < 6) {
                Msg.showError((Object)this, (Component)this.getComponent(), (String)"Password Error", (Object)"Password must be a minimum of 6 characters!");
                return;
            }
            if (!Arrays.equals(this.newPassword, this.passwordField2.getPassword())) {
                Msg.showError((Object)this, (Component)this.getComponent(), (String)"Password Error", (Object)"Passwords do not match!");
                return;
            }
            success = true;
        }
        finally {
            if (!success) {
                Arrays.fill(this.newPassword, ' ');
                this.newPassword = null;
            }
        }
        this.close();
    }

    @Override
    public void close() {
        this.closeDialog();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.newPassword != null) {
            Arrays.fill(this.newPassword, ' ');
            this.newPassword = null;
        }
        if (this.passwordField1 != null) {
            this.getComponent().remove(this.passwordField1);
            this.passwordField1.setText("");
            this.passwordField1 = null;
            this.passwordField2.setText("");
            this.getComponent().remove(this.passwordField2);
            this.passwordField2 = null;
        }
    }
}

